/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.time;

import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.time.TimeInterpolator;

public class SpeedTimeInterpolator
implements TimeInterpolator {
    private static final String TAG = SpeedTimeInterpolator.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private double mFactor;
    private long mLastRealTime = Long.MIN_VALUE;
    private long mLastCorrectedTime = Long.MIN_VALUE;

    public SpeedTimeInterpolator(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Invalid speed factor: " + factor);
        }
        this.mFactor = factor;
    }

    public float getFactor() {
        return (float)this.mFactor;
    }

    @Override
    public long interpolate(long time) {
        if (this.mLastRealTime == Long.MIN_VALUE) {
            this.mLastRealTime = time;
            this.mLastCorrectedTime = time;
        } else {
            long realDelta = time - this.mLastRealTime;
            long correctedDelta = (long)((double)realDelta / this.mFactor);
            this.mLastRealTime = time;
            this.mLastCorrectedTime += correctedDelta;
        }
        LOG.i("inputTime:" + time + " outputTime:" + this.mLastCorrectedTime);
        return this.mLastCorrectedTime;
    }
}

