/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.strategy.size;

import androidx.annotation.NonNull;
import com.otaliastudios.gif.strategy.size.Resizer;
import com.otaliastudios.gif.strategy.size.Size;

public class FractionResizer
implements Resizer {
    private final float fraction;

    public FractionResizer(float fraction) {
        if (fraction <= 0.0f || fraction > 1.0f) {
            throw new IllegalArgumentException("Fraction must be > 0 and <= 1");
        }
        this.fraction = fraction;
    }

    @Override
    @NonNull
    public Size getOutputSize(@NonNull Size inputSize) {
        int minor = (int)(this.fraction * (float)inputSize.getMinor());
        int major = (int)(this.fraction * (float)inputSize.getMajor());
        if (minor % 2 != 0) {
            --minor;
        }
        if (major % 2 != 0) {
            --major;
        }
        return new Size(minor, major);
    }
}

