/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.strategy;

import android.media.MediaFormat;
import android.os.Build;
import androidx.annotation.NonNull;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.strategy.Strategy;
import com.otaliastudios.gif.strategy.size.AspectRatioResizer;
import com.otaliastudios.gif.strategy.size.AtMostResizer;
import com.otaliastudios.gif.strategy.size.ExactResizer;
import com.otaliastudios.gif.strategy.size.ExactSize;
import com.otaliastudios.gif.strategy.size.FractionResizer;
import com.otaliastudios.gif.strategy.size.MultiResizer;
import com.otaliastudios.gif.strategy.size.Resizer;
import com.otaliastudios.gif.strategy.size.Size;
import java.util.List;

public class DefaultStrategy
implements Strategy {
    private static final String TAG = DefaultStrategy.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    public static final long BITRATE_UNKNOWN = Long.MIN_VALUE;
    public static final float DEFAULT_KEY_FRAME_INTERVAL = 3.0f;
    public static final int DEFAULT_FRAME_RATE = 30;
    private final Options options;

    @NonNull
    public static Builder exact(int firstSize, int secondSize) {
        return new Builder(new ExactResizer(firstSize, secondSize));
    }

    @NonNull
    public static Builder fraction(float fraction) {
        return new Builder(new FractionResizer(fraction));
    }

    @NonNull
    public static Builder aspectRatio(float aspectRatio) {
        return new Builder(new AspectRatioResizer(aspectRatio));
    }

    @NonNull
    public static Builder atMost(int atMostSize) {
        return new Builder(new AtMostResizer(atMostSize));
    }

    @NonNull
    public static Builder atMost(int atMostMinor, int atMostMajor) {
        return new Builder(new AtMostResizer(atMostMinor, atMostMajor));
    }

    public DefaultStrategy(@NonNull Options options) {
        this.options = options;
    }

    @Override
    public void createOutputFormat(@NonNull List<MediaFormat> inputFormats, @NonNull MediaFormat outputFormat) {
        int outHeight;
        int outWidth;
        Size outSize;
        ExactSize inSize = this.getBestInputSize(inputFormats);
        int inWidth = inSize.getWidth();
        int inHeight = inSize.getHeight();
        LOG.i("Input width&height: " + inWidth + "x" + inHeight);
        try {
            outSize = this.options.resizer.getOutputSize(inSize);
        }
        catch (Exception e) {
            throw new RuntimeException("Resizer error:", e);
        }
        if (outSize instanceof ExactSize) {
            outWidth = ((ExactSize)outSize).getWidth();
            outHeight = ((ExactSize)outSize).getHeight();
        } else if (inWidth >= inHeight) {
            outWidth = outSize.getMajor();
            outHeight = outSize.getMinor();
        } else {
            outWidth = outSize.getMinor();
            outHeight = outSize.getMajor();
        }
        LOG.i("Output width&height: " + outWidth + "x" + outHeight);
        int inputFrameRate = this.getMinFrameRate(inputFormats);
        int outFrameRate = inputFrameRate > 0 ? Math.min(inputFrameRate, this.options.targetFrameRate) : this.options.targetFrameRate;
        outputFormat.setString("mime", this.options.targetMimeType);
        outputFormat.setInteger("width", outWidth);
        outputFormat.setInteger("height", outHeight);
        outputFormat.setInteger("rotation-degrees", 0);
        outputFormat.setInteger("frame-rate", outFrameRate);
        if (Build.VERSION.SDK_INT >= 25) {
            outputFormat.setFloat("i-frame-interval", this.options.targetKeyFrameInterval);
        } else {
            outputFormat.setInteger("i-frame-interval", (int)Math.ceil(this.options.targetKeyFrameInterval));
        }
        outputFormat.setInteger("color-format", 2130708361);
        int outBitRate = (int)(this.options.targetBitRate == Long.MIN_VALUE ? DefaultStrategy.estimateBitRate(outWidth, outHeight, outFrameRate) : this.options.targetBitRate);
        outputFormat.setInteger("bitrate", outBitRate);
    }

    private ExactSize getBestInputSize(@NonNull List<MediaFormat> formats) {
        int count = formats.size();
        float averageAspectRatio = 0.0f;
        float[] aspectRatio = new float[count];
        boolean[] flipSize = new boolean[count];
        for (int i = 0; i < count; ++i) {
            boolean flip;
            MediaFormat format = formats.get(i);
            float width = format.getInteger("width");
            float height = format.getInteger("height");
            int rotation = 0;
            if (format.containsKey("rotation-degrees")) {
                rotation = format.getInteger("rotation-degrees");
            }
            flipSize[i] = flip = rotation % 180 != 0;
            aspectRatio[i] = flip ? height / width : width / height;
            averageAspectRatio += aspectRatio[i];
        }
        averageAspectRatio /= (float)count;
        float bestDelta = Float.MAX_VALUE;
        int bestMatch = 0;
        for (int i = 0; i < count; ++i) {
            float delta = Math.abs(aspectRatio[i] - averageAspectRatio);
            if (!(delta < bestDelta)) continue;
            bestMatch = i;
            bestDelta = delta;
        }
        MediaFormat bestFormat = formats.get(bestMatch);
        int bestWidth = bestFormat.getInteger("width");
        int bestHeight = bestFormat.getInteger("height");
        return new ExactSize(flipSize[bestMatch] ? bestHeight : bestWidth, flipSize[bestMatch] ? bestWidth : bestHeight);
    }

    private int getMinFrameRate(@NonNull List<MediaFormat> formats) {
        int frameRate = Integer.MAX_VALUE;
        for (MediaFormat format : formats) {
            if (!format.containsKey("frame-rate")) continue;
            frameRate = Math.min(frameRate, format.getInteger("frame-rate"));
        }
        return frameRate == Integer.MAX_VALUE ? -1 : frameRate;
    }

    private static long estimateBitRate(int width, int height, int frameRate) {
        return (long)(0.14f * (float)width * (float)height * (float)Math.max(frameRate, 24));
    }

    public static class Builder {
        private MultiResizer resizer = new MultiResizer();
        private int targetFrameRate = 30;
        private long targetBitRate = Long.MIN_VALUE;
        private float targetKeyFrameInterval = 3.0f;
        private String targetMimeType = "video/avc";

        public Builder() {
        }

        public Builder(@NonNull Resizer resizer) {
            this.resizer.addResizer(resizer);
        }

        @NonNull
        public Builder addResizer(@NonNull Resizer resizer) {
            this.resizer.addResizer(resizer);
            return this;
        }

        @NonNull
        public Builder bitRate(long bitRate) {
            this.targetBitRate = bitRate;
            return this;
        }

        @NonNull
        public Builder frameRate(int frameRate) {
            this.targetFrameRate = frameRate;
            return this;
        }

        @NonNull
        public Builder keyFrameInterval(float keyFrameInterval) {
            this.targetKeyFrameInterval = keyFrameInterval;
            return this;
        }

        @NonNull
        public Builder mimeType(@NonNull String mimeType) {
            this.targetMimeType = mimeType;
            return this;
        }

        @NonNull
        public Options options() {
            Options options = new Options();
            options.resizer = this.resizer;
            options.targetFrameRate = this.targetFrameRate;
            options.targetBitRate = this.targetBitRate;
            options.targetKeyFrameInterval = this.targetKeyFrameInterval;
            options.targetMimeType = this.targetMimeType;
            return options;
        }

        @NonNull
        public DefaultStrategy build() {
            return new DefaultStrategy(this.options());
        }
    }

    public static class Options {
        private Resizer resizer;
        private long targetBitRate;
        private int targetFrameRate;
        private float targetKeyFrameInterval;
        private String targetMimeType;

        private Options() {
        }
    }
}

