/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.source;

import android.content.Context;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.gifdecoder.GifHeader;
import com.bumptech.glide.gifdecoder.GifHeaderParser;
import com.bumptech.glide.gifdecoder.StandardGifDecoder;
import com.bumptech.glide.load.resource.gif.GifBitmapProvider;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.source.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;

public abstract class DefaultDataSource
implements DataSource {
    private static final String TAG = DefaultDataSource.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private Context mContext;
    private GifHeader mGifHeader;
    private GifDecoder mGifDecoder;
    private int mGifFrame = 0;
    private int mGifFrames;
    private MediaFormat mFormat;
    private final long mFirstTimestampUs = 10L;
    private long mLastTimestampUs = 10L;
    private long mDurationUs = Long.MIN_VALUE;

    protected DefaultDataSource(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
    }

    @NonNull
    protected abstract InputStream openInputStream();

    private byte[] getInputStreamData() {
        try {
            int readBytes;
            InputStream inputStream = this.openInputStream();
            byte[] buffer = new byte[16384];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((readBytes = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, readBytes);
            }
            outputStream.flush();
            byte[] data = outputStream.toByteArray();
            inputStream.close();
            outputStream.close();
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureGifHeader() {
        if (this.mGifHeader != null) {
            return;
        }
        GifHeaderParser parser = new GifHeaderParser();
        parser.setData(this.getInputStreamData());
        this.mGifHeader = parser.parseHeader();
        parser.clear();
        if (this.mGifHeader.getStatus() != 0) {
            throw new RuntimeException("Illegal status: " + this.mGifHeader.getStatus());
        }
    }

    private void ensureGifDecoder() {
        if (this.mGifDecoder != null) {
            return;
        }
        this.ensureGifHeader();
        GifBitmapProvider provider = new GifBitmapProvider(Glide.get((Context)this.mContext).getBitmapPool(), Glide.get((Context)this.mContext).getArrayPool());
        this.mGifDecoder = new StandardGifDecoder((GifDecoder.BitmapProvider)provider);
        this.mGifDecoder.setData(this.mGifHeader, this.getInputStreamData());
        this.mGifFrames = this.mGifDecoder.getFrameCount() + 1;
    }

    @Override
    public long getDurationUs() {
        if (this.mDurationUs == Long.MIN_VALUE) {
            this.ensureGifHeader();
            long durationUs = 0L;
            try {
                Field framesField = GifHeader.class.getDeclaredField("frames");
                framesField.setAccessible(true);
                List frames = (List)framesField.get(this.mGifHeader);
                Class<?> frameClass = Class.forName("com.bumptech.glide.gifdecoder.GifFrame");
                Field frameDelayField = frameClass.getDeclaredField("delay");
                frameDelayField.setAccessible(true);
                for (Object frame : frames) {
                    durationUs += (long)frameDelayField.getInt(frame) * 1000L;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.mDurationUs = durationUs;
        }
        return this.mDurationUs;
    }

    @Override
    @NonNull
    public MediaFormat getTrackFormat() {
        if (this.mFormat == null) {
            this.ensureGifHeader();
            this.mFormat = new MediaFormat();
            this.mFormat.setInteger("width", this.mGifHeader.getWidth());
            this.mFormat.setInteger("height", this.mGifHeader.getHeight());
            this.mFormat.setInteger("rotation-degrees", 0);
            int frames = this.mGifHeader.getNumFrames();
            double durationSeconds = (double)this.getDurationUs() / 1000000.0;
            int framesPerSecond = (int)Math.round((double)frames / durationSeconds);
            this.mFormat.setInteger("frame-rate", framesPerSecond);
        }
        return this.mFormat;
    }

    @Override
    public void start() {
        this.ensureGifDecoder();
        this.mGifFrame = -1;
    }

    @Override
    public void read(@NonNull DataSource.Chunk chunk) {
        this.mGifDecoder.advance();
        ++this.mGifFrame;
        if (this.mGifFrame == 0) {
            this.mLastTimestampUs = 10L;
            chunk.bitmap = this.mGifDecoder.getNextFrame();
        } else if (this.mGifFrame < this.mGifDecoder.getFrameCount() - 1) {
            this.mLastTimestampUs += (long)this.mGifDecoder.getDelay(this.mGifFrame - 1) * 1000L;
            chunk.bitmap = this.mGifDecoder.getNextFrame();
        } else {
            this.mLastTimestampUs += (long)this.mGifDecoder.getDelay(this.mGifFrame - 1) * 1000L;
        }
        chunk.timestampUs = this.mLastTimestampUs;
    }

    @Override
    public void release() {
        this.mGifHeader = null;
        if (this.mGifDecoder != null) {
            this.mGifDecoder.clear();
            this.mGifDecoder = null;
        }
    }

    @Override
    public boolean isDrained() {
        return this.mGifFrame == this.mGifFrames - 1;
    }

    @Override
    public final long getReadUs() {
        return this.mLastTimestampUs - 10L;
    }
}

