/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.sink;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.annotation.NonNull;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.sink.DataSink;
import com.otaliastudios.gif.sink.DefaultDataSinkChecks;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class DefaultDataSink
implements DataSink {
    private static final String TAG = DefaultDataSink.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private static final int BUFFER_SIZE = 65536;
    private boolean mMuxerStarted = false;
    private final MediaMuxer mMuxer;
    private final List<QueuedSample> mQueue = new ArrayList<QueuedSample>();
    private ByteBuffer mQueueBuffer;
    private int mMuxerIndex;
    private final DefaultDataSinkChecks mMuxerChecks = new DefaultDataSinkChecks();

    public DefaultDataSink(@NonNull String outputFilePath) {
        this(outputFilePath, 0);
    }

    public DefaultDataSink(@NonNull String outputFilePath, int format) {
        try {
            this.mMuxer = new MediaMuxer(outputFilePath, format);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOrientation(int rotation) {
        this.mMuxer.setOrientationHint(rotation);
    }

    @Override
    public void setFormat(@NonNull MediaFormat format) {
        this.mMuxerChecks.checkOutputFormat(format);
        if (this.mMuxerStarted) {
            return;
        }
        this.mMuxerIndex = this.mMuxer.addTrack(format);
        LOG.v("Added track #" + this.mMuxerIndex + " with " + format.getString("mime") + " to muxer");
        this.mMuxer.start();
        this.mMuxerStarted = true;
        this.drainQueue();
    }

    @Override
    public void write(@NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (this.mMuxerStarted) {
            this.mMuxer.writeSampleData(this.mMuxerIndex, byteBuffer, bufferInfo);
        } else {
            this.enqueue(byteBuffer, bufferInfo);
        }
    }

    private void enqueue(@NonNull ByteBuffer buffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (this.mQueueBuffer == null) {
            this.mQueueBuffer = ByteBuffer.allocateDirect(65536).order(ByteOrder.nativeOrder());
        }
        buffer.limit(bufferInfo.offset + bufferInfo.size);
        buffer.position(bufferInfo.offset);
        this.mQueueBuffer.put(buffer);
        this.mQueue.add(new QueuedSample(bufferInfo));
    }

    private void drainQueue() {
        if (this.mQueue.isEmpty()) {
            return;
        }
        this.mQueueBuffer.flip();
        LOG.i("Output format determined, writing pending data into the muxer. samples:" + this.mQueue.size() + " bytes:" + this.mQueueBuffer.limit());
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        int offset = 0;
        for (QueuedSample sample : this.mQueue) {
            bufferInfo.set(offset, sample.mSize, sample.mTimeUs, sample.mFlags);
            this.write(this.mQueueBuffer, bufferInfo);
            offset += sample.mSize;
        }
        this.mQueue.clear();
        this.mQueueBuffer = null;
    }

    @Override
    public void stop() {
        this.mMuxer.stop();
    }

    @Override
    public void release() {
        try {
            this.mMuxer.release();
        }
        catch (Exception e) {
            LOG.w("Failed to release the muxer.", e);
        }
    }

    private static class QueuedSample {
        private final int mSize;
        private final long mTimeUs;
        private final int mFlags;

        private QueuedSample(@NonNull MediaCodec.BufferInfo bufferInfo) {
            this.mSize = bufferInfo.size;
            this.mTimeUs = bufferInfo.presentationTimeUs;
            this.mFlags = bufferInfo.flags;
        }
    }
}

