/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif.engine;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.gif.GIFOptions;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.sink.DataSink;
import com.otaliastudios.gif.source.DataSource;
import com.otaliastudios.gif.time.TimeInterpolator;
import com.otaliastudios.gif.transcode.Transcoder;
import com.otaliastudios.gif.transcode.VideoTranscoder;
import java.util.ArrayList;
import java.util.List;

public class Engine {
    private static final String TAG = Engine.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private static final long TRANSCODER_SLEEP_TIME = 10L;
    private static final long PROGRESS_INTERVAL_STEPS = 10L;
    private DataSink mDataSink;
    private List<DataSource> mDataSources = null;
    private final List<Transcoder> mTranscoders = new ArrayList<Transcoder>();
    private final List<TimeInterpolator> mInterpolators = new ArrayList<TimeInterpolator>();
    private int mCurrentStep = 0;
    private MediaFormat mOutputFormat = null;
    private volatile double mProgress;
    private final ProgressCallback mProgressCallback;

    public Engine(@Nullable ProgressCallback progressCallback) {
        this.mProgressCallback = progressCallback;
    }

    public double getProgress() {
        return this.mProgress;
    }

    private void setProgress(double progress) {
        this.mProgress = progress;
        if (this.mProgressCallback != null) {
            this.mProgressCallback.onProgress(progress);
        }
    }

    private boolean isCompleted() {
        return this.mCurrentStep == this.mDataSources.size() - 1 && this.mCurrentStep == this.mTranscoders.size() - 1 && this.mTranscoders.get(this.mCurrentStep).isFinished();
    }

    private void openCurrentStep(@NonNull GIFOptions options) {
        DataSource dataSource = this.mDataSources.get(this.mCurrentStep);
        dataSource.start();
        TimeInterpolator interpolator = this.createStepTimeInterpolator(this.mCurrentStep, options.getTimeInterpolator());
        this.mInterpolators.add(interpolator);
        VideoTranscoder transcoder = new VideoTranscoder(dataSource, this.mDataSink, interpolator, options.getRotation());
        transcoder.setUp(this.mOutputFormat);
        this.mTranscoders.add(transcoder);
    }

    private void closeCurrentStep() {
        this.mTranscoders.get(this.mCurrentStep).release();
        this.mDataSources.get(this.mCurrentStep).release();
        ++this.mCurrentStep;
    }

    @NonNull
    private Transcoder getCurrentStepTranscoder(@NonNull GIFOptions options) {
        int current = this.mCurrentStep;
        int last = this.mTranscoders.size() - 1;
        if (last == current) {
            Transcoder transcoder = this.mTranscoders.get(last);
            if (transcoder.isFinished()) {
                this.closeCurrentStep();
                return this.getCurrentStepTranscoder(options);
            }
            return this.mTranscoders.get(current);
        }
        if (last < current) {
            this.openCurrentStep(options);
            return this.mTranscoders.get(current);
        }
        throw new IllegalStateException("This should never happen. last:" + last + ", current:" + current);
    }

    @NonNull
    private TimeInterpolator createStepTimeInterpolator(int step, final @NonNull TimeInterpolator wrap) {
        long timebase;
        if (step > 0) {
            TimeInterpolator previous = this.mInterpolators.get(step - 1);
            timebase = previous.interpolate(Long.MAX_VALUE);
        } else {
            timebase = 0L;
        }
        return new TimeInterpolator(){
            private long mLastInterpolatedTime;
            private long mFirstInputTime = Long.MAX_VALUE;
            private long mTimeBase = timebase + 10L;

            @Override
            public long interpolate(long time) {
                if (time == Long.MAX_VALUE) {
                    return this.mLastInterpolatedTime;
                }
                if (this.mFirstInputTime == Long.MAX_VALUE) {
                    this.mFirstInputTime = time;
                }
                this.mLastInterpolatedTime = this.mTimeBase + (time - this.mFirstInputTime);
                return wrap.interpolate(this.mLastInterpolatedTime);
            }
        };
    }

    private long getTotalDurationUs() {
        long totalDurationUs = 0L;
        for (int i = 0; i < this.mDataSources.size(); ++i) {
            DataSource source = this.mDataSources.get(i);
            if (i < this.mCurrentStep) {
                totalDurationUs += source.getReadUs();
                continue;
            }
            totalDurationUs += source.getDurationUs();
        }
        return totalDurationUs;
    }

    private long getTotalReadUs() {
        long completedDurationUs = 0L;
        for (int i = 0; i < this.mDataSources.size(); ++i) {
            DataSource source = this.mDataSources.get(i);
            if (i > this.mCurrentStep) continue;
            completedDurationUs += source.getReadUs();
        }
        return completedDurationUs;
    }

    private double computeProgress() {
        long readUs = this.getTotalReadUs();
        long totalUs = this.getTotalDurationUs();
        LOG.v("computeProgress - readUs:" + readUs + ", totalUs:" + totalUs);
        if (totalUs == 0L) {
            totalUs = 1L;
        }
        return (double)readUs / (double)totalUs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(@NonNull GIFOptions options) throws InterruptedException {
        this.mDataSink = options.getDataSink();
        this.mDataSources = options.getDataSources();
        this.mDataSink.setOrientation(0);
        MediaFormat outputFormat = new MediaFormat();
        ArrayList<MediaFormat> inputFormats = new ArrayList<MediaFormat>();
        for (DataSource source : options.getDataSources()) {
            MediaFormat inputFormat = source.getTrackFormat();
            inputFormats.add(inputFormat);
        }
        options.getStrategy().createOutputFormat(inputFormats, outputFormat);
        this.mOutputFormat = outputFormat;
        LOG.v("Duration (us): " + this.getTotalDurationUs());
        try {
            long loopCount = 0L;
            boolean advanced = false;
            boolean isCompleted = false;
            double progress = 0.0;
            while (!isCompleted) {
                LOG.v("new loop: " + loopCount);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                advanced = false;
                isCompleted = this.isCompleted();
                if (!isCompleted) {
                    advanced = this.getCurrentStepTranscoder(options).transcode(false);
                }
                if (++loopCount % 10L == 0L) {
                    progress = this.computeProgress();
                    LOG.v("progress:" + progress);
                    this.setProgress(progress);
                }
                if (advanced) continue;
                Thread.sleep(10L);
            }
            this.mDataSink.stop();
        }
        finally {
            try {
                this.closeCurrentStep();
            }
            catch (Exception exception) {}
            this.mDataSink.release();
        }
    }

    public static interface ProgressCallback {
        public void onProgress(double var1);
    }
}

