/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.gif.GIFCompressor;
import com.otaliastudios.gif.GIFListener;
import com.otaliastudios.gif.sink.DataSink;
import com.otaliastudios.gif.sink.DefaultDataSink;
import com.otaliastudios.gif.source.DataSource;
import com.otaliastudios.gif.source.FileDescriptorDataSource;
import com.otaliastudios.gif.source.FilePathDataSource;
import com.otaliastudios.gif.source.UriDataSource;
import com.otaliastudios.gif.strategy.DefaultStrategies;
import com.otaliastudios.gif.strategy.Strategy;
import com.otaliastudios.gif.time.DefaultTimeInterpolator;
import com.otaliastudios.gif.time.SpeedTimeInterpolator;
import com.otaliastudios.gif.time.TimeInterpolator;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class GIFOptions {
    private DataSink dataSink;
    private List<DataSource> dataSources;
    private Strategy strategy;
    private int rotation;
    private TimeInterpolator timeInterpolator;
    GIFListener listener;
    Handler listenerHandler;

    private GIFOptions() {
    }

    @NonNull
    public DataSink getDataSink() {
        return this.dataSink;
    }

    @NonNull
    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    @NonNull
    public Strategy getStrategy() {
        return this.strategy;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NonNull
    public TimeInterpolator getTimeInterpolator() {
        return this.timeInterpolator;
    }

    public static class Builder {
        private DataSink dataSink;
        private final List<DataSource> dataSources = new ArrayList<DataSource>();
        private GIFListener listener;
        private Handler listenerHandler;
        private Strategy strategy;
        private int rotation;
        private TimeInterpolator timeInterpolator;

        Builder(@NonNull String outPath) {
            this.dataSink = new DefaultDataSink(outPath);
        }

        Builder(@NonNull DataSink dataSink) {
            this.dataSink = dataSink;
        }

        @NonNull
        public Builder addDataSource(@NonNull DataSource dataSource) {
            this.dataSources.add(dataSource);
            return this;
        }

        @NonNull
        public Builder addDataSource(@NonNull Context context, @NonNull FileDescriptor fileDescriptor) {
            return this.addDataSource(new FileDescriptorDataSource(context, fileDescriptor));
        }

        @NonNull
        public Builder addDataSource(@NonNull Context context, @NonNull String inPath) {
            return this.addDataSource(new FilePathDataSource(context, inPath));
        }

        @NonNull
        public Builder addDataSource(@NonNull Context context, @NonNull Uri uri) {
            return this.addDataSource(new UriDataSource(context, uri));
        }

        @NonNull
        public Builder setStrategy(@Nullable Strategy strategy) {
            this.strategy = strategy;
            return this;
        }

        @NonNull
        public Builder setListener(@NonNull GIFListener listener) {
            this.listener = listener;
            return this;
        }

        @NonNull
        public Builder setListenerHandler(@Nullable Handler listenerHandler) {
            this.listenerHandler = listenerHandler;
            return this;
        }

        @NonNull
        public Builder setRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        @NonNull
        public Builder setTimeInterpolator(@NonNull TimeInterpolator timeInterpolator) {
            this.timeInterpolator = timeInterpolator;
            return this;
        }

        @NonNull
        public Builder setSpeed(float speedFactor) {
            return this.setTimeInterpolator(new SpeedTimeInterpolator(speedFactor));
        }

        @NonNull
        public GIFOptions build() {
            if (this.listener == null) {
                throw new IllegalStateException("listener can't be null");
            }
            if (this.dataSources.isEmpty()) {
                throw new IllegalStateException("we need at least one data source");
            }
            if (this.rotation != 0 && this.rotation != 90 && this.rotation != 180 && this.rotation != 270) {
                throw new IllegalArgumentException("Accepted values for rotation are 0, 90, 180, 270");
            }
            if (this.listenerHandler == null) {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    looper = Looper.getMainLooper();
                }
                this.listenerHandler = new Handler(looper);
            }
            if (this.strategy == null) {
                this.strategy = DefaultStrategies.for720x1280();
            }
            if (this.timeInterpolator == null) {
                this.timeInterpolator = new DefaultTimeInterpolator();
            }
            GIFOptions options = new GIFOptions();
            options.listener = this.listener;
            options.dataSources = this.dataSources;
            options.dataSink = this.dataSink;
            options.listenerHandler = this.listenerHandler;
            options.strategy = this.strategy;
            options.rotation = this.rotation;
            options.timeInterpolator = this.timeInterpolator;
            return options;
        }

        @NonNull
        public Future<Void> compress() {
            return GIFCompressor.getInstance().compress(this.build());
        }
    }
}

