/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.gif;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.otaliastudios.gif.GIFListener;
import com.otaliastudios.gif.GIFOptions;
import com.otaliastudios.gif.engine.Engine;
import com.otaliastudios.gif.internal.Logger;
import com.otaliastudios.gif.sink.DataSink;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GIFCompressor {
    private static final String TAG = GIFCompressor.class.getSimpleName();
    private static final Logger LOG = new Logger(TAG);
    private static volatile GIFCompressor sGIFCompressor;
    private ThreadPoolExecutor mExecutor;

    private GIFCompressor() {
        int pool = Runtime.getRuntime().availableProcessors() + 1;
        this.mExecutor = new ThreadPoolExecutor(pool, pool, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new Factory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static GIFCompressor getInstance() {
        if (sGIFCompressor != null) return sGIFCompressor;
        Class<GIFCompressor> clazz = GIFCompressor.class;
        synchronized (GIFCompressor.class) {
            if (sGIFCompressor != null) return sGIFCompressor;
            sGIFCompressor = new GIFCompressor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sGIFCompressor;
        }
    }

    @NonNull
    public static GIFOptions.Builder into(@NonNull String outPath) {
        return new GIFOptions.Builder(outPath);
    }

    @NonNull
    public static GIFOptions.Builder into(@NonNull DataSink dataSink) {
        return new GIFOptions.Builder(dataSink);
    }

    @NonNull
    public Future<Void> compress(final @NonNull GIFOptions options) {
        final ListenerWrapper listenerWrapper = new ListenerWrapper(options.listenerHandler, options.listener);
        return this.mExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Engine engine = new Engine(new Engine.ProgressCallback(){

                        @Override
                        public void onProgress(double progress) {
                            listenerWrapper.onGIFCompressionProgress(progress);
                        }
                    });
                    engine.compress(options);
                    listenerWrapper.onGIFCompressionCompleted();
                }
                catch (Throwable e) {
                    Throwable current = e;
                    boolean isInterrupted = e instanceof InterruptedException;
                    while (!isInterrupted && current.getCause() != null && !current.getCause().equals(current)) {
                        if (!((current = current.getCause()) instanceof InterruptedException)) continue;
                        isInterrupted = true;
                    }
                    if (isInterrupted) {
                        LOG.i("Compression canceled.", current);
                        listenerWrapper.onGIFCompressionCanceled();
                    }
                    if (e instanceof RuntimeException) {
                        LOG.e("Fatal error while compressing, this might be invalid format or bug in engine or Android.", e);
                        listenerWrapper.onGIFCompressionFailed(e);
                        throw e;
                    }
                    LOG.e("Unexpected error while compressing", e);
                    listenerWrapper.onGIFCompressionFailed(e);
                    throw e;
                }
                return null;
            }
        });
    }

    private static class ListenerWrapper
    implements GIFListener {
        private Handler mHandler;
        private GIFListener mListener;

        private ListenerWrapper(@NonNull Handler handler, @NonNull GIFListener listener) {
            this.mHandler = handler;
            this.mListener = listener;
        }

        @Override
        public void onGIFCompressionCanceled() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerWrapper.this.mListener.onGIFCompressionCanceled();
                }
            });
        }

        @Override
        public void onGIFCompressionCompleted() {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerWrapper.this.mListener.onGIFCompressionCompleted();
                }
            });
        }

        @Override
        public void onGIFCompressionFailed(final @NonNull Throwable exception) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerWrapper.this.mListener.onGIFCompressionFailed(exception);
                }
            });
        }

        @Override
        public void onGIFCompressionProgress(final double progress) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ListenerWrapper.this.mListener.onGIFCompressionProgress(progress);
                }
            });
        }
    }

    private class Factory
    implements ThreadFactory {
        private AtomicInteger count = new AtomicInteger(1);

        private Factory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(runnable, TAG + " Thread #" + this.count.getAndIncrement());
        }
    }
}

