/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.hardware.Camera;
import androidx.annotation.NonNull;
import androidx.exifinterface.media.ExifInterface;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.engine.Camera1Engine;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.engine.orchestrator.CameraState;
import com.otaliastudios.cameraview.internal.ExifHelper;
import com.otaliastudios.cameraview.picture.FullPictureRecorder;
import com.otaliastudios.cameraview.size.Size;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Full1PictureRecorder
extends FullPictureRecorder {
    private final Camera mCamera;
    private final Camera1Engine mEngine;

    public Full1PictureRecorder(@NonNull PictureResult.Stub stub, @NonNull Camera1Engine engine, @NonNull Camera camera) {
        super(stub, engine);
        this.mEngine = engine;
        this.mCamera = camera;
        Camera.Parameters params = this.mCamera.getParameters();
        params.setRotation(this.mResult.rotation);
        this.mCamera.setParameters(params);
    }

    @Override
    public void take() {
        LOG.i("take() called.");
        this.mCamera.setPreviewCallbackWithBuffer(null);
        this.mEngine.getFrameManager().release();
        this.mCamera.takePicture(new Camera.ShutterCallback(){

            public void onShutter() {
                FullPictureRecorder.LOG.i("take(): got onShutter callback.");
                Full1PictureRecorder.this.dispatchOnShutter(true);
            }
        }, null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                int exifRotation;
                FullPictureRecorder.LOG.i("take(): got picture callback.");
                try {
                    ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(data));
                    int exifOrientation = exif.getAttributeInt("Orientation", 1);
                    exifRotation = ExifHelper.getOrientation(exifOrientation);
                }
                catch (IOException e) {
                    exifRotation = 0;
                }
                Full1PictureRecorder.this.mResult.data = data;
                Full1PictureRecorder.this.mResult.rotation = exifRotation;
                FullPictureRecorder.LOG.i("take(): starting preview again. ", Thread.currentThread());
                if (Full1PictureRecorder.this.mEngine.getState().isAtLeast(CameraState.PREVIEW)) {
                    camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)Full1PictureRecorder.this.mEngine);
                    Size previewStreamSize = Full1PictureRecorder.this.mEngine.getPreviewStreamSize(Reference.SENSOR);
                    if (previewStreamSize == null) {
                        throw new IllegalStateException("Preview stream size should never be null here.");
                    }
                    Full1PictureRecorder.this.mEngine.getFrameManager().setUp(Full1PictureRecorder.this.mEngine.getFrameProcessingFormat(), previewStreamSize, Full1PictureRecorder.this.mEngine.getAngles());
                    camera.startPreview();
                }
                Full1PictureRecorder.this.dispatchResult();
            }
        });
        LOG.i("take() returned.");
    }

    @Override
    protected void dispatchResult() {
        LOG.i("dispatching result. Thread:", Thread.currentThread());
        super.dispatchResult();
    }
}

