/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.filter.TwoParameterFilter;
import com.otaliastudios.opengl.core.Egloo;

public class VignetteFilter
extends BaseFilter
implements TwoParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float range;\nuniform float inv_max_dist;\nuniform float shade;\nuniform vec2 scale;\nvarying vec2 vTextureCoord;\nvoid main() {\n  const float slope = 20.0;\n  vec2 coord = vTextureCoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float lumen = shade / (1.0 + exp((dist * inv_max_dist - range) * slope)) + (1.0 - shade);\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  gl_FragColor = vec4(color.rgb * lumen, color.a);\n}\n";
    private float mScale = 0.85f;
    private float mShade = 0.5f;
    private int mWidth = 1;
    private int mHeight = 1;
    private int mRangeLocation = -1;
    private int mMaxDistLocation = -1;
    private int mShadeLocation = -1;
    private int mScaleLocation = -1;

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.mWidth = width;
        this.mHeight = height;
    }

    public void setVignetteScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        }
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        this.mScale = scale;
    }

    public void setVignetteShade(float shade) {
        if (shade < 0.0f) {
            shade = 0.0f;
        }
        if (shade > 1.0f) {
            shade = 1.0f;
        }
        this.mShade = shade;
    }

    public float getVignetteScale() {
        return this.mScale;
    }

    public float getVignetteShade() {
        return this.mShade;
    }

    @Override
    public void setParameter1(float value) {
        this.setVignetteScale(value);
    }

    @Override
    public float getParameter1() {
        return this.getVignetteScale();
    }

    @Override
    public void setParameter2(float value) {
        this.setVignetteShade(value);
    }

    @Override
    public float getParameter2() {
        return this.getVignetteShade();
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.mRangeLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"range");
        Egloo.checkGlProgramLocation((int)this.mRangeLocation, (String)"range");
        this.mMaxDistLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"inv_max_dist");
        Egloo.checkGlProgramLocation((int)this.mMaxDistLocation, (String)"inv_max_dist");
        this.mShadeLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"shade");
        Egloo.checkGlProgramLocation((int)this.mShadeLocation, (String)"shade");
        this.mScaleLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"scale");
        Egloo.checkGlProgramLocation((int)this.mScaleLocation, (String)"scale");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRangeLocation = -1;
        this.mMaxDistLocation = -1;
        this.mShadeLocation = -1;
        this.mScaleLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        float[] scale = new float[2];
        if (this.mWidth > this.mHeight) {
            scale[0] = 1.0f;
            scale[1] = (float)this.mHeight / (float)this.mWidth;
        } else {
            scale[0] = (float)this.mWidth / (float)this.mHeight;
            scale[1] = 1.0f;
        }
        GLES20.glUniform2fv((int)this.mScaleLocation, (int)1, (float[])scale, (int)0);
        Egloo.checkGlError((String)"glUniform2fv");
        float maxDist = (float)Math.sqrt(scale[0] * scale[0] + scale[1] * scale[1]) * 0.5f;
        GLES20.glUniform1f((int)this.mMaxDistLocation, (float)(1.0f / maxDist));
        Egloo.checkGlError((String)"glUniform1f");
        GLES20.glUniform1f((int)this.mShadeLocation, (float)this.mShade);
        Egloo.checkGlError((String)"glUniform1f");
        float range = 1.3f - (float)Math.sqrt(this.mScale) * 0.7f;
        GLES20.glUniform1f((int)this.mRangeLocation, (float)range);
        Egloo.checkGlError((String)"glUniform1f");
    }
}

