/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.content.Context;
import android.graphics.PointF;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.AudioCodec;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.PictureFormat;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.EngineThread;
import com.otaliastudios.cameraview.engine.offset.Angles;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.engine.orchestrator.CameraOrchestrator;
import com.otaliastudios.cameraview.engine.orchestrator.CameraState;
import com.otaliastudios.cameraview.engine.orchestrator.CameraStateOrchestrator;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.gesture.Gesture;
import com.otaliastudios.cameraview.internal.WorkerHandler;
import com.otaliastudios.cameraview.metering.MeteringRegions;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import com.otaliastudios.cameraview.preview.CameraPreview;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.size.SizeSelector;
import com.otaliastudios.cameraview.video.VideoRecorder;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class CameraEngine
implements CameraPreview.SurfaceCallback,
PictureRecorder.PictureResultListener,
VideoRecorder.VideoResultListener {
    protected static final String TAG = CameraEngine.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int DESTROY_RETRIES = 2;
    private WorkerHandler mHandler;
    @VisibleForTesting
    Handler mCrashHandler;
    private final Callback mCallback;
    private final CameraStateOrchestrator mOrchestrator = new CameraStateOrchestrator(new CameraOrchestrator.Callback(){

        @Override
        @NonNull
        public WorkerHandler getJobWorker(@NonNull String job) {
            return CameraEngine.this.mHandler;
        }

        @Override
        public void handleJobException(@NonNull String job, @NonNull Exception exception) {
            CameraEngine.this.handleException(exception, false);
        }
    });

    protected CameraEngine(@NonNull Callback callback) {
        this.mCallback = callback;
        this.mCrashHandler = new Handler(Looper.getMainLooper());
        this.recreateHandler(false);
    }

    @NonNull
    protected final Callback getCallback() {
        return this.mCallback;
    }

    @NonNull
    protected final CameraStateOrchestrator getOrchestrator() {
        return this.mOrchestrator;
    }

    private void handleException(final @NonNull Throwable throwable, boolean isUncaught) {
        if (isUncaught) {
            LOG.e("EXCEPTION:", "Handler thread is gone. Replacing.");
            this.recreateHandler(false);
        }
        LOG.e("EXCEPTION:", "Scheduling on the crash handler...");
        this.mCrashHandler.post(new Runnable(){

            @Override
            public void run() {
                CameraException exception;
                if (throwable instanceof CameraException) {
                    exception = (CameraException)throwable;
                    if (exception.isUnrecoverable()) {
                        LOG.e("EXCEPTION:", "Got CameraException. Since it is unrecoverable, executing destroy(false).");
                        CameraEngine.this.destroy(false);
                    }
                } else {
                    LOG.e("EXCEPTION:", "Unexpected error! Executing destroy(true).");
                    CameraEngine.this.destroy(true);
                    LOG.e("EXCEPTION:", "Unexpected error! Throwing.");
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                LOG.e("EXCEPTION:", "Got CameraException. Dispatching to callback.");
                CameraEngine.this.mCallback.dispatchError(exception);
            }
        });
    }

    private void recreateHandler(boolean resetOrchestrator) {
        if (this.mHandler != null) {
            this.mHandler.destroy();
        }
        this.mHandler = WorkerHandler.get("CameraViewEngine");
        this.mHandler.getThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new CrashExceptionHandler());
        if (resetOrchestrator) {
            this.mOrchestrator.reset();
        }
    }

    @NonNull
    public final CameraState getState() {
        return this.mOrchestrator.getCurrentState();
    }

    @NonNull
    public final CameraState getTargetState() {
        return this.mOrchestrator.getTargetState();
    }

    public final boolean isChangingState() {
        return this.mOrchestrator.hasPendingStateChange();
    }

    public void destroy(boolean unrecoverably) {
        this.destroy(unrecoverably, 0);
    }

    private void destroy(boolean unrecoverably, int depth) {
        LOG.i(new Object[]{"DESTROY:", "state:", this.getState(), "thread:", Thread.currentThread(), "depth:", depth, "unrecoverably:", unrecoverably});
        if (unrecoverably) {
            this.mHandler.getThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new NoOpExceptionHandler());
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.stop(true).addOnCompleteListener(this.mHandler.getExecutor(), (OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                latch.countDown();
            }
        });
        try {
            boolean success = latch.await(6L, TimeUnit.SECONDS);
            if (!success) {
                LOG.e("DESTROY: Could not destroy synchronously after 6 seconds.", "Current thread:", Thread.currentThread(), "Handler thread:", this.mHandler.getThread());
                if (++depth < 2) {
                    this.recreateHandler(true);
                    LOG.e("DESTROY: Trying again on thread:", this.mHandler.getThread());
                    this.destroy(unrecoverably, depth);
                } else {
                    LOG.w("DESTROY: Giving up because DESTROY_RETRIES was reached.");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void restart() {
        LOG.i(new Object[]{"RESTART:", "scheduled. State:", this.getState()});
        this.stop(false);
        this.start();
    }

    @NonNull
    public Task<Void> start() {
        LOG.i(new Object[]{"START:", "scheduled. State:", this.getState()});
        Task<Void> engine = this.startEngine();
        this.startBind();
        this.startPreview();
        return engine;
    }

    @NonNull
    public Task<Void> stop(boolean swallowExceptions) {
        LOG.i(new Object[]{"STOP:", "scheduled. State:", this.getState()});
        this.stopPreview(swallowExceptions);
        this.stopBind(swallowExceptions);
        return this.stopEngine(swallowExceptions);
    }

    @NonNull
    protected Task<Void> restartBind() {
        LOG.i(new Object[]{"RESTART BIND:", "scheduled. State:", this.getState()});
        this.stopPreview(false);
        this.stopBind(false);
        this.startBind();
        return this.startPreview();
    }

    @NonNull
    protected Task<Void> restartPreview() {
        LOG.i(new Object[]{"RESTART PREVIEW:", "scheduled. State:", this.getState()});
        this.stopPreview(false);
        return this.startPreview();
    }

    @NonNull
    @EngineThread
    private Task<Void> startEngine() {
        return this.mOrchestrator.scheduleStateChange(CameraState.OFF, CameraState.ENGINE, true, new Callable<Task<CameraOptions>>(){

            @Override
            public Task<CameraOptions> call() {
                if (!CameraEngine.this.collectCameraInfo(CameraEngine.this.getFacing())) {
                    LOG.e("onStartEngine:", "No camera available for facing", CameraEngine.this.getFacing());
                    throw new CameraException(6);
                }
                return CameraEngine.this.onStartEngine();
            }
        }).onSuccessTask((SuccessContinuation)new SuccessContinuation<CameraOptions, Void>(){

            @NonNull
            public Task<Void> then(@Nullable CameraOptions cameraOptions) {
                if (cameraOptions == null) {
                    throw new RuntimeException("Null options!");
                }
                CameraEngine.this.mCallback.dispatchOnCameraOpened(cameraOptions);
                return Tasks.forResult(null);
            }
        });
    }

    @NonNull
    @EngineThread
    private Task<Void> stopEngine(boolean swallowExceptions) {
        return this.mOrchestrator.scheduleStateChange(CameraState.ENGINE, CameraState.OFF, !swallowExceptions, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                return CameraEngine.this.onStopEngine();
            }
        }).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void onSuccess(Void aVoid) {
                CameraEngine.this.mCallback.dispatchOnCameraClosed();
            }
        });
    }

    @EngineThread
    protected abstract boolean collectCameraInfo(@NonNull Facing var1);

    @NonNull
    @EngineThread
    protected abstract Task<CameraOptions> onStartEngine();

    @NonNull
    @EngineThread
    protected abstract Task<Void> onStopEngine();

    @NonNull
    @EngineThread
    private Task<Void> startBind() {
        return this.mOrchestrator.scheduleStateChange(CameraState.ENGINE, CameraState.BIND, true, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                if (CameraEngine.this.getPreview() != null && CameraEngine.this.getPreview().hasSurface()) {
                    return CameraEngine.this.onStartBind();
                }
                return Tasks.forCanceled();
            }
        });
    }

    @NonNull
    @EngineThread
    private Task<Void> stopBind(boolean swallowExceptions) {
        return this.mOrchestrator.scheduleStateChange(CameraState.BIND, CameraState.ENGINE, !swallowExceptions, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                return CameraEngine.this.onStopBind();
            }
        });
    }

    @NonNull
    @EngineThread
    protected abstract Task<Void> onStartBind();

    @NonNull
    @EngineThread
    protected abstract Task<Void> onStopBind();

    @NonNull
    @EngineThread
    private Task<Void> startPreview() {
        return this.mOrchestrator.scheduleStateChange(CameraState.BIND, CameraState.PREVIEW, true, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                return CameraEngine.this.onStartPreview();
            }
        });
    }

    @NonNull
    @EngineThread
    private Task<Void> stopPreview(boolean swallowExceptions) {
        return this.mOrchestrator.scheduleStateChange(CameraState.PREVIEW, CameraState.BIND, !swallowExceptions, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                return CameraEngine.this.onStopPreview();
            }
        });
    }

    @NonNull
    @EngineThread
    protected abstract Task<Void> onStartPreview();

    @NonNull
    @EngineThread
    protected abstract Task<Void> onStopPreview();

    @Override
    public final void onSurfaceAvailable() {
        LOG.i("onSurfaceAvailable:", "Size is", this.getPreview().getSurfaceSize());
        this.startBind();
        this.startPreview();
    }

    @Override
    public final void onSurfaceDestroyed() {
        LOG.i("onSurfaceDestroyed");
        this.stopPreview(false);
        this.stopBind(false);
    }

    @NonNull
    public abstract Angles getAngles();

    @NonNull
    public abstract FrameManager getFrameManager();

    @Nullable
    public abstract CameraOptions getCameraOptions();

    @Nullable
    public abstract Size getPictureSize(@NonNull Reference var1);

    @Nullable
    public abstract Size getVideoSize(@NonNull Reference var1);

    @Nullable
    public abstract Size getPreviewStreamSize(@NonNull Reference var1);

    @Nullable
    public abstract Size getUncroppedSnapshotSize(@NonNull Reference var1);

    public abstract void setPreview(@NonNull CameraPreview var1);

    @Nullable
    public abstract CameraPreview getPreview();

    public abstract void setOverlay(@Nullable Overlay var1);

    @Nullable
    public abstract Overlay getOverlay();

    public abstract void setPreviewStreamSizeSelector(@Nullable SizeSelector var1);

    @Nullable
    public abstract SizeSelector getPreviewStreamSizeSelector();

    public abstract void setPictureSizeSelector(@NonNull SizeSelector var1);

    @NonNull
    public abstract SizeSelector getPictureSizeSelector();

    public abstract void setVideoSizeSelector(@NonNull SizeSelector var1);

    @NonNull
    public abstract SizeSelector getVideoSizeSelector();

    public abstract void setVideoMaxSize(long var1);

    public abstract long getVideoMaxSize();

    public abstract void setVideoMaxDuration(int var1);

    public abstract int getVideoMaxDuration();

    public abstract void setVideoCodec(@NonNull VideoCodec var1);

    @NonNull
    public abstract VideoCodec getVideoCodec();

    public abstract void setVideoBitRate(int var1);

    public abstract int getVideoBitRate();

    public abstract void setAudioBitRate(int var1);

    public abstract int getAudioBitRate();

    public abstract void setAudioCodec(@NonNull AudioCodec var1);

    @NonNull
    public abstract AudioCodec getAudioCodec();

    public abstract void setSnapshotMaxWidth(int var1);

    public abstract int getSnapshotMaxWidth();

    public abstract void setSnapshotMaxHeight(int var1);

    public abstract int getSnapshotMaxHeight();

    public abstract void setFrameProcessingMaxWidth(int var1);

    public abstract int getFrameProcessingMaxWidth();

    public abstract void setFrameProcessingMaxHeight(int var1);

    public abstract int getFrameProcessingMaxHeight();

    public abstract void setFrameProcessingFormat(int var1);

    public abstract int getFrameProcessingFormat();

    public abstract void setFrameProcessingPoolSize(int var1);

    public abstract int getFrameProcessingPoolSize();

    public abstract void setAutoFocusResetDelay(long var1);

    public abstract long getAutoFocusResetDelay();

    public abstract void setFacing(@NonNull Facing var1);

    @NonNull
    public abstract Facing getFacing();

    public abstract void setAudio(@NonNull Audio var1);

    @NonNull
    public abstract Audio getAudio();

    public abstract void setMode(@NonNull Mode var1);

    @NonNull
    public abstract Mode getMode();

    public abstract void setZoom(float var1, @Nullable PointF[] var2, boolean var3);

    public abstract float getZoomValue();

    public abstract void setExposureCorrection(float var1, @NonNull float[] var2, @Nullable PointF[] var3, boolean var4);

    public abstract float getExposureCorrectionValue();

    public abstract void setFlash(@NonNull Flash var1);

    @NonNull
    public abstract Flash getFlash();

    public abstract void setWhiteBalance(@NonNull WhiteBalance var1);

    @NonNull
    public abstract WhiteBalance getWhiteBalance();

    public abstract void setHdr(@NonNull Hdr var1);

    @NonNull
    public abstract Hdr getHdr();

    public abstract void setLocation(@Nullable Location var1);

    @Nullable
    public abstract Location getLocation();

    public abstract void setPictureFormat(@NonNull PictureFormat var1);

    @NonNull
    public abstract PictureFormat getPictureFormat();

    public abstract void setPreviewFrameRateExact(boolean var1);

    public abstract boolean getPreviewFrameRateExact();

    public abstract void setPreviewFrameRate(float var1);

    public abstract float getPreviewFrameRate();

    public abstract void setHasFrameProcessors(boolean var1);

    public abstract boolean hasFrameProcessors();

    public abstract void setPictureMetering(boolean var1);

    public abstract boolean getPictureMetering();

    public abstract void setPictureSnapshotMetering(boolean var1);

    public abstract boolean getPictureSnapshotMetering();

    public abstract void startAutoFocus(@Nullable Gesture var1, @NonNull MeteringRegions var2, @NonNull PointF var3);

    public abstract void setPlaySounds(boolean var1);

    public abstract boolean isTakingPicture();

    public abstract void takePicture(@NonNull PictureResult.Stub var1);

    public abstract void takePictureSnapshot(@NonNull PictureResult.Stub var1);

    public abstract boolean isTakingVideo();

    public abstract void takeVideo(@NonNull VideoResult.Stub var1, @Nullable File var2, @Nullable FileDescriptor var3);

    public abstract void takeVideoSnapshot(@NonNull VideoResult.Stub var1, @NonNull File var2);

    public abstract void stopVideo();

    private static class NoOpExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private NoOpExceptionHandler() {
        }

        @Override
        public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
            LOG.w("EXCEPTION:", "In the NoOpExceptionHandler, probably while destroying.", "Thread:", thread, "Error:", throwable);
        }
    }

    private class CrashExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CrashExceptionHandler() {
        }

        @Override
        public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
            CameraEngine.this.handleException(throwable, true);
        }
    }

    public static interface Callback {
        @NonNull
        public Context getContext();

        public void dispatchOnCameraOpened(@NonNull CameraOptions var1);

        public void dispatchOnCameraClosed();

        public void onCameraPreviewStreamSizeChanged();

        public void onShutter(boolean var1);

        public void dispatchOnVideoTaken(@NonNull VideoResult.Stub var1);

        public void dispatchOnPictureTaken(@NonNull PictureResult.Stub var1);

        public void dispatchOnFocusStart(@Nullable Gesture var1, @NonNull PointF var2);

        public void dispatchOnFocusEnd(@Nullable Gesture var1, boolean var2, @NonNull PointF var3);

        public void dispatchOnZoomChanged(float var1, @Nullable PointF[] var2);

        public void dispatchOnExposureCorrectionChanged(float var1, @NonNull float[] var2, @Nullable PointF[] var3);

        public void dispatchFrame(@NonNull Frame var1);

        public void dispatchError(CameraException var1);

        public void dispatchOnVideoRecordingStart();

        public void dispatchOnVideoRecordingEnd();
    }
}

