/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.mappers;

import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.controls.Control;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public class Camera2Mapper {
    private static Camera2Mapper sInstance;
    private static final Map<Facing, Integer> FACING;
    private static final Map<WhiteBalance, Integer> WB;
    private static final Map<Hdr, Integer> HDR;

    public static Camera2Mapper get() {
        if (sInstance == null) {
            sInstance = new Camera2Mapper();
        }
        return sInstance;
    }

    private Camera2Mapper() {
    }

    @NonNull
    public List<Pair<Integer, Integer>> mapFlash(@NonNull Flash flash) {
        ArrayList<Pair<Integer, Integer>> result = new ArrayList<Pair<Integer, Integer>>();
        switch (flash) {
            case ON: {
                result.add((Pair<Integer, Integer>)new Pair((Object)3, (Object)0));
                break;
            }
            case AUTO: {
                result.add((Pair<Integer, Integer>)new Pair((Object)2, (Object)0));
                result.add((Pair<Integer, Integer>)new Pair((Object)4, (Object)0));
                break;
            }
            case OFF: {
                result.add((Pair<Integer, Integer>)new Pair((Object)1, (Object)0));
                result.add((Pair<Integer, Integer>)new Pair((Object)0, (Object)0));
                break;
            }
            case TORCH: {
                result.add((Pair<Integer, Integer>)new Pair((Object)1, (Object)2));
                result.add((Pair<Integer, Integer>)new Pair((Object)0, (Object)2));
            }
        }
        return result;
    }

    public int mapFacing(@NonNull Facing facing) {
        return FACING.get(facing);
    }

    public int mapWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        return WB.get(whiteBalance);
    }

    public int mapHdr(@NonNull Hdr hdr) {
        return HDR.get(hdr);
    }

    @NonNull
    public Set<Flash> unmapFlash(int cameraConstant) {
        HashSet<Flash> result = new HashSet<Flash>();
        switch (cameraConstant) {
            case 0: 
            case 1: {
                result.add(Flash.OFF);
                result.add(Flash.TORCH);
                break;
            }
            case 3: {
                result.add(Flash.ON);
                break;
            }
            case 2: 
            case 4: {
                result.add(Flash.AUTO);
                break;
            }
        }
        return result;
    }

    @Nullable
    public Facing unmapFacing(int cameraConstant) {
        return this.reverseLookup(FACING, cameraConstant);
    }

    @Nullable
    public WhiteBalance unmapWhiteBalance(int cameraConstant) {
        return this.reverseLookup(WB, cameraConstant);
    }

    @Nullable
    public Hdr unmapHdr(int cameraConstant) {
        return this.reverseLookup(HDR, cameraConstant);
    }

    @Nullable
    private <C extends Control, T> C reverseLookup(@NonNull Map<C, T> map, @NonNull T object) {
        for (Control value : map.keySet()) {
            if (!object.equals(map.get(value))) continue;
            return (C)value;
        }
        return null;
    }

    static {
        FACING = new HashMap<Facing, Integer>();
        WB = new HashMap<WhiteBalance, Integer>();
        HDR = new HashMap<Hdr, Integer>();
        FACING.put(Facing.BACK, 1);
        FACING.put(Facing.FRONT, 0);
        WB.put(WhiteBalance.AUTO, 1);
        WB.put(WhiteBalance.CLOUDY, 6);
        WB.put(WhiteBalance.DAYLIGHT, 5);
        WB.put(WhiteBalance.FLUORESCENT, 3);
        WB.put(WhiteBalance.INCANDESCENT, 2);
        HDR.put(Hdr.OFF, 0);
        HDR.put(Hdr.ON, 18);
    }
}

