/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.BitmapFactory;
import android.location.Location;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.BitmapCallback;
import com.otaliastudios.cameraview.CameraUtils;
import com.otaliastudios.cameraview.FileCallback;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.PictureFormat;
import com.otaliastudios.cameraview.size.Size;
import java.io.File;

public class PictureResult {
    private final boolean isSnapshot;
    private final Location location;
    private final int rotation;
    private final Size size;
    private final Facing facing;
    private final byte[] data;
    private final PictureFormat format;

    PictureResult(@NonNull Stub builder) {
        this.isSnapshot = builder.isSnapshot;
        this.location = builder.location;
        this.rotation = builder.rotation;
        this.size = builder.size;
        this.facing = builder.facing;
        this.data = builder.data;
        this.format = builder.format;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NonNull
    public Size getSize() {
        return this.size;
    }

    @NonNull
    public Facing getFacing() {
        return this.facing;
    }

    @NonNull
    public byte[] getData() {
        return this.data;
    }

    @NonNull
    public PictureFormat getFormat() {
        return this.format;
    }

    public void toBitmap(int maxWidth, int maxHeight, @NonNull BitmapCallback callback) {
        if (this.format == PictureFormat.JPEG) {
            CameraUtils.decodeBitmap(this.getData(), maxWidth, maxHeight, new BitmapFactory.Options(), this.rotation, callback);
        } else if (this.format == PictureFormat.DNG && Build.VERSION.SDK_INT >= 24) {
            CameraUtils.decodeBitmap(this.getData(), maxWidth, maxHeight, new BitmapFactory.Options(), this.rotation, callback);
        } else {
            throw new UnsupportedOperationException("PictureResult.toBitmap() does not support this picture format: " + this.format);
        }
    }

    public void toBitmap(@NonNull BitmapCallback callback) {
        this.toBitmap(-1, -1, callback);
    }

    public void toFile(@NonNull File file, @NonNull FileCallback callback) {
        CameraUtils.writeToFile(this.getData(), file, callback);
    }

    public static class Stub {
        public boolean isSnapshot;
        public Location location;
        public int rotation;
        public Size size;
        public Facing facing;
        public byte[] data;
        public PictureFormat format;

        Stub() {
        }
    }
}

