/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

class AudioTimestamp {
    private int mByteRate;
    private long mBaseTimeUs;
    private long mBytesSinceBaseTime;
    private long mGapUs;

    static long bytesToUs(long bytes, int byteRate) {
        return 1000000L * bytes / (long)byteRate;
    }

    static long bytesToMillis(long bytes, int byteRate) {
        return 1000L * bytes / (long)byteRate;
    }

    AudioTimestamp(int byteRate) {
        this.mByteRate = byteRate;
    }

    long increaseUs(int readBytes) {
        long correctedTimeUs;
        long correctionUs;
        long bufferDurationUs = AudioTimestamp.bytesToUs(readBytes, this.mByteRate);
        long bufferEndTimeUs = System.nanoTime() / 1000L;
        long bufferStartTimeUs = bufferEndTimeUs - bufferDurationUs;
        if (this.mBytesSinceBaseTime == 0L) {
            this.mBaseTimeUs = bufferStartTimeUs;
        }
        if ((correctionUs = bufferStartTimeUs - (correctedTimeUs = this.mBaseTimeUs + AudioTimestamp.bytesToUs(this.mBytesSinceBaseTime, this.mByteRate))) >= 2L * bufferDurationUs) {
            this.mBaseTimeUs = bufferStartTimeUs;
            this.mBytesSinceBaseTime = readBytes;
            this.mGapUs = correctionUs;
            return this.mBaseTimeUs;
        }
        if (correctionUs < 0L) {
            // empty if block
        }
        this.mGapUs = 0L;
        this.mBytesSinceBaseTime += (long)readBytes;
        return correctedTimeUs;
    }

    int getGapCount(int frameBytes) {
        if (this.mGapUs == 0L) {
            return 0;
        }
        long durationUs = AudioTimestamp.bytesToUs(frameBytes, this.mByteRate);
        return (int)(this.mGapUs / durationUs);
    }

    long getGapStartUs(long lastTimeUs) {
        return lastTimeUs - this.mGapUs;
    }
}

