/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.opengl.core.Egloo;

public class SaturationFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float scale;\nuniform vec3 exponents;\nfloat shift;\nvec3 weights;\nvarying vec2 vTextureCoord;\nvoid main() {\n  weights[0] = 0.25;\n  weights[1] = 0.625;\n  weights[2] = 0.125;\n  shift = 0.003921569;\n  vec4 oldcolor = texture2D(sTexture, vTextureCoord);\n  float kv = dot(oldcolor.rgb, weights) + shift;\n  vec3 new_color = scale * oldcolor.rgb + (1.0 - scale) * kv;\n  gl_FragColor = vec4(new_color, oldcolor.a);\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  float de = dot(color.rgb, weights);\n  float inv_de = 1.0 / de;\n  vec3 verynew_color = de * pow(color.rgb * inv_de, exponents);\n  float max_color = max(max(max(verynew_color.r, verynew_color.g), verynew_color.b), 1.0);\n  gl_FragColor = gl_FragColor+vec4(verynew_color / max_color, color.a);\n}\n";
    private float scale = 1.0f;
    private int scaleLocation = -1;
    private int exponentsLocation = -1;

    public void setSaturation(float value) {
        if (value < -1.0f) {
            value = -1.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.scale = value;
    }

    public float getSaturation() {
        return this.scale;
    }

    @Override
    public void setParameter1(float value) {
        this.setSaturation(2.0f * value - 1.0f);
    }

    @Override
    public float getParameter1() {
        return (this.getSaturation() + 1.0f) / 2.0f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.scaleLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"scale");
        Egloo.checkGlProgramLocation((int)this.scaleLocation, (String)"scale");
        this.exponentsLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"exponents");
        Egloo.checkGlProgramLocation((int)this.exponentsLocation, (String)"exponents");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.scaleLocation = -1;
        this.exponentsLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        if (this.scale > 0.0f) {
            GLES20.glUniform1f((int)this.scaleLocation, (float)0.0f);
            Egloo.checkGlError((String)"glUniform1f");
            GLES20.glUniform3f((int)this.exponentsLocation, (float)(0.9f * this.scale + 1.0f), (float)(2.1f * this.scale + 1.0f), (float)(2.7f * this.scale + 1.0f));
            Egloo.checkGlError((String)"glUniform3f");
        } else {
            GLES20.glUniform1f((int)this.scaleLocation, (float)(1.0f + this.scale));
            Egloo.checkGlError((String)"glUniform1f");
            GLES20.glUniform3f((int)this.exponentsLocation, (float)0.0f, (float)0.0f, (float)0.0f);
            Egloo.checkGlError((String)"glUniform3f");
        }
    }
}

