/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.orchestrator;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.internal.WorkerHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;

public class CameraOrchestrator {
    protected static final String TAG = CameraOrchestrator.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    protected final Callback mCallback;
    protected final ArrayDeque<Token> mJobs = new ArrayDeque();
    protected final Object mLock = new Object();
    private final Map<String, Runnable> mDelayedJobs = new HashMap<String, Runnable>();

    public CameraOrchestrator(@NonNull Callback callback) {
        this.mCallback = callback;
        this.ensureToken();
    }

    @NonNull
    public Task<Void> schedule(@NonNull String name, boolean dispatchExceptions, final @NonNull Runnable job) {
        return this.schedule(name, dispatchExceptions, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() {
                job.run();
                return Tasks.forResult(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <T> Task<T> schedule(final @NonNull String name, final boolean dispatchExceptions, final @NonNull Callable<Task<T>> job) {
        LOG.i(name.toUpperCase(), "- Scheduling.");
        final TaskCompletionSource source = new TaskCompletionSource();
        final WorkerHandler handler = this.mCallback.getJobWorker(name);
        Object object = this.mLock;
        synchronized (object) {
            CameraOrchestrator.applyCompletionListener(this.mJobs.getLast().task, handler, new OnCompleteListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onComplete(@NonNull Task task) {
                    Object object = CameraOrchestrator.this.mLock;
                    synchronized (object) {
                        CameraOrchestrator.this.mJobs.removeFirst();
                        CameraOrchestrator.this.ensureToken();
                    }
                    try {
                        LOG.i(name.toUpperCase(), "- Executing.");
                        Task inner = (Task)job.call();
                        CameraOrchestrator.applyCompletionListener(inner, handler, new OnCompleteListener<T>(){

                            public void onComplete(@NonNull Task<T> task) {
                                Exception e = task.getException();
                                if (e != null) {
                                    LOG.w(name.toUpperCase(), "- Finished with ERROR.", e);
                                    if (dispatchExceptions) {
                                        CameraOrchestrator.this.mCallback.handleJobException(name, e);
                                    }
                                    source.trySetException(e);
                                } else if (task.isCanceled()) {
                                    LOG.i(name.toUpperCase(), "- Finished because ABORTED.");
                                    source.trySetException((Exception)new CancellationException());
                                } else {
                                    LOG.i(name.toUpperCase(), "- Finished.");
                                    source.trySetResult(task.getResult());
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        LOG.i(name.toUpperCase(), "- Finished.", e);
                        if (dispatchExceptions) {
                            CameraOrchestrator.this.mCallback.handleJobException(name, e);
                        }
                        source.trySetException(e);
                    }
                }
            });
            this.mJobs.addLast(new Token(name, source.getTask()));
        }
        return source.getTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleDelayed(final @NonNull String name, long minDelay, final @NonNull Runnable runnable) {
        Runnable wrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CameraOrchestrator.this.schedule(name, true, runnable);
                Object object = CameraOrchestrator.this.mLock;
                synchronized (object) {
                    if (CameraOrchestrator.this.mDelayedJobs.containsValue(this)) {
                        CameraOrchestrator.this.mDelayedJobs.remove(name);
                    }
                }
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            this.mDelayedJobs.put(name, wrapper);
            this.mCallback.getJobWorker(name).post(minDelay, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull String name) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDelayedJobs.get(name) != null) {
                this.mCallback.getJobWorker(name).remove(this.mDelayedJobs.get(name));
                this.mDelayedJobs.remove(name);
            }
            Token token = new Token(name, Tasks.forResult(null));
            while (this.mJobs.remove(token)) {
            }
            this.ensureToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<String> all = new ArrayList<String>();
            all.addAll(this.mDelayedJobs.keySet());
            for (Token token : this.mJobs) {
                all.add(token.name);
            }
            for (String job : all) {
                this.remove(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureToken() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mJobs.isEmpty()) {
                this.mJobs.add(new Token("BASE", Tasks.forResult(null)));
            }
        }
    }

    private static <T> void applyCompletionListener(final @NonNull Task<T> task, @NonNull WorkerHandler handler, final @NonNull OnCompleteListener<T> listener) {
        if (task.isComplete()) {
            handler.run(new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(task);
                }
            });
        } else {
            task.addOnCompleteListener(handler.getExecutor(), listener);
        }
    }

    protected static class Token {
        public final String name;
        public final Task<?> task;

        private Token(@NonNull String name, @NonNull Task<?> task) {
            this.name = name;
            this.task = task;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof Token && ((Token)obj).name.equals(this.name);
        }
    }

    public static interface Callback {
        @NonNull
        public WorkerHandler getJobWorker(@NonNull String var1);

        public void handleJobException(@NonNull String var1, @NonNull Exception var2);
    }
}

