/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.meter;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.meter.BaseMeter;
import java.util.List;

@RequiresApi(value=21)
public class WhiteBalanceMeter
extends BaseMeter {
    private static final String TAG = WhiteBalanceMeter.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    public WhiteBalanceMeter(@NonNull List<MeteringRectangle> areas, boolean skipIfPossible) {
        super(areas, skipIfPossible);
    }

    @Override
    protected boolean checkIsSupported(@NonNull ActionHolder holder) {
        boolean isNotLegacy = this.readCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, -1) != 2;
        Integer awbMode = (Integer)holder.getBuilder(this).get(CaptureRequest.CONTROL_AWB_MODE);
        boolean result = isNotLegacy && awbMode != null && awbMode == 1;
        LOG.i("checkIsSupported:", result);
        return result;
    }

    @Override
    protected boolean checkShouldSkip(@NonNull ActionHolder holder) {
        TotalCaptureResult lastResult = holder.getLastResult(this);
        if (lastResult != null) {
            Integer awbState = (Integer)lastResult.get(CaptureResult.CONTROL_AWB_STATE);
            boolean result = awbState != null && awbState == 2;
            LOG.i("checkShouldSkip:", result);
            return result;
        }
        LOG.i("checkShouldSkip: false - lastResult is null.");
        return false;
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder, @NonNull List<MeteringRectangle> areas) {
        LOG.i("onStarted:", "with areas:", areas);
        int maxRegions = this.readCharacteristic(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB, 0);
        if (!areas.isEmpty() && maxRegions > 0) {
            int max = Math.min(maxRegions, areas.size());
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AWB_REGIONS, (Object)areas.subList(0, max).toArray(new MeteringRectangle[0]));
            holder.applyBuilder(this);
        }
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer awbState = (Integer)result.get(CaptureResult.CONTROL_AWB_STATE);
        LOG.i("onCaptureCompleted:", "awbState:", awbState);
        if (awbState == null) {
            return;
        }
        switch (awbState) {
            case 2: {
                this.setSuccessful(true);
                this.setState(Integer.MAX_VALUE);
                break;
            }
            case 3: {
                this.setSuccessful(false);
                this.setState(Integer.MAX_VALUE);
                break;
            }
        }
    }
}

