/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.meter;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.meter.BaseMeter;
import java.util.List;

@RequiresApi(value=21)
public class FocusMeter
extends BaseMeter {
    private static final String TAG = FocusMeter.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    public FocusMeter(@NonNull List<MeteringRectangle> areas, boolean skipIfPossible) {
        super(areas, skipIfPossible);
    }

    @Override
    protected boolean checkIsSupported(@NonNull ActionHolder holder) {
        Integer afMode = (Integer)holder.getBuilder(this).get(CaptureRequest.CONTROL_AF_MODE);
        boolean result = afMode != null && (afMode == 1 || afMode == 4 || afMode == 3 || afMode == 2);
        LOG.i("checkIsSupported:", result);
        return result;
    }

    @Override
    protected boolean checkShouldSkip(@NonNull ActionHolder holder) {
        TotalCaptureResult lastResult = holder.getLastResult(this);
        if (lastResult != null) {
            Integer afState = (Integer)lastResult.get(CaptureResult.CONTROL_AF_STATE);
            boolean result = afState != null && (afState == 4 || afState == 2);
            LOG.i("checkShouldSkip:", result);
            return result;
        }
        LOG.i("checkShouldSkip: false - lastResult is null.");
        return false;
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder, @NonNull List<MeteringRectangle> areas) {
        LOG.i("onStarted:", "with areas:", areas);
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
        int maxRegions = this.readCharacteristic(CameraCharacteristics.CONTROL_MAX_REGIONS_AF, 0);
        if (!areas.isEmpty() && maxRegions > 0) {
            int max = Math.min(maxRegions, areas.size());
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_REGIONS, (Object)areas.subList(0, max).toArray(new MeteringRectangle[0]));
        }
        holder.applyBuilder(this);
    }

    @Override
    protected void onCompleted(@NonNull ActionHolder holder) {
        super.onCompleted(holder);
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_TRIGGER, null);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
        LOG.i("onCaptureCompleted:", "afState:", afState);
        if (afState == null) {
            return;
        }
        switch (afState) {
            case 4: {
                this.setSuccessful(true);
                this.setState(Integer.MAX_VALUE);
                break;
            }
            case 5: {
                this.setSuccessful(false);
                this.setState(Integer.MAX_VALUE);
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                break;
            }
        }
    }
}

