/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.lock;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.lock.BaseLock;

@RequiresApi(value=21)
public class WhiteBalanceLock
extends BaseLock {
    private static final String TAG = WhiteBalanceLock.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    @Override
    protected boolean checkIsSupported(@NonNull ActionHolder holder) {
        boolean isNotLegacy = this.readCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, -1) != 2;
        Integer awbMode = (Integer)holder.getBuilder(this).get(CaptureRequest.CONTROL_AWB_MODE);
        boolean result = isNotLegacy && awbMode != null && awbMode == 1;
        LOG.i("checkIsSupported:", result);
        return result;
    }

    @Override
    protected boolean checkShouldSkip(@NonNull ActionHolder holder) {
        TotalCaptureResult lastResult = holder.getLastResult(this);
        if (lastResult != null) {
            Integer awbState = (Integer)lastResult.get(CaptureResult.CONTROL_AWB_STATE);
            boolean result = awbState != null && awbState == 3;
            LOG.i("checkShouldSkip:", result);
            return result;
        }
        LOG.i("checkShouldSkip: false - lastResult is null.");
        return false;
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder) {
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AWB_LOCK, (Object)true);
        holder.applyBuilder(this);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer awbState = (Integer)result.get(CaptureResult.CONTROL_AWB_STATE);
        LOG.i("processCapture:", "awbState:", awbState);
        if (awbState == null) {
            return;
        }
        switch (awbState) {
            case 3: {
                this.setState(Integer.MAX_VALUE);
                break;
            }
        }
    }
}

