/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.location.Location;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.PictureFormat;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.EngineThread;
import com.otaliastudios.cameraview.engine.offset.Angles;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.engine.orchestrator.CameraState;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import com.otaliastudios.cameraview.preview.CameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.size.SizeSelector;
import com.otaliastudios.cameraview.size.SizeSelectors;
import com.otaliastudios.cameraview.video.VideoRecorder;
import java.io.File;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class CameraBaseEngine
extends CameraEngine {
    protected CameraPreview mPreview;
    protected CameraOptions mCameraOptions;
    protected PictureRecorder mPictureRecorder;
    protected VideoRecorder mVideoRecorder;
    protected Size mCaptureSize;
    protected Size mPreviewStreamSize;
    protected Size mFrameProcessingSize;
    protected int mFrameProcessingFormat;
    protected boolean mHasFrameProcessors;
    protected Flash mFlash;
    protected WhiteBalance mWhiteBalance;
    protected VideoCodec mVideoCodec;
    protected Hdr mHdr;
    protected PictureFormat mPictureFormat;
    protected Location mLocation;
    protected float mZoomValue;
    protected float mExposureCorrectionValue;
    protected boolean mPlaySounds;
    protected boolean mPictureMetering;
    protected boolean mPictureSnapshotMetering;
    protected float mPreviewFrameRate;
    private boolean mPreviewFrameRateExact;
    private FrameManager mFrameManager;
    private final Angles mAngles = new Angles();
    @Nullable
    private SizeSelector mPreviewStreamSizeSelector;
    private SizeSelector mPictureSizeSelector;
    private SizeSelector mVideoSizeSelector;
    private Facing mFacing;
    private Mode mMode;
    private Audio mAudio;
    private long mVideoMaxSize;
    private int mVideoMaxDuration;
    private int mVideoBitRate;
    private int mAudioBitRate;
    private long mAutoFocusResetDelayMillis;
    private int mSnapshotMaxWidth;
    private int mSnapshotMaxHeight;
    private int mFrameProcessingMaxWidth;
    private int mFrameProcessingMaxHeight;
    private int mFrameProcessingPoolSize;
    private Overlay mOverlay;
    @VisibleForTesting(otherwise=4)
    Task<Void> mZoomTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mExposureCorrectionTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mFlashTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mWhiteBalanceTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mHdrTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mLocationTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mPlaySoundsTask = Tasks.forResult(null);
    @VisibleForTesting(otherwise=4)
    Task<Void> mPreviewFrameRateTask = Tasks.forResult(null);

    protected CameraBaseEngine(@NonNull CameraEngine.Callback callback) {
        super(callback);
    }

    @NonNull
    protected abstract FrameManager instantiateFrameManager(int var1);

    @Override
    @NonNull
    public final Angles getAngles() {
        return this.mAngles;
    }

    @Override
    @NonNull
    public FrameManager getFrameManager() {
        if (this.mFrameManager == null) {
            this.mFrameManager = this.instantiateFrameManager(this.mFrameProcessingPoolSize);
        }
        return this.mFrameManager;
    }

    @Override
    @Nullable
    public final CameraOptions getCameraOptions() {
        return this.mCameraOptions;
    }

    @Override
    public final void setPreview(@NonNull CameraPreview cameraPreview) {
        if (this.mPreview != null) {
            this.mPreview.setSurfaceCallback(null);
        }
        this.mPreview = cameraPreview;
        this.mPreview.setSurfaceCallback(this);
    }

    @Override
    @NonNull
    public final CameraPreview getPreview() {
        return this.mPreview;
    }

    @Override
    public final void setOverlay(@Nullable Overlay overlay) {
        this.mOverlay = overlay;
    }

    @Override
    @Nullable
    public final Overlay getOverlay() {
        return this.mOverlay;
    }

    @Override
    public final void setPreviewStreamSizeSelector(@Nullable SizeSelector selector) {
        this.mPreviewStreamSizeSelector = selector;
    }

    @Override
    @Nullable
    public final SizeSelector getPreviewStreamSizeSelector() {
        return this.mPreviewStreamSizeSelector;
    }

    @Override
    public final void setPictureSizeSelector(@NonNull SizeSelector selector) {
        this.mPictureSizeSelector = selector;
    }

    @Override
    @NonNull
    public final SizeSelector getPictureSizeSelector() {
        return this.mPictureSizeSelector;
    }

    @Override
    public final void setVideoSizeSelector(@NonNull SizeSelector selector) {
        this.mVideoSizeSelector = selector;
    }

    @Override
    @NonNull
    public final SizeSelector getVideoSizeSelector() {
        return this.mVideoSizeSelector;
    }

    @Override
    public final void setVideoMaxSize(long videoMaxSizeBytes) {
        this.mVideoMaxSize = videoMaxSizeBytes;
    }

    @Override
    public final long getVideoMaxSize() {
        return this.mVideoMaxSize;
    }

    @Override
    public final void setVideoMaxDuration(int videoMaxDurationMillis) {
        this.mVideoMaxDuration = videoMaxDurationMillis;
    }

    @Override
    public final int getVideoMaxDuration() {
        return this.mVideoMaxDuration;
    }

    @Override
    public final void setVideoCodec(@NonNull VideoCodec codec) {
        this.mVideoCodec = codec;
    }

    @Override
    @NonNull
    public final VideoCodec getVideoCodec() {
        return this.mVideoCodec;
    }

    @Override
    public final void setVideoBitRate(int videoBitRate) {
        this.mVideoBitRate = videoBitRate;
    }

    @Override
    public final int getVideoBitRate() {
        return this.mVideoBitRate;
    }

    @Override
    public final void setAudioBitRate(int audioBitRate) {
        this.mAudioBitRate = audioBitRate;
    }

    @Override
    public final int getAudioBitRate() {
        return this.mAudioBitRate;
    }

    @Override
    public final void setSnapshotMaxWidth(int maxWidth) {
        this.mSnapshotMaxWidth = maxWidth;
    }

    @Override
    public final int getSnapshotMaxWidth() {
        return this.mSnapshotMaxWidth;
    }

    @Override
    public final void setSnapshotMaxHeight(int maxHeight) {
        this.mSnapshotMaxHeight = maxHeight;
    }

    @Override
    public final int getSnapshotMaxHeight() {
        return this.mSnapshotMaxHeight;
    }

    @Override
    public final void setFrameProcessingMaxWidth(int maxWidth) {
        this.mFrameProcessingMaxWidth = maxWidth;
    }

    @Override
    public final int getFrameProcessingMaxWidth() {
        return this.mFrameProcessingMaxWidth;
    }

    @Override
    public final void setFrameProcessingMaxHeight(int maxHeight) {
        this.mFrameProcessingMaxHeight = maxHeight;
    }

    @Override
    public final int getFrameProcessingMaxHeight() {
        return this.mFrameProcessingMaxHeight;
    }

    @Override
    public final int getFrameProcessingFormat() {
        return this.mFrameProcessingFormat;
    }

    @Override
    public final void setFrameProcessingPoolSize(int poolSize) {
        this.mFrameProcessingPoolSize = poolSize;
    }

    @Override
    public final int getFrameProcessingPoolSize() {
        return this.mFrameProcessingPoolSize;
    }

    @Override
    public final void setAutoFocusResetDelay(long delayMillis) {
        this.mAutoFocusResetDelayMillis = delayMillis;
    }

    @Override
    public final long getAutoFocusResetDelay() {
        return this.mAutoFocusResetDelayMillis;
    }

    protected final boolean shouldResetAutoFocus() {
        return this.mAutoFocusResetDelayMillis > 0L && this.mAutoFocusResetDelayMillis != Long.MAX_VALUE;
    }

    @Override
    public final void setFacing(final @NonNull Facing facing) {
        final Facing old = this.mFacing;
        if (facing != old) {
            this.mFacing = facing;
            this.getOrchestrator().scheduleStateful("facing", CameraState.ENGINE, new Runnable(){

                @Override
                public void run() {
                    if (CameraBaseEngine.this.collectCameraInfo(facing)) {
                        CameraBaseEngine.this.restart();
                    } else {
                        CameraBaseEngine.this.mFacing = old;
                    }
                }
            });
        }
    }

    @Override
    @NonNull
    public final Facing getFacing() {
        return this.mFacing;
    }

    @Override
    public final void setAudio(@NonNull Audio audio) {
        if (this.mAudio != audio) {
            if (this.isTakingVideo()) {
                LOG.w("Audio setting was changed while recording. Changes will take place starting from next video");
            }
            this.mAudio = audio;
        }
    }

    @Override
    @NonNull
    public final Audio getAudio() {
        return this.mAudio;
    }

    @Override
    public final void setMode(@NonNull Mode mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.getOrchestrator().scheduleStateful("mode", CameraState.ENGINE, new Runnable(){

                @Override
                public void run() {
                    CameraBaseEngine.this.restart();
                }
            });
        }
    }

    @Override
    @NonNull
    public final Mode getMode() {
        return this.mMode;
    }

    @Override
    public final float getZoomValue() {
        return this.mZoomValue;
    }

    @Override
    public final float getExposureCorrectionValue() {
        return this.mExposureCorrectionValue;
    }

    @Override
    @NonNull
    public final Flash getFlash() {
        return this.mFlash;
    }

    @Override
    @NonNull
    public final WhiteBalance getWhiteBalance() {
        return this.mWhiteBalance;
    }

    @Override
    @NonNull
    public final Hdr getHdr() {
        return this.mHdr;
    }

    @Override
    @Nullable
    public final Location getLocation() {
        return this.mLocation;
    }

    @Override
    @NonNull
    public final PictureFormat getPictureFormat() {
        return this.mPictureFormat;
    }

    @Override
    public final void setPreviewFrameRateExact(boolean previewFrameRateExact) {
        this.mPreviewFrameRateExact = previewFrameRateExact;
    }

    @Override
    public final boolean getPreviewFrameRateExact() {
        return this.mPreviewFrameRateExact;
    }

    @Override
    public final float getPreviewFrameRate() {
        return this.mPreviewFrameRate;
    }

    @Override
    public final boolean hasFrameProcessors() {
        return this.mHasFrameProcessors;
    }

    @Override
    public final void setPictureMetering(boolean enable) {
        this.mPictureMetering = enable;
    }

    @Override
    public final boolean getPictureMetering() {
        return this.mPictureMetering;
    }

    @Override
    public final void setPictureSnapshotMetering(boolean enable) {
        this.mPictureSnapshotMetering = enable;
    }

    @Override
    public final boolean getPictureSnapshotMetering() {
        return this.mPictureSnapshotMetering;
    }

    @Override
    public final boolean isTakingPicture() {
        return this.mPictureRecorder != null;
    }

    @Override
    public void takePicture(final @NonNull PictureResult.Stub stub) {
        final boolean metering = this.mPictureMetering;
        this.getOrchestrator().scheduleStateful("take picture", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                CameraEngine.LOG.i("takePicture:", "running. isTakingPicture:", CameraBaseEngine.this.isTakingPicture());
                if (CameraBaseEngine.this.isTakingPicture()) {
                    return;
                }
                if (CameraBaseEngine.this.mMode == Mode.VIDEO) {
                    throw new IllegalStateException("Can't take hq pictures while in VIDEO mode");
                }
                stub.isSnapshot = false;
                stub.location = CameraBaseEngine.this.mLocation;
                stub.facing = CameraBaseEngine.this.mFacing;
                stub.format = CameraBaseEngine.this.mPictureFormat;
                CameraBaseEngine.this.onTakePicture(stub, metering);
            }
        });
    }

    @Override
    public void takePictureSnapshot(final @NonNull PictureResult.Stub stub) {
        final boolean metering = this.mPictureSnapshotMetering;
        this.getOrchestrator().scheduleStateful("take picture snapshot", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                CameraEngine.LOG.i("takePictureSnapshot:", "running. isTakingPicture:", CameraBaseEngine.this.isTakingPicture());
                if (CameraBaseEngine.this.isTakingPicture()) {
                    return;
                }
                stub.location = CameraBaseEngine.this.mLocation;
                stub.isSnapshot = true;
                stub.facing = CameraBaseEngine.this.mFacing;
                stub.format = PictureFormat.JPEG;
                AspectRatio ratio = AspectRatio.of(CameraBaseEngine.this.getPreviewSurfaceSize(Reference.OUTPUT));
                CameraBaseEngine.this.onTakePictureSnapshot(stub, ratio, metering);
            }
        });
    }

    @Override
    public void onPictureShutter(boolean didPlaySound) {
        this.getCallback().onShutter(!didPlaySound);
    }

    @Override
    public void onPictureResult(@Nullable PictureResult.Stub result, @Nullable Exception error) {
        this.mPictureRecorder = null;
        if (result != null) {
            this.getCallback().dispatchOnPictureTaken(result);
        } else {
            LOG.e("onPictureResult", "result is null: something went wrong.", error);
            this.getCallback().dispatchError(new CameraException(error, 4));
        }
    }

    @Override
    public final boolean isTakingVideo() {
        return this.mVideoRecorder != null && this.mVideoRecorder.isRecording();
    }

    @Override
    public final void takeVideo(final @NonNull VideoResult.Stub stub, final @Nullable File file, final @Nullable FileDescriptor fileDescriptor) {
        this.getOrchestrator().scheduleStateful("take video", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                CameraEngine.LOG.i("takeVideo:", "running. isTakingVideo:", CameraBaseEngine.this.isTakingVideo());
                if (CameraBaseEngine.this.isTakingVideo()) {
                    return;
                }
                if (CameraBaseEngine.this.mMode == Mode.PICTURE) {
                    throw new IllegalStateException("Can't record video while in PICTURE mode");
                }
                if (file != null) {
                    stub.file = file;
                } else if (fileDescriptor != null) {
                    stub.fileDescriptor = fileDescriptor;
                } else {
                    throw new IllegalStateException("file and fileDescriptor are both null.");
                }
                stub.isSnapshot = false;
                stub.videoCodec = CameraBaseEngine.this.mVideoCodec;
                stub.location = CameraBaseEngine.this.mLocation;
                stub.facing = CameraBaseEngine.this.mFacing;
                stub.audio = CameraBaseEngine.this.mAudio;
                stub.maxSize = CameraBaseEngine.this.mVideoMaxSize;
                stub.maxDuration = CameraBaseEngine.this.mVideoMaxDuration;
                stub.videoBitRate = CameraBaseEngine.this.mVideoBitRate;
                stub.audioBitRate = CameraBaseEngine.this.mAudioBitRate;
                CameraBaseEngine.this.onTakeVideo(stub);
            }
        });
    }

    @Override
    public final void takeVideoSnapshot(final @NonNull VideoResult.Stub stub, final @NonNull File file) {
        this.getOrchestrator().scheduleStateful("take video snapshot", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                CameraEngine.LOG.i("takeVideoSnapshot:", "running. isTakingVideo:", CameraBaseEngine.this.isTakingVideo());
                stub.file = file;
                stub.isSnapshot = true;
                stub.videoCodec = CameraBaseEngine.this.mVideoCodec;
                stub.location = CameraBaseEngine.this.mLocation;
                stub.facing = CameraBaseEngine.this.mFacing;
                stub.videoBitRate = CameraBaseEngine.this.mVideoBitRate;
                stub.audioBitRate = CameraBaseEngine.this.mAudioBitRate;
                stub.audio = CameraBaseEngine.this.mAudio;
                stub.maxSize = CameraBaseEngine.this.mVideoMaxSize;
                stub.maxDuration = CameraBaseEngine.this.mVideoMaxDuration;
                AspectRatio ratio = AspectRatio.of(CameraBaseEngine.this.getPreviewSurfaceSize(Reference.OUTPUT));
                CameraBaseEngine.this.onTakeVideoSnapshot(stub, ratio);
            }
        });
    }

    @Override
    public final void stopVideo() {
        this.getOrchestrator().schedule("stop video", true, new Runnable(){

            @Override
            public void run() {
                CameraEngine.LOG.i("stopVideo", "running. isTakingVideo?", CameraBaseEngine.this.isTakingVideo());
                CameraBaseEngine.this.onStopVideo();
            }
        });
    }

    @EngineThread
    protected void onStopVideo() {
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop(false);
        }
    }

    @Override
    @CallSuper
    public void onVideoResult(@Nullable VideoResult.Stub result, @Nullable Exception exception) {
        this.mVideoRecorder = null;
        if (result != null) {
            this.getCallback().dispatchOnVideoTaken(result);
        } else {
            LOG.e("onVideoResult", "result is null: something went wrong.", exception);
            this.getCallback().dispatchError(new CameraException(exception, 5));
        }
    }

    @Override
    public void onVideoRecordingStart() {
        this.getCallback().dispatchOnVideoRecordingStart();
    }

    @Override
    public void onVideoRecordingEnd() {
        this.getCallback().dispatchOnVideoRecordingEnd();
    }

    @EngineThread
    protected abstract void onTakePicture(@NonNull PictureResult.Stub var1, boolean var2);

    @EngineThread
    protected abstract void onTakePictureSnapshot(@NonNull PictureResult.Stub var1, @NonNull AspectRatio var2, boolean var3);

    @EngineThread
    protected abstract void onTakeVideoSnapshot(@NonNull VideoResult.Stub var1, @NonNull AspectRatio var2);

    @EngineThread
    protected abstract void onTakeVideo(@NonNull VideoResult.Stub var1);

    @Override
    public final void onSurfaceChanged() {
        LOG.i("onSurfaceChanged:", "Size is", this.getPreviewSurfaceSize(Reference.VIEW));
        this.getOrchestrator().scheduleStateful("surface changed", CameraState.BIND, new Runnable(){

            @Override
            public void run() {
                Size newSize = CameraBaseEngine.this.computePreviewStreamSize();
                if (newSize.equals(CameraBaseEngine.this.mPreviewStreamSize)) {
                    CameraEngine.LOG.i("onSurfaceChanged:", "The computed preview size is identical. No op.");
                } else {
                    CameraEngine.LOG.i("onSurfaceChanged:", "Computed a new preview size. Calling onPreviewStreamSizeChanged().");
                    CameraBaseEngine.this.mPreviewStreamSize = newSize;
                    CameraBaseEngine.this.onPreviewStreamSizeChanged();
                }
            }
        });
    }

    @EngineThread
    protected abstract void onPreviewStreamSizeChanged();

    @Override
    @Nullable
    public final Size getPictureSize(@NonNull Reference reference) {
        Size size = this.mCaptureSize;
        if (size == null || this.mMode == Mode.VIDEO) {
            return null;
        }
        return this.getAngles().flip(Reference.SENSOR, reference) ? size.flip() : size;
    }

    @Override
    @Nullable
    public final Size getVideoSize(@NonNull Reference reference) {
        Size size = this.mCaptureSize;
        if (size == null || this.mMode == Mode.PICTURE) {
            return null;
        }
        return this.getAngles().flip(Reference.SENSOR, reference) ? size.flip() : size;
    }

    @Override
    @Nullable
    public final Size getPreviewStreamSize(@NonNull Reference reference) {
        Size size = this.mPreviewStreamSize;
        if (size == null) {
            return null;
        }
        return this.getAngles().flip(Reference.SENSOR, reference) ? size.flip() : size;
    }

    @Nullable
    private Size getPreviewSurfaceSize(@NonNull Reference reference) {
        CameraPreview preview = this.mPreview;
        if (preview == null) {
            return null;
        }
        return this.getAngles().flip(Reference.VIEW, reference) ? preview.getSurfaceSize().flip() : preview.getSurfaceSize();
    }

    @Override
    @Nullable
    public final Size getUncroppedSnapshotSize(@NonNull Reference reference) {
        int maxHeight;
        Size baseSize = this.getPreviewStreamSize(reference);
        if (baseSize == null) {
            return null;
        }
        boolean flip = this.getAngles().flip(reference, Reference.VIEW);
        int maxWidth = flip ? this.mSnapshotMaxHeight : this.mSnapshotMaxWidth;
        int n = maxHeight = flip ? this.mSnapshotMaxWidth : this.mSnapshotMaxHeight;
        if (maxWidth <= 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        if (maxHeight <= 0) {
            maxHeight = Integer.MAX_VALUE;
        }
        float baseRatio = AspectRatio.of(baseSize).toFloat();
        float maxValuesRatio = AspectRatio.of(maxWidth, maxHeight).toFloat();
        if (maxValuesRatio >= baseRatio) {
            int outHeight = Math.min(baseSize.getHeight(), maxHeight);
            int outWidth = (int)Math.floor((float)outHeight * baseRatio);
            return new Size(outWidth, outHeight);
        }
        int outWidth = Math.min(baseSize.getWidth(), maxWidth);
        int outHeight = (int)Math.floor((float)outWidth / baseRatio);
        return new Size(outWidth, outHeight);
    }

    @NonNull
    protected final Size computeCaptureSize() {
        return this.computeCaptureSize(this.mMode);
    }

    @NonNull
    protected final Size computeCaptureSize(@NonNull Mode mode) {
        Collection<Size> sizes;
        SizeSelector selector;
        boolean flip = this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
        if (mode == Mode.PICTURE) {
            selector = this.mPictureSizeSelector;
            sizes = this.mCameraOptions.getSupportedPictureSizes();
        } else {
            selector = this.mVideoSizeSelector;
            sizes = this.mCameraOptions.getSupportedVideoSizes();
        }
        selector = SizeSelectors.or(selector, SizeSelectors.biggest());
        ArrayList<Size> list = new ArrayList<Size>(sizes);
        Size result = selector.select(list).get(0);
        if (!list.contains(result)) {
            throw new RuntimeException("SizeSelectors must not return Sizes other than those in the input list.");
        }
        LOG.i("computeCaptureSize:", "result:", result, "flip:", flip, "mode:", mode);
        if (flip) {
            result = result.flip();
        }
        return result;
    }

    @EngineThread
    @NonNull
    protected abstract List<Size> getPreviewStreamAvailableSizes();

    @EngineThread
    @NonNull
    protected final Size computePreviewStreamSize() {
        List<Size> previewSizes = this.getPreviewStreamAvailableSizes();
        boolean flip = this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
        ArrayList<Size> sizes = new ArrayList<Size>(previewSizes.size());
        for (Size size : previewSizes) {
            sizes.add(flip ? size.flip() : size);
        }
        Size targetMinSize = this.getPreviewSurfaceSize(Reference.VIEW);
        if (targetMinSize == null) {
            throw new IllegalStateException("targetMinSize should not be null here.");
        }
        AspectRatio targetRatio = AspectRatio.of(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        if (flip) {
            targetRatio = targetRatio.flip();
        }
        LOG.i("computePreviewStreamSize:", "targetRatio:", targetRatio, "targetMinSize:", targetMinSize);
        SizeSelector matchRatio = SizeSelectors.and(SizeSelectors.aspectRatio(targetRatio, 0.0f), SizeSelectors.biggest());
        SizeSelector matchSize = SizeSelectors.and(SizeSelectors.minHeight(targetMinSize.getHeight()), SizeSelectors.minWidth(targetMinSize.getWidth()), SizeSelectors.smallest());
        SizeSelector matchAll = SizeSelectors.or(SizeSelectors.and(matchRatio, matchSize), matchSize, matchRatio, SizeSelectors.biggest());
        SizeSelector selector = this.mPreviewStreamSizeSelector != null ? SizeSelectors.or(this.mPreviewStreamSizeSelector, matchAll) : matchAll;
        Size result = selector.select(sizes).get(0);
        if (!sizes.contains(result)) {
            throw new RuntimeException("SizeSelectors must not return Sizes other than those in the input list.");
        }
        if (flip) {
            result = result.flip();
        }
        LOG.i("computePreviewStreamSize:", "result:", result, "flip:", flip);
        return result;
    }

    @EngineThread
    @NonNull
    protected abstract List<Size> getFrameProcessingAvailableSizes();

    @EngineThread
    @NonNull
    protected final Size computeFrameProcessingSize() {
        List<Size> frameSizes = this.getFrameProcessingAvailableSizes();
        boolean flip = this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
        ArrayList<Size> sizes = new ArrayList<Size>(frameSizes.size());
        for (Size size : frameSizes) {
            sizes.add(flip ? size.flip() : size);
        }
        AspectRatio targetRatio = AspectRatio.of(this.mPreviewStreamSize.getWidth(), this.mPreviewStreamSize.getHeight());
        if (flip) {
            targetRatio = targetRatio.flip();
        }
        int maxWidth = this.mFrameProcessingMaxWidth;
        int maxHeight = this.mFrameProcessingMaxHeight;
        if (maxWidth <= 0 || maxWidth == Integer.MAX_VALUE) {
            maxWidth = 640;
        }
        if (maxHeight <= 0 || maxHeight == Integer.MAX_VALUE) {
            maxHeight = 640;
        }
        Size targetMaxSize = new Size(maxWidth, maxHeight);
        LOG.i("computeFrameProcessingSize:", "targetRatio:", targetRatio, "targetMaxSize:", targetMaxSize);
        SizeSelector matchRatio = SizeSelectors.aspectRatio(targetRatio, 0.0f);
        SizeSelector matchSize = SizeSelectors.and(SizeSelectors.maxHeight(targetMaxSize.getHeight()), SizeSelectors.maxWidth(targetMaxSize.getWidth()), SizeSelectors.biggest());
        SizeSelector matchAll = SizeSelectors.or(SizeSelectors.and(matchRatio, matchSize), matchSize, SizeSelectors.smallest());
        Size result = matchAll.select(sizes).get(0);
        if (!sizes.contains(result)) {
            throw new RuntimeException("SizeSelectors must not return Sizes other than those in the input list.");
        }
        if (flip) {
            result = result.flip();
        }
        LOG.i("computeFrameProcessingSize:", "result:", result, "flip:", flip);
        return result;
    }
}

