/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.controls;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraUtils;
import com.otaliastudios.cameraview.controls.Control;

public enum Facing implements Control
{
    BACK(0),
    FRONT(1);

    private int value;

    @NonNull
    static Facing DEFAULT(@Nullable Context context) {
        if (context == null) {
            return BACK;
        }
        if (CameraUtils.hasCameraFacing(context, BACK)) {
            return BACK;
        }
        if (CameraUtils.hasCameraFacing(context, FRONT)) {
            return FRONT;
        }
        return BACK;
    }

    private Facing(int value) {
        this.value = value;
    }

    int value() {
        return this.value;
    }

    @Nullable
    static Facing fromValue(int value) {
        Facing[] list;
        for (Facing action : list = Facing.values()) {
            if (action.value() != value) continue;
            return action;
        }
        return null;
    }
}

