/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.internal.DeviceEncoders;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.VideoRecorder;

public abstract class FullVideoRecorder
extends VideoRecorder {
    private static final String TAG = FullVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    protected MediaRecorder mMediaRecorder;
    private CamcorderProfile mProfile;
    private boolean mMediaRecorderPrepared;

    FullVideoRecorder(@Nullable VideoRecorder.VideoResultListener listener) {
        super(listener);
    }

    @NonNull
    protected abstract CamcorderProfile getCamcorderProfile(@NonNull VideoResult.Stub var1);

    protected abstract void applyVideoSource(@NonNull VideoResult.Stub var1, @NonNull MediaRecorder var2);

    protected final boolean prepareMediaRecorder(@NonNull VideoResult.Stub stub) {
        if (this.mMediaRecorderPrepared) {
            return true;
        }
        return this.prepareMediaRecorder(stub, true);
    }

    private boolean prepareMediaRecorder(@NonNull VideoResult.Stub stub, boolean applyEncodersConstraints) {
        boolean hasAudio;
        this.mMediaRecorder = new MediaRecorder();
        this.mProfile = this.getCamcorderProfile(stub);
        this.applyVideoSource(stub, this.mMediaRecorder);
        boolean bl = hasAudio = stub.audio == Audio.ON || stub.audio == Audio.MONO || stub.audio == Audio.STEREO;
        if (hasAudio) {
            this.mMediaRecorder.setAudioSource(0);
        }
        if (stub.videoCodec == VideoCodec.H_264) {
            this.mProfile.videoCodec = 2;
            this.mProfile.fileFormat = 2;
        } else if (stub.videoCodec == VideoCodec.H_263) {
            this.mProfile.videoCodec = 1;
            this.mProfile.fileFormat = 2;
        }
        this.mMediaRecorder.setOutputFormat(this.mProfile.fileFormat);
        if (stub.videoFrameRate <= 0) {
            stub.videoFrameRate = this.mProfile.videoFrameRate;
        }
        if (stub.videoBitRate <= 0) {
            stub.videoBitRate = this.mProfile.videoBitRate;
        }
        if (stub.audioBitRate <= 0 && hasAudio) {
            stub.audioBitRate = this.mProfile.audioBitRate;
        }
        if (applyEncodersConstraints) {
            boolean flip;
            String videoType;
            String audioType;
            switch (this.mProfile.audioCodec) {
                case 1: {
                    audioType = "audio/3gpp";
                    break;
                }
                case 2: {
                    audioType = "audio/amr-wb";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    audioType = "audio/mp4a-latm";
                    break;
                }
                case 6: {
                    audioType = "audio/vorbis";
                    break;
                }
                default: {
                    audioType = "audio/3gpp";
                }
            }
            switch (this.mProfile.videoCodec) {
                case 1: {
                    videoType = "video/3gpp";
                    break;
                }
                case 2: {
                    videoType = "video/avc";
                    break;
                }
                case 3: {
                    videoType = "video/mp4v-es";
                    break;
                }
                case 4: {
                    videoType = "video/x-vnd.on2.vp8";
                    break;
                }
                case 5: {
                    videoType = "video/hevc";
                    break;
                }
                default: {
                    videoType = "video/avc";
                }
            }
            boolean bl2 = flip = stub.rotation % 180 != 0;
            if (flip) {
                stub.size = stub.size.flip();
            }
            Size newVideoSize = null;
            int newVideoBitRate = 0;
            int newAudioBitRate = 0;
            int newVideoFrameRate = 0;
            int videoEncoderOffset = 0;
            int audioEncoderOffset = 0;
            boolean encodersFound = false;
            while (!encodersFound) {
                LOG.i("prepareMediaRecorder:", "Checking DeviceEncoders...", "videoOffset:", videoEncoderOffset, "audioOffset:", audioEncoderOffset);
                DeviceEncoders encoders = new DeviceEncoders(0, videoType, audioType, videoEncoderOffset, audioEncoderOffset);
                try {
                    newVideoSize = encoders.getSupportedVideoSize(stub.size);
                    newVideoBitRate = encoders.getSupportedVideoBitRate(stub.videoBitRate);
                    newAudioBitRate = encoders.getSupportedAudioBitRate(stub.audioBitRate);
                    newVideoFrameRate = encoders.getSupportedVideoFrameRate(newVideoSize, stub.videoFrameRate);
                    encodersFound = true;
                }
                catch (DeviceEncoders.VideoException videoException) {
                    ++videoEncoderOffset;
                }
                catch (DeviceEncoders.AudioException audioException) {
                    ++audioEncoderOffset;
                }
            }
            stub.size = newVideoSize;
            stub.videoBitRate = newVideoBitRate;
            stub.audioBitRate = newAudioBitRate;
            stub.videoFrameRate = newVideoFrameRate;
            if (flip) {
                stub.size = stub.size.flip();
            }
        }
        boolean flip = stub.rotation % 180 != 0;
        this.mMediaRecorder.setVideoSize(flip ? stub.size.getHeight() : stub.size.getWidth(), flip ? stub.size.getWidth() : stub.size.getHeight());
        this.mMediaRecorder.setVideoFrameRate(stub.videoFrameRate);
        this.mMediaRecorder.setVideoEncoder(this.mProfile.videoCodec);
        this.mMediaRecorder.setVideoEncodingBitRate(stub.videoBitRate);
        if (hasAudio) {
            if (stub.audio == Audio.ON) {
                this.mMediaRecorder.setAudioChannels(this.mProfile.audioChannels);
            } else if (stub.audio == Audio.MONO) {
                this.mMediaRecorder.setAudioChannels(1);
            } else if (stub.audio == Audio.STEREO) {
                this.mMediaRecorder.setAudioChannels(2);
            }
            this.mMediaRecorder.setAudioSamplingRate(this.mProfile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(this.mProfile.audioCodec);
            this.mMediaRecorder.setAudioEncodingBitRate(stub.audioBitRate);
        }
        if (stub.location != null) {
            this.mMediaRecorder.setLocation((float)stub.location.getLatitude(), (float)stub.location.getLongitude());
        }
        this.mMediaRecorder.setOutputFile(stub.file.getAbsolutePath());
        this.mMediaRecorder.setOrientationHint(stub.rotation);
        this.mMediaRecorder.setMaxFileSize(stub.maxSize);
        this.mMediaRecorder.setMaxDuration(stub.maxDuration);
        this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

            public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                switch (what) {
                    case 800: {
                        FullVideoRecorder.this.mResult.endReason = 2;
                        FullVideoRecorder.this.stop(false);
                        break;
                    }
                    case 801: {
                        FullVideoRecorder.this.mResult.endReason = 1;
                        FullVideoRecorder.this.stop(false);
                    }
                }
            }
        });
        try {
            this.mMediaRecorder.prepare();
            this.mMediaRecorderPrepared = true;
            this.mError = null;
            return true;
        }
        catch (Exception e) {
            LOG.w("prepareMediaRecorder:", "Error while preparing media recorder.", e);
            this.mMediaRecorderPrepared = false;
            this.mError = e;
            return false;
        }
    }

    @Override
    protected void onStart() {
        if (!this.prepareMediaRecorder(this.mResult)) {
            this.mResult = null;
            this.stop(false);
            return;
        }
        try {
            this.mMediaRecorder.start();
            this.dispatchVideoRecordingStart();
        }
        catch (Exception e) {
            LOG.w("start:", "Error while starting media recorder.", e);
            this.mResult = null;
            this.mError = e;
            this.stop(false);
        }
    }

    @Override
    protected void onStop(boolean isCameraShutdown) {
        if (this.mMediaRecorder != null) {
            block3: {
                this.dispatchVideoRecordingEnd();
                try {
                    this.mMediaRecorder.stop();
                }
                catch (Exception e) {
                    this.mResult = null;
                    if (this.mError != null) break block3;
                    LOG.w("stop:", "Error while closing media recorder.", e);
                    this.mError = e;
                }
            }
            this.mMediaRecorder.release();
        }
        this.mProfile = null;
        this.mMediaRecorder = null;
        this.mMediaRecorderPrepared = false;
        this.dispatchResult();
    }
}

