/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.engine.Camera1Engine;
import com.otaliastudios.cameraview.internal.utils.CamcorderProfiles;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.FullVideoRecorder;

public class Full1VideoRecorder
extends FullVideoRecorder {
    private static final String TAG = Full1VideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private final Camera1Engine mEngine;
    private final Camera mCamera;
    private final int mCameraId;

    public Full1VideoRecorder(@NonNull Camera1Engine engine, @NonNull Camera camera, int cameraId) {
        super(engine);
        this.mCamera = camera;
        this.mEngine = engine;
        this.mCameraId = cameraId;
    }

    @Override
    protected void applyVideoSource(@NonNull VideoResult.Stub stub, @NonNull MediaRecorder mediaRecorder) {
        mediaRecorder.setCamera(this.mCamera);
        mediaRecorder.setVideoSource(1);
    }

    @Override
    @NonNull
    protected CamcorderProfile getCamcorderProfile(@NonNull VideoResult.Stub stub) {
        Size size = stub.rotation % 180 != 0 ? stub.size.flip() : stub.size;
        return CamcorderProfiles.get(this.mCameraId, size);
    }

    @Override
    protected void onDispatchResult() {
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.mEngine);
        super.onDispatchResult();
    }
}

