/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.preview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.view.LayoutInflater;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.internal.utils.Op;
import com.otaliastudios.cameraview.preview.CameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;
import java.util.concurrent.ExecutionException;

public class TextureCameraPreview
extends CameraPreview<TextureView, SurfaceTexture> {
    private View mRootView;

    public TextureCameraPreview(@NonNull Context context, @NonNull ViewGroup parent) {
        super(context, parent);
    }

    @Override
    @NonNull
    protected TextureView onCreateView(@NonNull Context context, @NonNull ViewGroup parent) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.cameraview_texture_view, parent, false);
        parent.addView(root, 0);
        TextureView texture = (TextureView)root.findViewById(R.id.texture_view);
        texture.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TextureCameraPreview.this.dispatchOnSurfaceAvailable(width, height);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                TextureCameraPreview.this.dispatchOnSurfaceSizeChanged(width, height);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TextureCameraPreview.this.dispatchOnSurfaceDestroyed();
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        this.mRootView = root;
        return texture;
    }

    @Override
    @NonNull
    View getRootView() {
        return this.mRootView;
    }

    @Override
    @NonNull
    public Class<SurfaceTexture> getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    @NonNull
    public SurfaceTexture getOutput() {
        return ((TextureView)this.getView()).getSurfaceTexture();
    }

    @Override
    public boolean supportsCropping() {
        return true;
    }

    @Override
    protected void crop(final @NonNull Op<Void> op) {
        op.start();
        ((TextureView)this.getView()).post(new Runnable(){

            @Override
            public void run() {
                if (TextureCameraPreview.this.mInputStreamHeight == 0 || TextureCameraPreview.this.mInputStreamWidth == 0 || TextureCameraPreview.this.mOutputSurfaceHeight == 0 || TextureCameraPreview.this.mOutputSurfaceWidth == 0) {
                    op.end(null);
                    return;
                }
                float scaleX = 1.0f;
                float scaleY = 1.0f;
                AspectRatio current = AspectRatio.of(TextureCameraPreview.this.mOutputSurfaceWidth, TextureCameraPreview.this.mOutputSurfaceHeight);
                AspectRatio target = AspectRatio.of(TextureCameraPreview.this.mInputStreamWidth, TextureCameraPreview.this.mInputStreamHeight);
                if (current.toFloat() >= target.toFloat()) {
                    scaleY = current.toFloat() / target.toFloat();
                } else {
                    scaleX = target.toFloat() / current.toFloat();
                }
                ((TextureView)TextureCameraPreview.this.getView()).setScaleX(scaleX);
                ((TextureView)TextureCameraPreview.this.getView()).setScaleY(scaleY);
                TextureCameraPreview.this.mCropping = scaleX > 1.02f || scaleY > 1.02f;
                CameraPreview.LOG.i("crop:", "applied scaleX=", Float.valueOf(scaleX));
                CameraPreview.LOG.i("crop:", "applied scaleY=", Float.valueOf(scaleY));
                op.end(null);
            }
        });
    }

    @Override
    public void setDrawRotation(final int drawRotation) {
        super.setDrawRotation(drawRotation);
        final TaskCompletionSource task = new TaskCompletionSource();
        ((TextureView)this.getView()).post(new Runnable(){

            @Override
            public void run() {
                boolean flip;
                Matrix matrix = new Matrix();
                float outputCenterX = (float)TextureCameraPreview.this.mOutputSurfaceWidth / 2.0f;
                float outputCenterY = (float)TextureCameraPreview.this.mOutputSurfaceHeight / 2.0f;
                boolean bl = flip = drawRotation % 180 != 0;
                if (flip) {
                    float scaleX = (float)TextureCameraPreview.this.mOutputSurfaceHeight / (float)TextureCameraPreview.this.mOutputSurfaceWidth;
                    matrix.postScale(scaleX, 1.0f / scaleX, outputCenterX, outputCenterY);
                }
                matrix.postRotate((float)drawRotation, outputCenterX, outputCenterY);
                ((TextureView)TextureCameraPreview.this.getView()).setTransform(matrix);
                task.setResult(null);
            }
        });
        try {
            Tasks.await((Task)task.getTask());
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }
}

