/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.filter.Filter;
import com.otaliastudios.cameraview.internal.egl.EglCore;
import com.otaliastudios.cameraview.internal.egl.EglViewport;
import com.otaliastudios.cameraview.internal.egl.EglWindowSurface;
import com.otaliastudios.cameraview.internal.utils.CropHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.overlay.OverlayDrawer;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.preview.RendererFrameCallback;
import com.otaliastudios.cameraview.preview.RendererThread;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;

public class SnapshotGlPictureRecorder
extends PictureRecorder {
    private static final String TAG = SnapshotGlPictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private CameraEngine mEngine;
    private GlCameraPreview mPreview;
    private AspectRatio mOutputRatio;
    private Overlay mOverlay;
    private boolean mHasOverlay;
    private OverlayDrawer mOverlayDrawer;
    private int mTextureId;
    private float[] mTransform;
    private EglViewport mViewport;

    public SnapshotGlPictureRecorder(@NonNull PictureResult.Stub stub, @NonNull CameraEngine engine, @NonNull GlCameraPreview preview, @NonNull AspectRatio outputRatio) {
        super(stub, engine);
        this.mEngine = engine;
        this.mPreview = preview;
        this.mOutputRatio = outputRatio;
        this.mOverlay = engine.getOverlay();
        this.mHasOverlay = this.mOverlay != null && this.mOverlay.drawsOn(Overlay.Target.PICTURE_SNAPSHOT);
    }

    @Override
    @TargetApi(value=19)
    public void take() {
        this.mPreview.addRendererFrameCallback(new RendererFrameCallback(){

            @Override
            @RendererThread
            public void onRendererTextureCreated(int textureId) {
                SnapshotGlPictureRecorder.this.onRendererTextureCreated(textureId);
            }

            @Override
            @RendererThread
            public void onRendererFilterChanged(@NonNull Filter filter) {
                SnapshotGlPictureRecorder.this.onRendererFilterChanged(filter);
            }

            @Override
            @RendererThread
            public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, float scaleX, float scaleY) {
                SnapshotGlPictureRecorder.this.mPreview.removeRendererFrameCallback(this);
                SnapshotGlPictureRecorder.this.onRendererFrame(surfaceTexture, scaleX, scaleY);
            }
        });
    }

    @RendererThread
    @TargetApi(value=19)
    protected void onRendererTextureCreated(int textureId) {
        this.mTextureId = textureId;
        this.mViewport = new EglViewport();
        Rect crop = CropHelper.computeCrop(this.mResult.size, this.mOutputRatio);
        this.mResult.size = new Size(crop.width(), crop.height());
        this.mTransform = new float[16];
        Matrix.setIdentityM((float[])this.mTransform, (int)0);
        if (this.mHasOverlay) {
            this.mOverlayDrawer = new OverlayDrawer(this.mOverlay, this.mResult.size);
        }
    }

    @RendererThread
    @TargetApi(value=19)
    protected void onRendererFilterChanged(@NonNull Filter filter) {
        this.mViewport.setFilter(filter.copy());
    }

    @RendererThread
    @TargetApi(value=19)
    protected void onRendererFrame(final @NonNull SurfaceTexture surfaceTexture, final float scaleX, final float scaleY) {
        final EGLContext eglContext = EGL14.eglGetCurrentContext();
        WorkerHandler.execute(new Runnable(){

            @Override
            public void run() {
                SnapshotGlPictureRecorder.this.takeFrame(surfaceTexture, scaleX, scaleY, eglContext);
            }
        });
    }

    @WorkerThread
    @TargetApi(value=19)
    protected void takeFrame(@NonNull SurfaceTexture surfaceTexture, float scaleX, float scaleY, @NonNull EGLContext eglContext) {
        int fakeOutputTextureId = 9999;
        SurfaceTexture fakeOutputSurface = new SurfaceTexture(9999);
        fakeOutputSurface.setDefaultBufferSize(this.mResult.size.getWidth(), this.mResult.size.getHeight());
        EglCore core = new EglCore(eglContext, 1);
        EglWindowSurface eglSurface = new EglWindowSurface(core, fakeOutputSurface);
        eglSurface.makeCurrent();
        boolean flip = this.mEngine.getAngles().flip(Reference.VIEW, Reference.SENSOR);
        float realScaleX = flip ? scaleY : scaleX;
        float realScaleY = flip ? scaleX : scaleY;
        float scaleTranslX = (1.0f - realScaleX) / 2.0f;
        float scaleTranslY = (1.0f - realScaleY) / 2.0f;
        Matrix.translateM((float[])this.mTransform, (int)0, (float)scaleTranslX, (float)scaleTranslY, (float)0.0f);
        Matrix.scaleM((float[])this.mTransform, (int)0, (float)realScaleX, (float)realScaleY, (float)1.0f);
        Matrix.translateM((float[])this.mTransform, (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
        Matrix.rotateM((float[])this.mTransform, (int)0, (float)(-this.mResult.rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        this.mResult.rotation = 0;
        if (this.mResult.facing == Facing.FRONT) {
            Matrix.scaleM((float[])this.mTransform, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
        }
        Matrix.translateM((float[])this.mTransform, (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        if (this.mHasOverlay) {
            this.mOverlayDrawer.draw(Overlay.Target.PICTURE_SNAPSHOT);
            int rotation = this.mEngine.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
            Matrix.translateM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)0.5f, (float)0.5f, (float)0.0f);
            Matrix.rotateM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            Matrix.translateM((float[])this.mOverlayDrawer.getTransform(), (int)0, (float)-0.5f, (float)-0.5f, (float)0.0f);
        }
        long timestampUs = surfaceTexture.getTimestamp() / 1000L;
        LOG.i("takeFrame:", "timestampUs:", timestampUs);
        this.mViewport.drawFrame(timestampUs, this.mTextureId, this.mTransform);
        if (this.mHasOverlay) {
            this.mOverlayDrawer.render(timestampUs);
        }
        this.mResult.format = 0;
        this.mResult.data = eglSurface.saveFrameTo(Bitmap.CompressFormat.JPEG);
        eglSurface.releaseEglSurface();
        this.mViewport.release();
        fakeOutputSurface.release();
        if (this.mHasOverlay) {
            this.mOverlayDrawer.release();
        }
        core.release();
        this.dispatchResult();
    }

    @Override
    protected void dispatchResult() {
        this.mEngine = null;
        this.mOutputRatio = null;
        super.dispatchResult();
    }
}

