/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.engine.Camera2Engine;
import com.otaliastudios.cameraview.engine.action.Action;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.Actions;
import com.otaliastudios.cameraview.engine.action.BaseAction;
import com.otaliastudios.cameraview.engine.action.CompletionCallback;
import com.otaliastudios.cameraview.engine.lock.LockAction;
import com.otaliastudios.cameraview.picture.SnapshotGlPictureRecorder;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;

@RequiresApi(value=21)
public class Snapshot2PictureRecorder
extends SnapshotGlPictureRecorder {
    private static final String TAG = Snapshot2PictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final long LOCK_TIMEOUT = 2500L;
    private final Action mAction;
    private final ActionHolder mHolder;
    private final boolean mActionNeeded;
    private Integer mOriginalAeMode;
    private Integer mOriginalFlashMode;

    public Snapshot2PictureRecorder(@NonNull PictureResult.Stub stub, @NonNull Camera2Engine engine, @NonNull GlCameraPreview preview, @NonNull AspectRatio outputRatio) {
        super(stub, engine, preview, outputRatio);
        this.mHolder = engine;
        this.mAction = Actions.sequence(Actions.timeout(2500L, new LockAction()), new FlashAction());
        this.mAction.addCallback(new CompletionCallback(){

            @Override
            protected void onActionCompleted(@NonNull Action action) {
                LOG.i("Taking picture with super.take().");
                Snapshot2PictureRecorder.super.take();
            }
        });
        TotalCaptureResult lastResult = this.mHolder.getLastResult(this.mAction);
        if (lastResult == null) {
            LOG.w("Picture snapshot requested very early, before the first preview frame.", "Metering might not work as intended.");
        }
        Integer aeState = lastResult == null ? null : (Integer)lastResult.get(CaptureResult.CONTROL_AE_STATE);
        this.mActionNeeded = engine.getPictureSnapshotMetering() && aeState != null && aeState == 4;
        this.mOriginalAeMode = (Integer)this.mHolder.getBuilder(this.mAction).get(CaptureRequest.CONTROL_AE_MODE);
        this.mOriginalFlashMode = (Integer)this.mHolder.getBuilder(this.mAction).get(CaptureRequest.FLASH_MODE);
    }

    @Override
    public void take() {
        if (!this.mActionNeeded) {
            LOG.i("take:", "Engine does no metering or needs no flash.", "Taking fast snapshot.");
            super.take();
        } else {
            LOG.i("take:", "Engine needs flash. Starting action");
            this.mAction.start(this.mHolder);
        }
    }

    @Override
    protected void dispatchResult() {
        LOG.i("dispatchResult:", "Reverting the flash changes.");
        try {
            CaptureRequest.Builder builder = this.mHolder.getBuilder(this.mAction);
            builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            builder.set(CaptureRequest.FLASH_MODE, (Object)0);
            this.mHolder.applyBuilder(this.mAction, builder);
            builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)this.mOriginalAeMode);
            builder.set(CaptureRequest.FLASH_MODE, (Object)this.mOriginalFlashMode);
            this.mHolder.applyBuilder(this.mAction);
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
        super.dispatchResult();
    }

    private static class FlashAction
    extends BaseAction {
        private FlashAction() {
        }

        @Override
        protected void onStart(@NonNull ActionHolder holder) {
            super.onStart(holder);
            LOG.i("FlashAction:", "Parameters locked, opening torch.");
            holder.getBuilder(this).set(CaptureRequest.FLASH_MODE, (Object)2);
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            holder.applyBuilder(this);
        }

        @Override
        public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            super.onCaptureCompleted(holder, request, result);
            Integer flashState = (Integer)result.get(CaptureResult.FLASH_STATE);
            if (flashState == null) {
                LOG.w("FlashAction:", "Waiting flash, but flashState is null!", "Taking snapshot.");
                this.setState(Integer.MAX_VALUE);
            } else if (flashState == 3) {
                LOG.i("FlashAction:", "Waiting flash and we have FIRED state!", "Taking snapshot.");
                this.setState(Integer.MAX_VALUE);
            } else {
                LOG.i("FlashAction:", "Waiting flash but flashState is", flashState, ". Waiting...");
            }
        }
    }
}

