/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.picture;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CaptureRequest;
import android.media.Image;
import android.media.ImageReader;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.exifinterface.media.ExifInterface;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.engine.Camera2Engine;
import com.otaliastudios.cameraview.engine.action.Action;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.BaseAction;
import com.otaliastudios.cameraview.internal.utils.ExifHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@RequiresApi(value=21)
public class Full2PictureRecorder
extends PictureRecorder
implements ImageReader.OnImageAvailableListener {
    private static final String TAG = Full2PictureRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private final ActionHolder mHolder;
    private final Action mAction;
    private final ImageReader mPictureReader;
    private final CaptureRequest.Builder mPictureBuilder;

    public Full2PictureRecorder(@NonNull PictureResult.Stub stub, @NonNull Camera2Engine engine, @NonNull CaptureRequest.Builder pictureBuilder, @NonNull ImageReader pictureReader) {
        super(stub, engine);
        this.mHolder = engine;
        this.mPictureBuilder = pictureBuilder;
        this.mPictureReader = pictureReader;
        this.mPictureReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, WorkerHandler.get().getHandler());
        this.mAction = new BaseAction(){

            @Override
            protected void onStart(@NonNull ActionHolder holder) {
                super.onStart(holder);
                Full2PictureRecorder.this.mPictureBuilder.addTarget(Full2PictureRecorder.this.mPictureReader.getSurface());
                Full2PictureRecorder.this.mPictureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)Full2PictureRecorder.this.mResult.rotation);
                Full2PictureRecorder.this.mPictureBuilder.setTag((Object)2);
                try {
                    holder.applyBuilder(this, Full2PictureRecorder.this.mPictureBuilder);
                }
                catch (CameraAccessException e) {
                    Full2PictureRecorder.this.mResult = null;
                    Full2PictureRecorder.this.mError = e;
                    Full2PictureRecorder.this.dispatchResult();
                }
            }

            @Override
            public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
                super.onCaptureStarted(holder, request);
                if (request.getTag() == Integer.valueOf(2)) {
                    LOG.i("onCaptureStarted:", "Dispatching picture shutter.");
                    Full2PictureRecorder.this.dispatchOnShutter(false);
                    this.setState(Integer.MAX_VALUE);
                }
            }
        };
    }

    @Override
    public void take() {
        this.mAction.start(this.mHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImageAvailable(ImageReader reader) {
        LOG.i("onImageAvailable started.");
        try (Image image = null;){
            image = reader.acquireNextImage();
            ByteBuffer buffer = image.getPlanes()[0].getBuffer();
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.mResult.data = bytes;
        }
        this.mResult.format = 0;
        this.mResult.rotation = 0;
        try {
            ExifInterface exif = new ExifInterface((InputStream)new ByteArrayInputStream(this.mResult.data));
            int exifOrientation = exif.getAttributeInt("Orientation", 1);
            this.mResult.rotation = ExifHelper.readExifOrientation(exifOrientation);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.i("onImageAvailable ended.");
        this.dispatchResult();
    }
}

