/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import android.media.Image;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import java.nio.ByteBuffer;

@RequiresApi(value=19)
public class ImageHelper {
    public static void convertToNV21(@NonNull Image image, @NonNull byte[] result) {
        if (image.getFormat() != 35) {
            throw new IllegalStateException("CAn only convert from YUV_420_888.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int ySize = width * height;
        int uvSize = width * height / 4;
        ByteBuffer yBuffer = image.getPlanes()[0].getBuffer();
        ByteBuffer uBuffer = image.getPlanes()[1].getBuffer();
        ByteBuffer vBuffer = image.getPlanes()[2].getBuffer();
        int rowStride = image.getPlanes()[0].getRowStride();
        if (image.getPlanes()[0].getPixelStride() != 1) {
            throw new AssertionError((Object)"Something wrong in convertToNV21");
        }
        if (rowStride == width) {
            yBuffer.get(result, 0, ySize);
            pos += ySize;
        } else {
            int yBufferPos = width - rowStride;
            for (int pos = 0; pos < ySize; pos += width) {
                yBuffer.position(yBufferPos += rowStride - width);
                yBuffer.get(result, pos, width);
            }
        }
        rowStride = image.getPlanes()[2].getRowStride();
        int pixelStride = image.getPlanes()[2].getPixelStride();
        if (rowStride != image.getPlanes()[1].getRowStride()) {
            throw new AssertionError((Object)"Something wrong in convertToNV21");
        }
        if (pixelStride != image.getPlanes()[1].getPixelStride()) {
            throw new AssertionError((Object)"Something wrong in convertToNV21");
        }
        if (pixelStride == 2 && rowStride == width && uBuffer.get(0) == vBuffer.get(1)) {
            byte savePixel = vBuffer.get(1);
            vBuffer.put(1, (byte)0);
            if (uBuffer.get(0) == 0) {
                vBuffer.put(1, (byte)-1);
                if (uBuffer.get(0) == 255) {
                    vBuffer.put(1, savePixel);
                    vBuffer.get(result, ySize, uvSize);
                    return;
                }
            }
            vBuffer.put(1, savePixel);
        }
        for (int row = 0; row < height / 2; ++row) {
            for (int col = 0; col < width / 2; ++col) {
                int vuPos = col * pixelStride + row * rowStride;
                result[pos++] = vBuffer.get(vuPos);
                result[pos++] = uBuffer.get(vuPos);
            }
        }
    }
}

