/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal;

import android.opengl.GLES20;
import android.opengl.Matrix;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.CameraLogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtils {
    private static final String TAG = GlUtils.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final float[] IDENTITY_MATRIX = new float[16];

    public static void checkError(@NonNull String opName) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String message = LOG.e("Error during", opName, "glError 0x", Integer.toHexString(error));
            throw new RuntimeException(message);
        }
    }

    public static void checkLocation(int location, @NonNull String name) {
        if (location < 0) {
            String message = LOG.e("Unable to locate", name, "in program");
            throw new RuntimeException(message);
        }
    }

    public static int loadShader(int shaderType, @NonNull String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GlUtils.checkError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            LOG.e("Could not compile shader", shaderType, ":", GLES20.glGetShaderInfoLog((int)shader));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static int createProgram(@NonNull String vertexSource, @NonNull String fragmentSource) {
        int vertexShader = GlUtils.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = GlUtils.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GlUtils.checkError("glCreateProgram");
        if (program == 0) {
            LOG.e("Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GlUtils.checkError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)pixelShader);
        GlUtils.checkError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            LOG.e("Could not link program:", GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        return program;
    }

    public static FloatBuffer floatBuffer(@NonNull float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    static {
        Matrix.setIdentityM((float[])IDENTITY_MATRIX, (int)0);
    }
}

