/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.graphics.Color;
import android.opengl.GLES20;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.cameraview.internal.GlUtils;

public class TintFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform vec3 tint;\nvec3 color_ratio;\nvarying vec2 vTextureCoord;\nvoid main() {\n  color_ratio[0] = 0.21;\n  color_ratio[1] = 0.71;\n  color_ratio[2] = 0.07;\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  float avg_color = dot(color_ratio, color.rgb);\n  vec3 new_color = min(0.8 * avg_color + 0.2 * tint, 1.0);\n  gl_FragColor = vec4(new_color.rgb, color.a);\n}\n";
    private int tint = -65536;
    private int tintLocation = -1;

    public void setTint(@ColorInt int color) {
        this.tint = Color.rgb((int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    @ColorInt
    public int getTint() {
        return this.tint;
    }

    @Override
    public void setParameter1(float value) {
        this.setTint((int)(value * 1.6777215E7f));
    }

    @Override
    public float getParameter1() {
        int color = this.getTint();
        color = Color.argb((int)0, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
        return (float)color / 1.6777215E7f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.tintLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"tint");
        GlUtils.checkLocation(this.tintLocation, "tint");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.tintLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        float[] channels = new float[]{(float)Color.red((int)this.tint) / 255.0f, (float)Color.green((int)this.tint) / 255.0f, (float)Color.blue((int)this.tint) / 255.0f};
        GLES20.glUniform3fv((int)this.tintLocation, (int)1, (float[])channels, (int)0);
        GlUtils.checkError("glUniform3fv");
    }
}

