/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.cameraview.internal.GlUtils;

public class TemperatureFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nuniform float scale;\nvarying vec2 vTextureCoord;\nvoid main() {\n  vec4 color = texture2D(sTexture, vTextureCoord);\n  vec3 new_color = color.rgb;\n  new_color.r = color.r + color.r * ( 1.0 - color.r) * scale;\n  new_color.b = color.b - color.b * ( 1.0 - color.b) * scale;\n  if (scale > 0.0) { \n    new_color.g = color.g + color.g * ( 1.0 - color.g) * scale * 0.25;\n  }\n  float max_value = max(new_color.r, max(new_color.g, new_color.b));\n  if (max_value > 1.0) { \n     new_color /= max_value;\n  } \n  gl_FragColor = vec4(new_color, color.a);\n}\n";
    private float scale = 1.0f;
    private int scaleLocation = -1;

    public void setTemperature(float value) {
        if (value < -1.0f) {
            value = -1.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.scale = value;
    }

    public float getTemperature() {
        return this.scale;
    }

    @Override
    public void setParameter1(float value) {
        this.setTemperature(2.0f * value - 1.0f);
    }

    @Override
    public float getParameter1() {
        return (this.getTemperature() + 1.0f) / 2.0f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.scaleLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"scale");
        GlUtils.checkLocation(this.scaleLocation, "scale");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.scaleLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        GLES20.glUniform1f((int)this.scaleLocation, (float)this.scale);
        GlUtils.checkError("glUniform1f");
    }
}

