/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.meter;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.meter.BaseReset;

@RequiresApi(value=21)
public class WhiteBalanceReset
extends BaseReset {
    private static final String TAG = WhiteBalanceReset.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    public WhiteBalanceReset() {
        super(true);
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder, @Nullable MeteringRectangle area) {
        LOG.w("onStarted:", "with area:", area);
        int maxRegions = this.readCharacteristic(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB, 0);
        if (area != null && maxRegions > 0) {
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AWB_REGIONS, (Object)new MeteringRectangle[]{area});
            holder.applyBuilder(this);
        }
        this.setState(Integer.MAX_VALUE);
    }
}

