/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.meter;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.meter.BaseMeter;
import java.util.List;

@RequiresApi(value=21)
public class ExposureMeter
extends BaseMeter {
    private static final String TAG = ExposureMeter.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int STATE_WAITING_PRECAPTURE = 0;
    private static final int STATE_WAITING_PRECAPTURE_END = 1;

    public ExposureMeter(@NonNull List<MeteringRectangle> areas, boolean skipIfPossible) {
        super(areas, skipIfPossible);
    }

    @Override
    protected boolean checkIsSupported(@NonNull ActionHolder holder) {
        boolean isNotLegacy = this.readCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, -1) != 2;
        Integer aeMode = (Integer)holder.getBuilder(this).get(CaptureRequest.CONTROL_AE_MODE);
        boolean isAEOn = aeMode != null && (aeMode == 1 || aeMode == 3 || aeMode == 2 || aeMode == 4 || aeMode == 5);
        boolean result = isNotLegacy && isAEOn;
        LOG.i("checkIsSupported:", result);
        return result;
    }

    @Override
    protected boolean checkShouldSkip(@NonNull ActionHolder holder) {
        TotalCaptureResult lastResult = holder.getLastResult(this);
        if (lastResult != null) {
            Integer aeState = (Integer)lastResult.get(CaptureResult.CONTROL_AE_STATE);
            boolean result = aeState != null && aeState == 2;
            LOG.i("checkShouldSkip:", result);
            return result;
        }
        LOG.i("checkShouldSkip: false - lastResult is null.");
        return false;
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder, @NonNull List<MeteringRectangle> areas) {
        LOG.i("onStarted:", "with areas:", areas);
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
        int maxRegions = this.readCharacteristic(CameraCharacteristics.CONTROL_MAX_REGIONS_AE, 0);
        if (!areas.isEmpty() && maxRegions > 0) {
            int max = Math.min(maxRegions, areas.size());
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_REGIONS, (Object)areas.subList(0, max).toArray(new MeteringRectangle[0]));
        }
        holder.applyBuilder(this);
        this.setState(0);
    }

    @Override
    protected void onCompleted(@NonNull ActionHolder holder) {
        super.onCompleted(holder);
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, null);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
        Integer aeTriggerState = (Integer)result.get(CaptureResult.CONTROL_AE_PRECAPTURE_TRIGGER);
        LOG.i("onCaptureCompleted:", "aeState:", aeState, "aeTriggerState:", aeTriggerState);
        if (aeState == null) {
            return;
        }
        if (this.getState() == 0) {
            switch (aeState) {
                case 5: {
                    this.setState(1);
                    break;
                }
                case 2: 
                case 4: {
                    if (aeTriggerState == null || aeTriggerState != 1) break;
                    this.setSuccessful(true);
                    this.setState(Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    this.setSuccessful(false);
                    this.setState(Integer.MAX_VALUE);
                    break;
                }
            }
        }
        if (this.getState() == 1) {
            switch (aeState) {
                case 2: 
                case 4: {
                    this.setSuccessful(true);
                    this.setState(Integer.MAX_VALUE);
                    break;
                }
                case 3: {
                    this.setSuccessful(false);
                    this.setState(Integer.MAX_VALUE);
                    break;
                }
            }
        }
    }
}

