/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.action;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.engine.action.Action;
import com.otaliastudios.cameraview.engine.action.ActionCallback;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.BaseAction;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
class TogetherAction
extends BaseAction {
    private final List<BaseAction> actions;
    private final List<BaseAction> runningActions;

    TogetherAction(@NonNull List<BaseAction> actions) {
        this.actions = new ArrayList<BaseAction>(actions);
        this.runningActions = new ArrayList<BaseAction>(actions);
        for (BaseAction action : actions) {
            action.addCallback(new ActionCallback(){

                @Override
                public void onActionStateChanged(@NonNull Action action, int state) {
                    if (state == Integer.MAX_VALUE) {
                        TogetherAction.this.runningActions.remove(action);
                    }
                    if (TogetherAction.this.runningActions.isEmpty()) {
                        TogetherAction.this.setState(Integer.MAX_VALUE);
                    }
                }
            });
        }
    }

    @Override
    protected void onStart(@NonNull ActionHolder holder) {
        super.onStart(holder);
        for (BaseAction action : this.actions) {
            if (action.isCompleted()) continue;
            action.onStart(holder);
        }
    }

    @Override
    protected void onAbort(@NonNull ActionHolder holder) {
        super.onAbort(holder);
        for (BaseAction action : this.actions) {
            if (action.isCompleted()) continue;
            action.onAbort(holder);
        }
    }

    @Override
    public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
        super.onCaptureStarted(holder, request);
        for (BaseAction action : this.actions) {
            if (action.isCompleted()) continue;
            action.onCaptureStarted(holder, request);
        }
    }

    @Override
    public void onCaptureProgressed(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull CaptureResult result) {
        super.onCaptureProgressed(holder, request, result);
        for (BaseAction action : this.actions) {
            if (action.isCompleted()) continue;
            action.onCaptureProgressed(holder, request, result);
        }
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        for (BaseAction action : this.actions) {
            if (action.isCompleted()) continue;
            action.onCaptureCompleted(holder, request, result);
        }
    }
}

