/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraLogger;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class Step {
    private static final String TAG = Step.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    static final int STATE_STOPPING = -1;
    static final int STATE_STOPPED = 0;
    static final int STATE_STARTING = 1;
    static final int STATE_STARTED = 2;
    private int state = 0;
    private Task<Void> task = Tasks.forResult(null);
    private final String name;
    private final Callback callback;

    Step(@NonNull String name, @NonNull Callback callback) {
        this.name = name.toUpperCase();
        this.callback = callback;
    }

    int getState() {
        return this.state;
    }

    @VisibleForTesting
    void setState(int newState) {
        this.state = newState;
    }

    @NonNull
    String getStateName() {
        switch (this.state) {
            case -1: {
                return this.name + "_STATE_STOPPING";
            }
            case 0: {
                return this.name + "_STATE_STOPPED";
            }
            case 1: {
                return this.name + "_STATE_STARTING";
            }
            case 2: {
                return this.name + "_STATE_STARTED";
            }
        }
        return "null";
    }

    boolean isStoppingOrStopped() {
        return this.state == -1 || this.state == 0;
    }

    boolean isStartedOrStarting() {
        return this.state == 1 || this.state == 2;
    }

    boolean isStarted() {
        return this.state == 2;
    }

    @NonNull
    Task<Void> getTask() {
        return this.task;
    }

    Task<Void> doStart(boolean swallowExceptions, @NonNull Callable<Task<Void>> op) {
        return this.doStart(swallowExceptions, op, null);
    }

    Task<Void> doStart(final boolean swallowExceptions, final @NonNull Callable<Task<Void>> op, final @Nullable Runnable onStarted) {
        LOG.i(this.name, "doStart", "Called. Enqueuing.");
        this.task = this.task.continueWithTask(this.callback.getExecutor(), (Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(@NonNull Task<Void> task) throws Exception {
                LOG.i(Step.this.name, "doStart", "About to start. Setting state to STARTING");
                Step.this.setState(1);
                return ((Task)op.call()).addOnFailureListener(Step.this.callback.getExecutor(), new OnFailureListener(){

                    public void onFailure(@NonNull Exception e) {
                        LOG.w(Step.this.name, "doStart", "Failed with error", e, "Setting state to STOPPED");
                        Step.this.setState(0);
                        if (!swallowExceptions) {
                            Step.this.callback.handleException(e);
                        }
                    }
                });
            }
        }).onSuccessTask(this.callback.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

            @NonNull
            public Task<Void> then(@Nullable Void aVoid) {
                LOG.i(Step.this.name, "doStart", "Succeeded! Setting state to STARTED");
                Step.this.setState(2);
                if (onStarted != null) {
                    onStarted.run();
                }
                return Tasks.forResult(null);
            }
        });
        return this.task;
    }

    Task<Void> doStop(boolean swallowExceptions, @NonNull Callable<Task<Void>> op) {
        return this.doStop(swallowExceptions, op, null);
    }

    Task<Void> doStop(final boolean swallowExceptions, final @NonNull Callable<Task<Void>> op, final @Nullable Runnable onStopped) {
        LOG.i(this.name, "doStop", "Called. Enqueuing.");
        this.task = this.task.continueWithTask(this.callback.getExecutor(), (Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(@NonNull Task<Void> task) throws Exception {
                LOG.i(Step.this.name, "doStop", "About to stop. Setting state to STOPPING");
                Step.this.state = -1;
                return ((Task)op.call()).addOnFailureListener(Step.this.callback.getExecutor(), new OnFailureListener(){

                    public void onFailure(@NonNull Exception e) {
                        LOG.w(Step.this.name, "doStop", "Failed with error", e, "Setting state to STOPPED");
                        Step.this.state = 0;
                        if (!swallowExceptions) {
                            Step.this.callback.handleException(e);
                        }
                    }
                });
            }
        }).onSuccessTask(this.callback.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

            @NonNull
            public Task<Void> then(@Nullable Void aVoid) {
                LOG.i(Step.this.name, "doStop", "Succeeded! Setting state to STOPPED");
                Step.this.state = 0;
                if (onStopped != null) {
                    onStopped.run();
                }
                return Tasks.forResult(null);
            }
        });
        return this.task;
    }

    static interface Callback {
        @NonNull
        public Executor getExecutor();

        public void handleException(@NonNull Exception var1);
    }
}

