/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.location.Location;
import android.media.Image;
import android.media.ImageReader;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.EngineThread;
import com.otaliastudios.cameraview.engine.LogAction;
import com.otaliastudios.cameraview.engine.action.Action;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.Actions;
import com.otaliastudios.cameraview.engine.action.BaseAction;
import com.otaliastudios.cameraview.engine.action.CompletionCallback;
import com.otaliastudios.cameraview.engine.mappers.Camera2Mapper;
import com.otaliastudios.cameraview.engine.meter.MeterAction;
import com.otaliastudios.cameraview.engine.meter.MeterResetAction;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.gesture.Gesture;
import com.otaliastudios.cameraview.internal.utils.CropHelper;
import com.otaliastudios.cameraview.internal.utils.ImageHelper;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.picture.Full2PictureRecorder;
import com.otaliastudios.cameraview.picture.Snapshot2PictureRecorder;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.SizeSelectors;
import com.otaliastudios.cameraview.video.Full2VideoRecorder;
import com.otaliastudios.cameraview.video.SnapshotVideoRecorder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;

@RequiresApi(value=21)
public class Camera2Engine
extends CameraEngine
implements ImageReader.OnImageAvailableListener,
ActionHolder {
    private static final String TAG = Camera2Engine.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int FRAME_PROCESSING_FORMAT = 17;
    private static final int FRAME_PROCESSING_INPUT_FORMAT = 35;
    @VisibleForTesting
    static final long METER_TIMEOUT = 2500L;
    private final CameraManager mManager;
    private String mCameraId;
    private CameraDevice mCamera;
    private CameraCharacteristics mCameraCharacteristics;
    private CameraCaptureSession mSession;
    private CaptureRequest.Builder mRepeatingRequestBuilder;
    private TotalCaptureResult mLastRepeatingResult;
    private final Camera2Mapper mMapper = Camera2Mapper.get();
    private com.otaliastudios.cameraview.size.Size mFrameProcessingSize;
    private ImageReader mFrameProcessingReader;
    private final WorkerHandler mFrameConversionHandler;
    private final Object mFrameProcessingImageLock = new Object();
    private Surface mFrameProcessingSurface;
    private Surface mPreviewStreamSurface;
    private VideoResult.Stub mFullVideoPendingStub;
    private ImageReader mPictureReader;
    private final boolean mPictureCaptureStopsPreview = false;
    private final List<Action> mActions = new CopyOnWriteArrayList<Action>();
    private MeterAction mMeterAction;
    private final CameraCaptureSession.CaptureCallback mRepeatingRequestCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            for (Action action : Camera2Engine.this.mActions) {
                action.onCaptureStarted(Camera2Engine.this, request);
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            for (Action action : Camera2Engine.this.mActions) {
                action.onCaptureProgressed(Camera2Engine.this, request, partialResult);
            }
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            Camera2Engine.this.mLastRepeatingResult = result;
            for (Action action : Camera2Engine.this.mActions) {
                action.onCaptureCompleted(Camera2Engine.this, request, result);
            }
        }
    };
    private final Runnable mUnlockAndResetMeteringRunnable = new Runnable(){

        @Override
        public void run() {
            Camera2Engine.this.unlockAndResetMetering();
        }
    };

    public Camera2Engine(CameraEngine.Callback callback) {
        super(callback);
        this.mManager = (CameraManager)this.mCallback.getContext().getSystemService("camera");
        this.mFrameConversionHandler = WorkerHandler.get("CameraFrameConversion");
        new LogAction().start(this);
    }

    @NonNull
    private <T> T readCharacteristic(@NonNull CameraCharacteristics.Key<T> key, @NonNull T fallback) {
        return this.readCharacteristic(this.mCameraCharacteristics, key, fallback);
    }

    @NonNull
    private <T> T readCharacteristic(@NonNull CameraCharacteristics characteristics, @NonNull CameraCharacteristics.Key<T> key, @NonNull T fallback) {
        Object value = characteristics.get(key);
        return (T)(value == null ? fallback : value);
    }

    @NonNull
    private CameraException createCameraException(@NonNull CameraAccessException exception) {
        int reason;
        switch (exception.getReason()) {
            case 1: 
            case 4: 
            case 5: {
                reason = 1;
                break;
            }
            case 2: 
            case 3: {
                reason = 3;
                break;
            }
            default: {
                reason = 0;
            }
        }
        return new CameraException(exception, reason);
    }

    @NonNull
    private CameraException createCameraException(int stateCallbackError) {
        int reason;
        switch (stateCallbackError) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                reason = 1;
                break;
            }
            default: {
                reason = 0;
            }
        }
        return new CameraException(reason);
    }

    @NonNull
    private CaptureRequest.Builder createRepeatingRequestBuilder(int template) throws CameraAccessException {
        CaptureRequest.Builder oldBuilder = this.mRepeatingRequestBuilder;
        this.mRepeatingRequestBuilder = this.mCamera.createCaptureRequest(template);
        this.mRepeatingRequestBuilder.setTag((Object)template);
        this.applyAllParameters(this.mRepeatingRequestBuilder, oldBuilder);
        return this.mRepeatingRequestBuilder;
    }

    private void addRepeatingRequestBuilderSurfaces(Surface ... extraSurfaces) {
        this.mRepeatingRequestBuilder.addTarget(this.mPreviewStreamSurface);
        if (this.mFrameProcessingSurface != null) {
            this.mRepeatingRequestBuilder.addTarget(this.mFrameProcessingSurface);
        }
        for (Surface extraSurface : extraSurfaces) {
            if (extraSurface == null) {
                throw new IllegalArgumentException("Should not add a null surface.");
            }
            this.mRepeatingRequestBuilder.addTarget(extraSurface);
        }
    }

    private void removeRepeatingRequestBuilderSurfaces() {
        this.mRepeatingRequestBuilder.removeTarget(this.mPreviewStreamSurface);
        if (this.mFrameProcessingSurface != null) {
            this.mRepeatingRequestBuilder.removeTarget(this.mFrameProcessingSurface);
        }
    }

    protected void applyRepeatingRequestBuilder() {
        this.applyRepeatingRequestBuilder(true, 3);
    }

    private void applyRepeatingRequestBuilder(boolean checkStarted, int errorReason) {
        if (this.getPreviewState() == 2 || !checkStarted) {
            try {
                this.mSession.setRepeatingRequest(this.mRepeatingRequestBuilder.build(), this.mRepeatingRequestCallback, null);
            }
            catch (CameraAccessException e) {
                throw new CameraException(e, errorReason);
            }
            catch (IllegalStateException e) {
                LOG.e("applyRepeatingRequestBuilder: session is invalid!", e, "checkStarted:", checkStarted, "currentThread:", Thread.currentThread().getName(), "previewState:", this.getPreviewState(), "bindState:", this.getBindState(), "engineState:", this.getEngineState());
                throw new CameraException(3);
            }
        }
    }

    @Override
    @EngineThread
    @NonNull
    protected List<com.otaliastudios.cameraview.size.Size> getPreviewStreamAvailableSizes() {
        try {
            CameraCharacteristics characteristics = this.mManager.getCameraCharacteristics(this.mCameraId);
            StreamConfigurationMap streamMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamMap == null) {
                throw new RuntimeException("StreamConfigurationMap is null. Should not happen.");
            }
            Size[] sizes = streamMap.getOutputSizes(this.mPreview.getOutputClass());
            ArrayList<com.otaliastudios.cameraview.size.Size> candidates = new ArrayList<com.otaliastudios.cameraview.size.Size>(sizes.length);
            for (Size size : sizes) {
                com.otaliastudios.cameraview.size.Size add = new com.otaliastudios.cameraview.size.Size(size.getWidth(), size.getHeight());
                if (candidates.contains(add)) continue;
                candidates.add(add);
            }
            return candidates;
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
    }

    @Override
    @EngineThread
    protected void onPreviewStreamSizeChanged() {
        this.restartBind();
    }

    @Override
    @EngineThread
    protected final boolean collectCameraInfo(@NonNull Facing facing) {
        int internalFacing = this.mMapper.mapFacing(facing);
        String[] cameraIds = null;
        try {
            cameraIds = this.mManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
        LOG.i("collectCameraInfo", "Facing:", facing, "Internal:", internalFacing, "Cameras:", cameraIds.length);
        for (String cameraId : cameraIds) {
            try {
                CameraCharacteristics characteristics = this.mManager.getCameraCharacteristics(cameraId);
                if (internalFacing != this.readCharacteristic(characteristics, CameraCharacteristics.LENS_FACING, -99)) continue;
                this.mCameraId = cameraId;
                int sensorOffset = this.readCharacteristic(characteristics, CameraCharacteristics.SENSOR_ORIENTATION, 0);
                this.getAngles().setSensorOffset(facing, sensorOffset);
                return true;
            }
            catch (CameraAccessException cameraAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    @EngineThread
    @SuppressLint(value={"MissingPermission"})
    @NonNull
    protected Task<Void> onStartEngine() {
        final TaskCompletionSource task = new TaskCompletionSource();
        try {
            this.mManager.openCamera(this.mCameraId, new CameraDevice.StateCallback(){

                public void onOpened(@NonNull CameraDevice camera) {
                    Camera2Engine.this.mCamera = camera;
                    try {
                        LOG.i("createCamera:", "Applying default parameters.");
                        Camera2Engine.this.mCameraCharacteristics = Camera2Engine.this.mManager.getCameraCharacteristics(Camera2Engine.this.mCameraId);
                        boolean flip = Camera2Engine.this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
                        Camera2Engine.this.mCameraOptions = new CameraOptions(Camera2Engine.this.mManager, Camera2Engine.this.mCameraId, flip);
                        Camera2Engine.this.createRepeatingRequestBuilder(1);
                    }
                    catch (CameraAccessException e) {
                        task.trySetException((Exception)Camera2Engine.this.createCameraException(e));
                        return;
                    }
                    task.trySetResult(null);
                }

                public void onDisconnected(@NonNull CameraDevice camera) {
                    task.trySetException((Exception)new CameraException(3));
                }

                public void onError(@NonNull CameraDevice camera, int error) {
                    task.trySetException((Exception)Camera2Engine.this.createCameraException(error));
                }
            }, null);
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
        return task.getTask();
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStartBind() {
        LOG.i("onStartBind:", "Started");
        final TaskCompletionSource task = new TaskCompletionSource();
        this.mCaptureSize = this.computeCaptureSize();
        this.mPreviewStreamSize = this.computePreviewStreamSize();
        ArrayList<Surface> outputSurfaces = new ArrayList<Surface>();
        final Object output = this.mPreview.getOutput();
        if (output instanceof SurfaceHolder) {
            try {
                Tasks.await((Task)Tasks.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() {
                        ((SurfaceHolder)output).setFixedSize(Camera2Engine.this.mPreviewStreamSize.getWidth(), Camera2Engine.this.mPreviewStreamSize.getHeight());
                        return null;
                    }
                }));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CameraException(e, 1);
            }
            this.mPreviewStreamSurface = ((SurfaceHolder)output).getSurface();
        } else if (output instanceof SurfaceTexture) {
            ((SurfaceTexture)output).setDefaultBufferSize(this.mPreviewStreamSize.getWidth(), this.mPreviewStreamSize.getHeight());
            this.mPreviewStreamSurface = new Surface((SurfaceTexture)output);
        } else {
            throw new RuntimeException("Unknown CameraPreview output class.");
        }
        outputSurfaces.add(this.mPreviewStreamSurface);
        if (this.getMode() == Mode.VIDEO && this.mFullVideoPendingStub != null) {
            Full2VideoRecorder recorder = new Full2VideoRecorder(this, this.mCameraId);
            try {
                outputSurfaces.add(recorder.createInputSurface(this.mFullVideoPendingStub));
            }
            catch (Full2VideoRecorder.PrepareException e) {
                throw new CameraException(e, 1);
            }
            this.mVideoRecorder = recorder;
        }
        if (this.getMode() == Mode.PICTURE) {
            this.mPictureReader = ImageReader.newInstance((int)this.mCaptureSize.getWidth(), (int)this.mCaptureSize.getHeight(), (int)256, (int)2);
            outputSurfaces.add(this.mPictureReader.getSurface());
        }
        if (this.hasFrameProcessors()) {
            StreamConfigurationMap streamMap = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamMap == null) {
                throw new RuntimeException("StreamConfigurationMap is null. Should not happen.");
            }
            Size[] aSizes = streamMap.getOutputSizes(35);
            ArrayList<com.otaliastudios.cameraview.size.Size> sizes = new ArrayList<com.otaliastudios.cameraview.size.Size>();
            for (Size aSize : aSizes) {
                sizes.add(new com.otaliastudios.cameraview.size.Size(aSize.getWidth(), aSize.getHeight()));
            }
            this.mFrameProcessingSize = SizeSelectors.and(SizeSelectors.maxWidth(Math.min(700, this.mPreviewStreamSize.getWidth())), SizeSelectors.maxHeight(Math.min(700, this.mPreviewStreamSize.getHeight())), SizeSelectors.biggest()).select(sizes).get(0);
            this.mFrameProcessingReader = ImageReader.newInstance((int)this.mFrameProcessingSize.getWidth(), (int)this.mFrameProcessingSize.getHeight(), (int)35, (int)2);
            this.mFrameProcessingReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)this, this.mFrameConversionHandler.getHandler());
            this.mFrameProcessingSurface = this.mFrameProcessingReader.getSurface();
            outputSurfaces.add(this.mFrameProcessingSurface);
        } else {
            this.mFrameProcessingReader = null;
            this.mFrameProcessingSize = null;
            this.mFrameProcessingSurface = null;
        }
        try {
            this.mCamera.createCaptureSession(outputSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession session) {
                    Camera2Engine.this.mSession = session;
                    LOG.i("onStartBind:", "Completed");
                    task.trySetResult(null);
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession session) {
                    String message = LOG.e("onConfigureFailed! Session", session);
                    throw new RuntimeException(message);
                }
            }, null);
        }
        catch (CameraAccessException e) {
            throw this.createCameraException(e);
        }
        return task.getTask();
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStartPreview() {
        LOG.i("onStartPreview", "Dispatching onCameraPreviewStreamSizeChanged.");
        this.mCallback.onCameraPreviewStreamSizeChanged();
        com.otaliastudios.cameraview.size.Size previewSizeForView = this.getPreviewStreamSize(Reference.VIEW);
        if (previewSizeForView == null) {
            throw new IllegalStateException("previewStreamSize should not be null at this point.");
        }
        this.mPreview.setStreamSize(previewSizeForView.getWidth(), previewSizeForView.getHeight());
        this.mPreview.setDrawRotation(this.getAngles().offset(Reference.BASE, Reference.VIEW, Axis.ABSOLUTE));
        if (this.hasFrameProcessors()) {
            this.getFrameManager().setUp(17, this.mFrameProcessingSize);
        }
        LOG.i("onStartPreview", "Starting preview.");
        this.addRepeatingRequestBuilderSurfaces(new Surface[0]);
        this.applyRepeatingRequestBuilder(false, 2);
        LOG.i("onStartPreview", "Started preview.");
        if (this.mFullVideoPendingStub != null) {
            LOG.i("onStartPreview", "Posting doTakeVideo call.");
            final VideoResult.Stub stub = this.mFullVideoPendingStub;
            this.mFullVideoPendingStub = null;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    LOG.i("onStartPreview", "Executing doTakeVideo call.");
                    Camera2Engine.this.doTakeVideo(stub);
                }
            });
        }
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopPreview() {
        LOG.i("onStopPreview:", "About to clean up.");
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop(true);
            this.mVideoRecorder = null;
        }
        this.mPictureRecorder = null;
        if (this.hasFrameProcessors()) {
            this.getFrameManager().release();
        }
        try {
            this.mSession.stopRepeating();
        }
        catch (CameraAccessException e) {
            LOG.w(new Object[]{"stopRepeating failed!", e});
            throw this.createCameraException(e);
        }
        this.removeRepeatingRequestBuilderSurfaces();
        LOG.i("onStopPreview:", "Returning.");
        return Tasks.forResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopBind() {
        LOG.i("onStopBind:", "About to clean up.");
        this.mFrameProcessingSurface = null;
        this.mPreviewStreamSurface = null;
        this.mPreviewStreamSize = null;
        this.mCaptureSize = null;
        this.mFrameProcessingSize = null;
        if (this.mFrameProcessingReader != null) {
            Object object = this.mFrameProcessingImageLock;
            synchronized (object) {
                this.mFrameProcessingReader.close();
            }
            this.mFrameProcessingReader = null;
        }
        if (this.mPictureReader != null) {
            this.mPictureReader.close();
            this.mPictureReader = null;
        }
        this.mSession.close();
        this.mSession = null;
        LOG.i("onStopBind:", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    @NonNull
    protected Task<Void> onStopEngine() {
        try {
            LOG.i("onStopEngine:", "Clean up.", "Releasing camera.");
            this.mCamera.close();
            LOG.i("onStopEngine:", "Clean up.", "Released camera.");
        }
        catch (Exception e) {
            LOG.w("onStopEngine:", "Clean up.", "Exception while releasing camera.", e);
        }
        this.mCamera = null;
        LOG.i("onStopEngine:", "Aborting actions.");
        for (Action action : this.mActions) {
            action.abort(this);
        }
        this.mCameraCharacteristics = null;
        this.mCameraOptions = null;
        this.mVideoRecorder = null;
        this.mRepeatingRequestBuilder = null;
        LOG.w("onStopEngine:", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @EngineThread
    protected void onTakePictureSnapshot(final @NonNull PictureResult.Stub stub, final @NonNull AspectRatio outputRatio, boolean doMetering) {
        if (doMetering) {
            LOG.i("onTakePictureSnapshot:", "doMetering is true. Delaying.");
            BaseAction action = Actions.timeout(2500L, this.createMeterAction(null));
            action.addCallback(new CompletionCallback(){

                @Override
                protected void onActionCompleted(@NonNull Action action) {
                    Camera2Engine.this.onTakePictureSnapshot(stub, outputRatio, false);
                }
            });
            action.start(this);
        } else {
            LOG.i("onTakePictureSnapshot:", "doMetering is false. Performing.");
            if (!(this.mPreview instanceof GlCameraPreview)) {
                throw new RuntimeException("takePictureSnapshot with Camera2 is only supported with Preview.GL_SURFACE");
            }
            stub.size = this.getUncroppedSnapshotSize(Reference.OUTPUT);
            stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
            this.mPictureRecorder = new Snapshot2PictureRecorder(stub, this, (GlCameraPreview)this.mPreview, outputRatio);
            this.mPictureRecorder.take();
        }
    }

    @Override
    @EngineThread
    protected void onTakePicture(final @NonNull PictureResult.Stub stub, boolean doMetering) {
        if (doMetering) {
            LOG.i("onTakePicture:", "doMetering is true. Delaying.");
            BaseAction action = Actions.timeout(2500L, this.createMeterAction(null));
            action.addCallback(new CompletionCallback(){

                @Override
                protected void onActionCompleted(@NonNull Action action) {
                    Camera2Engine.this.onTakePicture(stub, false);
                }
            });
            action.start(this);
        } else {
            LOG.i("onTakePicture:", "doMetering is false. Performing.");
            stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
            stub.size = this.getPictureSize(Reference.OUTPUT);
            try {
                CaptureRequest.Builder builder = this.mCamera.createCaptureRequest(2);
                this.applyAllParameters(builder, this.mRepeatingRequestBuilder);
                this.mPictureRecorder = new Full2PictureRecorder(stub, this, builder, this.mPictureReader);
                this.mPictureRecorder.take();
            }
            catch (CameraAccessException e) {
                throw this.createCameraException(e);
            }
        }
    }

    @Override
    public void onPictureResult(@Nullable PictureResult.Stub result, @Nullable Exception error) {
        boolean unlock;
        boolean fullPicture = this.mPictureRecorder instanceof Full2PictureRecorder;
        super.onPictureResult(result, error);
        if (fullPicture) {
            // empty if block
        }
        boolean bl = unlock = fullPicture && this.getPictureMetering() || !fullPicture && this.getPictureSnapshotMetering();
        if (unlock) {
            this.unlockAndResetMetering();
        }
    }

    @Override
    @EngineThread
    protected void onTakeVideo(@NonNull VideoResult.Stub stub) {
        LOG.i("onTakeVideo", "called.");
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        stub.size = this.getAngles().flip(Reference.SENSOR, Reference.OUTPUT) ? this.mCaptureSize.flip() : this.mCaptureSize;
        LOG.w("onTakeVideo", "calling restartBind.");
        this.mFullVideoPendingStub = stub;
        this.restartBind();
    }

    private void doTakeVideo(@NonNull VideoResult.Stub stub) {
        if (!(this.mVideoRecorder instanceof Full2VideoRecorder)) {
            throw new IllegalStateException("doTakeVideo called, but video recorder is not a Full2VideoRecorder! " + this.mVideoRecorder);
        }
        Full2VideoRecorder recorder = (Full2VideoRecorder)this.mVideoRecorder;
        try {
            this.createRepeatingRequestBuilder(3);
            this.addRepeatingRequestBuilderSurfaces(recorder.getInputSurface());
            this.applyRepeatingRequestBuilder(true, 3);
            this.mVideoRecorder.start(stub);
        }
        catch (CameraAccessException e) {
            this.onVideoResult(null, (Exception)((Object)e));
            throw this.createCameraException(e);
        }
        catch (CameraException e) {
            this.onVideoResult(null, e);
            throw e;
        }
    }

    @Override
    @EngineThread
    protected void onTakeVideoSnapshot(@NonNull VideoResult.Stub stub, @NonNull AspectRatio outputRatio) {
        if (!(this.mPreview instanceof GlCameraPreview)) {
            throw new IllegalStateException("Video snapshots are only supported with GL_SURFACE.");
        }
        GlCameraPreview glPreview = (GlCameraPreview)this.mPreview;
        com.otaliastudios.cameraview.size.Size outputSize = this.getUncroppedSnapshotSize(Reference.OUTPUT);
        if (outputSize == null) {
            throw new IllegalStateException("outputSize should not be null.");
        }
        Rect outputCrop = CropHelper.computeCrop(outputSize, outputRatio);
        stub.size = outputSize = new com.otaliastudios.cameraview.size.Size(outputCrop.width(), outputCrop.height());
        stub.rotation = this.getAngles().offset(Reference.BASE, Reference.OUTPUT, Axis.ABSOLUTE);
        stub.videoFrameRate = Math.round(this.mPreviewFrameRate);
        LOG.i("onTakeVideoSnapshot", "rotation:", stub.rotation, "size:", stub.size);
        int overlayRotation = this.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
        this.mVideoRecorder = new SnapshotVideoRecorder(this, glPreview, this.getOverlay(), overlayRotation);
        this.mVideoRecorder.start(stub);
    }

    @Override
    public void onVideoRecordingEnd() {
        boolean needsIssue549Workaround;
        super.onVideoRecordingEnd();
        boolean bl = needsIssue549Workaround = this.mVideoRecorder instanceof Full2VideoRecorder && this.readCharacteristic(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, -1) == 2;
        if (needsIssue549Workaround) {
            this.maybeRestorePreviewTemplateAfterVideo();
        }
    }

    @Override
    public void onVideoResult(@Nullable VideoResult.Stub result, @Nullable Exception exception) {
        super.onVideoResult(result, exception);
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getBindState() < 2) {
                    return;
                }
                Camera2Engine.this.maybeRestorePreviewTemplateAfterVideo();
            }
        });
    }

    @EngineThread
    private void maybeRestorePreviewTemplateAfterVideo() {
        int template = (Integer)this.mRepeatingRequestBuilder.build().getTag();
        if (template != 1) {
            try {
                this.createRepeatingRequestBuilder(1);
                this.addRepeatingRequestBuilderSurfaces(new Surface[0]);
                this.applyRepeatingRequestBuilder();
            }
            catch (CameraAccessException e) {
                throw this.createCameraException(e);
            }
        }
    }

    private void applyAllParameters(@NonNull CaptureRequest.Builder builder, @Nullable CaptureRequest.Builder oldBuilder) {
        LOG.i("applyAllParameters:", "called for tag", builder.build().getTag());
        builder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        this.applyDefaultFocus(builder);
        this.applyFlash(builder, Flash.OFF);
        this.applyLocation(builder, null);
        this.applyWhiteBalance(builder, WhiteBalance.AUTO);
        this.applyHdr(builder, Hdr.OFF);
        this.applyZoom(builder, 0.0f);
        this.applyExposureCorrection(builder, 0.0f);
        this.applyPreviewFrameRate(builder, 0.0f);
        if (oldBuilder != null) {
            builder.set(CaptureRequest.CONTROL_AF_REGIONS, oldBuilder.get(CaptureRequest.CONTROL_AF_REGIONS));
            builder.set(CaptureRequest.CONTROL_AE_REGIONS, oldBuilder.get(CaptureRequest.CONTROL_AE_REGIONS));
            builder.set(CaptureRequest.CONTROL_AWB_REGIONS, oldBuilder.get(CaptureRequest.CONTROL_AWB_REGIONS));
            builder.set(CaptureRequest.CONTROL_AF_MODE, oldBuilder.get(CaptureRequest.CONTROL_AF_MODE));
        }
    }

    protected void applyDefaultFocus(@NonNull CaptureRequest.Builder builder) {
        int[] modesArray = this.readCharacteristic(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, new int[0]);
        ArrayList<Integer> modes = new ArrayList<Integer>();
        for (int mode : modesArray) {
            modes.add(mode);
        }
        if (this.getMode() == Mode.VIDEO && modes.contains(3)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            return;
        }
        if (modes.contains(4)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            return;
        }
        if (modes.contains(1)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            return;
        }
        if (modes.contains(0)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(0.0f));
            return;
        }
    }

    protected void applyFocusForMetering(@NonNull CaptureRequest.Builder builder) {
        int[] modesArray = this.readCharacteristic(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, new int[0]);
        ArrayList<Integer> modes = new ArrayList<Integer>();
        for (int mode : modesArray) {
            modes.add(mode);
        }
        if (modes.contains(1)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            return;
        }
        if (this.getMode() == Mode.VIDEO && modes.contains(3)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            return;
        }
        if (modes.contains(4)) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            return;
        }
    }

    @Override
    public void setFlash(final @NonNull Flash flash) {
        final Flash old = this.mFlash;
        this.mFlash = flash;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2) {
                    boolean needsWorkaround;
                    boolean shouldApply = Camera2Engine.this.applyFlash(Camera2Engine.this.mRepeatingRequestBuilder, old);
                    boolean bl = needsWorkaround = Camera2Engine.this.getPreviewState() == 2;
                    if (needsWorkaround) {
                        Camera2Engine.this.mFlash = Flash.OFF;
                        Camera2Engine.this.applyFlash(Camera2Engine.this.mRepeatingRequestBuilder, old);
                        try {
                            Camera2Engine.this.mSession.capture(Camera2Engine.this.mRepeatingRequestBuilder.build(), null, null);
                        }
                        catch (CameraAccessException e) {
                            throw Camera2Engine.this.createCameraException(e);
                        }
                        Camera2Engine.this.mFlash = flash;
                        Camera2Engine.this.applyFlash(Camera2Engine.this.mRepeatingRequestBuilder, old);
                        Camera2Engine.this.applyRepeatingRequestBuilder();
                    } else if (shouldApply) {
                        Camera2Engine.this.applyRepeatingRequestBuilder();
                    }
                }
                Camera2Engine.this.mFlashOp.end(null);
            }
        });
    }

    protected boolean applyFlash(@NonNull CaptureRequest.Builder builder, @NonNull Flash oldFlash) {
        if (this.mCameraOptions.supports(this.mFlash)) {
            int[] availableAeModesArray = this.readCharacteristic(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES, new int[0]);
            ArrayList<Integer> availableAeModes = new ArrayList<Integer>();
            for (int mode : availableAeModesArray) {
                availableAeModes.add(mode);
            }
            List<Pair<Integer, Integer>> pairs = this.mMapper.mapFlash(this.mFlash);
            for (Pair<Integer, Integer> pair : pairs) {
                if (!availableAeModes.contains(pair.first)) continue;
                LOG.i("applyFlash: setting CONTROL_AE_MODE to", pair.first);
                LOG.i("applyFlash: setting FLASH_MODE to", pair.second);
                builder.set(CaptureRequest.CONTROL_AE_MODE, pair.first);
                builder.set(CaptureRequest.FLASH_MODE, pair.second);
                return true;
            }
        }
        this.mFlash = oldFlash;
        return false;
    }

    @Override
    public void setLocation(@Nullable Location location) {
        final Location old = this.mLocation;
        this.mLocation = location;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2 && Camera2Engine.this.applyLocation(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
                Camera2Engine.this.mLocationOp.end(null);
            }
        });
    }

    protected boolean applyLocation(@NonNull CaptureRequest.Builder builder, @Nullable Location oldLocation) {
        if (this.mLocation != null) {
            builder.set(CaptureRequest.JPEG_GPS_LOCATION, (Object)this.mLocation);
        }
        return true;
    }

    @Override
    public void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        final WhiteBalance old = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2 && Camera2Engine.this.applyWhiteBalance(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
                Camera2Engine.this.mWhiteBalanceOp.end(null);
            }
        });
    }

    protected boolean applyWhiteBalance(@NonNull CaptureRequest.Builder builder, @NonNull WhiteBalance oldWhiteBalance) {
        if (this.mCameraOptions.supports(this.mWhiteBalance)) {
            int whiteBalance = this.mMapper.mapWhiteBalance(this.mWhiteBalance);
            builder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)whiteBalance);
            return true;
        }
        this.mWhiteBalance = oldWhiteBalance;
        return false;
    }

    @Override
    public void setHdr(@NonNull Hdr hdr) {
        final Hdr old = this.mHdr;
        this.mHdr = hdr;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2 && Camera2Engine.this.applyHdr(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
                Camera2Engine.this.mHdrOp.end(null);
            }
        });
    }

    protected boolean applyHdr(@NonNull CaptureRequest.Builder builder, @NonNull Hdr oldHdr) {
        if (this.mCameraOptions.supports(this.mHdr)) {
            int hdr = this.mMapper.mapHdr(this.mHdr);
            builder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)hdr);
            return true;
        }
        this.mHdr = oldHdr;
        return false;
    }

    @Override
    public void setZoom(final float zoom, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mZoomValue;
        this.mZoomValue = zoom;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2 && Camera2Engine.this.applyZoom(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                    if (notify) {
                        Camera2Engine.this.mCallback.dispatchOnZoomChanged(zoom, points);
                    }
                }
                Camera2Engine.this.mZoomOp.end(null);
            }
        });
    }

    protected boolean applyZoom(@NonNull CaptureRequest.Builder builder, float oldZoom) {
        if (this.mCameraOptions.isZoomSupported()) {
            float maxZoom = this.readCharacteristic(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM, Float.valueOf(1.0f)).floatValue();
            float calculatedZoom = this.mZoomValue * (maxZoom - 1.0f) + 1.0f;
            Rect newRect = this.getZoomRect(calculatedZoom, maxZoom);
            builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)newRect);
            return true;
        }
        this.mZoomValue = oldZoom;
        return false;
    }

    @NonNull
    private Rect getZoomRect(float zoomLevel, float maxDigitalZoom) {
        Rect activeRect = this.readCharacteristic(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE, new Rect());
        int minW = (int)((float)activeRect.width() / maxDigitalZoom);
        int minH = (int)((float)activeRect.height() / maxDigitalZoom);
        int difW = activeRect.width() - minW;
        int difH = activeRect.height() - minH;
        int cropW = (int)((float)difW * (zoomLevel - 1.0f) / (maxDigitalZoom - 1.0f) / 2.0f);
        int cropH = (int)((float)difH * (zoomLevel - 1.0f) / (maxDigitalZoom - 1.0f) / 2.0f);
        return new Rect(cropW, cropH, activeRect.width() - cropW, activeRect.height() - cropH);
    }

    @Override
    public void setExposureCorrection(final float EVvalue, final @NonNull float[] bounds, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mExposureCorrectionValue;
        this.mExposureCorrectionValue = EVvalue;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2 && Camera2Engine.this.applyExposureCorrection(Camera2Engine.this.mRepeatingRequestBuilder, old)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                    if (notify) {
                        Camera2Engine.this.mCallback.dispatchOnExposureCorrectionChanged(EVvalue, bounds, points);
                    }
                }
                Camera2Engine.this.mExposureCorrectionOp.end(null);
            }
        });
    }

    protected boolean applyExposureCorrection(@NonNull CaptureRequest.Builder builder, float oldEVvalue) {
        if (this.mCameraOptions.isExposureCorrectionSupported()) {
            Rational exposureCorrectionStep = this.readCharacteristic(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP, new Rational(1, 1));
            int exposureCorrectionSteps = Math.round(this.mExposureCorrectionValue * exposureCorrectionStep.floatValue());
            builder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)exposureCorrectionSteps);
            return true;
        }
        this.mExposureCorrectionValue = oldEVvalue;
        return false;
    }

    @Override
    public void setPlaySounds(boolean playSounds) {
        this.mPlaySounds = playSounds;
        this.mPlaySoundsOp.end(null);
    }

    @Override
    public void setPreviewFrameRate(float previewFrameRate) {
        final float oldPreviewFrameRate = this.mPreviewFrameRate;
        this.mPreviewFrameRate = previewFrameRate;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera2Engine.this.getEngineState() == 2 && Camera2Engine.this.applyPreviewFrameRate(Camera2Engine.this.mRepeatingRequestBuilder, oldPreviewFrameRate)) {
                    Camera2Engine.this.applyRepeatingRequestBuilder();
                }
                Camera2Engine.this.mPreviewFrameRateOp.end(null);
            }
        });
    }

    protected boolean applyPreviewFrameRate(@NonNull CaptureRequest.Builder builder, float oldPreviewFrameRate) {
        Range[] fallback = new Range[]{};
        Range[] fpsRanges = this.readCharacteristic(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES, fallback);
        if (this.mPreviewFrameRate == 0.0f) {
            for (Range fpsRange : fpsRanges) {
                if (!fpsRange.contains((Comparable)Integer.valueOf(30)) && !fpsRange.contains((Comparable)Integer.valueOf(24))) continue;
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)fpsRange);
                return true;
            }
        } else {
            this.mPreviewFrameRate = Math.min(this.mPreviewFrameRate, this.mCameraOptions.getPreviewFrameRateMaxValue());
            this.mPreviewFrameRate = Math.max(this.mPreviewFrameRate, this.mCameraOptions.getPreviewFrameRateMinValue());
            for (Range fpsRange : fpsRanges) {
                if (!fpsRange.contains((Comparable)Integer.valueOf(Math.round(this.mPreviewFrameRate)))) continue;
                builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)fpsRange);
                return true;
            }
        }
        this.mPreviewFrameRate = oldPreviewFrameRate;
        return false;
    }

    @Override
    @NonNull
    protected FrameManager instantiateFrameManager() {
        return new FrameManager(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onImageAvailable(ImageReader reader) {
        byte[] data = this.getFrameManager().getBuffer();
        if (data == null) {
            LOG.w("onImageAvailable", "no byte buffer!");
            return;
        }
        LOG.v("onImageAvailable", "trying to acquire Image.");
        Image image = null;
        try {
            image = reader.acquireLatestImage();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (image == null) {
            LOG.w("onImageAvailable", "we have a byte buffer but no Image!");
            this.getFrameManager().onBufferUnused(data);
            return;
        }
        LOG.v("onImageAvailable", "we have both a byte buffer and an Image.");
        try {
            Object object = this.mFrameProcessingImageLock;
            synchronized (object) {
                ImageHelper.convertToNV21(image, data);
            }
        }
        catch (Exception e) {
            LOG.w("onImageAvailable", "error while converting.");
            this.getFrameManager().onBufferUnused(data);
            image.close();
            return;
        }
        image.close();
        if (this.getPreviewState() == 2) {
            Frame frame = this.getFrameManager().getFrame(data, System.currentTimeMillis(), this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR));
            this.mCallback.dispatchFrame(frame);
        } else {
            this.getFrameManager().onBufferUnused(data);
        }
    }

    @Override
    public void setHasFrameProcessors(final boolean hasFrameProcessors) {
        LOG.i("setHasFrameProcessors", "changing to", hasFrameProcessors, "posting.");
        Camera2Engine.super.setHasFrameProcessors(hasFrameProcessors);
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.i("setHasFrameProcessors", "changing to", hasFrameProcessors, "executing. BindState:", Camera2Engine.this.getBindState(), "PreviewState:", Camera2Engine.this.getPreviewState());
                if (Camera2Engine.this.getBindState() == 0) {
                    LOG.i("setHasFrameProcessors", "not bound so won't restart.");
                } else if (Camera2Engine.this.getPreviewState() == 2) {
                    LOG.i("setHasFrameProcessors", "bound with preview.", "Calling restartBind().");
                    Camera2Engine.this.restartBind();
                } else {
                    throw new IllegalStateException("Added/removed a FrameProcessor at illegal time. These operations should be done before opening the camera, or before closing it - NOT when it just opened, for example during the onCameraOpened() callback.");
                }
            }
        });
    }

    @Override
    public void startAutoFocus(final @Nullable Gesture gesture, final @NonNull PointF point) {
        LOG.i(new Object[]{"startAutoFocus", "dispatching. Gesture:", gesture});
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.i("startAutoFocus", "executing. Preview state:", Camera2Engine.this.getPreviewState());
                if (Camera2Engine.this.getPreviewState() < 2) {
                    return;
                }
                if (!Camera2Engine.this.mCameraOptions.isAutoFocusSupported()) {
                    return;
                }
                Camera2Engine.this.mCallback.dispatchOnFocusStart(gesture, point);
                final MeterAction action = Camera2Engine.this.createMeterAction(point);
                BaseAction wrapper = Actions.timeout(2500L, action);
                wrapper.start(Camera2Engine.this);
                wrapper.addCallback(new CompletionCallback(){

                    @Override
                    protected void onActionCompleted(@NonNull Action a) {
                        Camera2Engine.this.mCallback.dispatchOnFocusEnd(gesture, action.isSuccessful(), point);
                        Camera2Engine.this.mHandler.remove(Camera2Engine.this.mUnlockAndResetMeteringRunnable);
                        if (Camera2Engine.this.shouldResetAutoFocus()) {
                            Camera2Engine.this.mHandler.post(Camera2Engine.this.getAutoFocusResetDelay(), Camera2Engine.this.mUnlockAndResetMeteringRunnable);
                        }
                    }
                });
            }
        });
    }

    @NonNull
    private MeterAction createMeterAction(@Nullable PointF point) {
        if (this.mMeterAction != null) {
            this.mMeterAction.abort(this);
        }
        this.applyFocusForMetering(this.mRepeatingRequestBuilder);
        this.mMeterAction = new MeterAction(this, point, point == null);
        return this.mMeterAction;
    }

    private void unlockAndResetMetering() {
        if (this.getEngineState() == 2) {
            Actions.sequence(new BaseAction(){

                @Override
                protected void onStart(@NonNull ActionHolder holder) {
                    super.onStart(holder);
                    Camera2Engine.this.applyDefaultFocus(holder.getBuilder(this));
                    holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                    holder.getBuilder(this).set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
                    holder.applyBuilder(this);
                    this.setState(Integer.MAX_VALUE);
                }
            }, new MeterResetAction()).start(this);
        }
    }

    @Override
    public void addAction(@NonNull Action action) {
        if (!this.mActions.contains(action)) {
            this.mActions.add(action);
        }
    }

    @Override
    public void removeAction(@NonNull Action action) {
        this.mActions.remove(action);
    }

    @Override
    @NonNull
    public CameraCharacteristics getCharacteristics(@NonNull Action action) {
        return this.mCameraCharacteristics;
    }

    @Override
    @Nullable
    public TotalCaptureResult getLastResult(@NonNull Action action) {
        return this.mLastRepeatingResult;
    }

    @Override
    @NonNull
    public CaptureRequest.Builder getBuilder(@NonNull Action action) {
        return this.mRepeatingRequestBuilder;
    }

    @Override
    public void applyBuilder(@NonNull Action source) {
        this.applyRepeatingRequestBuilder();
    }

    @Override
    public void applyBuilder(@NonNull Action source, @NonNull CaptureRequest.Builder builder) throws CameraAccessException {
        this.mSession.capture(builder.build(), this.mRepeatingRequestCallback, null);
    }
}

