/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.size.Size;
import java.io.File;

public class VideoResult {
    public static final int REASON_USER = 0;
    public static final int REASON_MAX_SIZE_REACHED = 1;
    public static final int REASON_MAX_DURATION_REACHED = 2;
    private final boolean isSnapshot;
    private final Location location;
    private final int rotation;
    private final Size size;
    private final File file;
    private final Facing facing;
    private final VideoCodec videoCodec;
    private final Audio audio;
    private final long maxSize;
    private final int maxDuration;
    private final int endReason;
    private final int videoBitRate;
    private final int videoFrameRate;
    private final int audioBitRate;

    VideoResult(@NonNull Stub builder) {
        this.isSnapshot = builder.isSnapshot;
        this.location = builder.location;
        this.rotation = builder.rotation;
        this.size = builder.size;
        this.file = builder.file;
        this.facing = builder.facing;
        this.videoCodec = builder.videoCodec;
        this.audio = builder.audio;
        this.maxSize = builder.maxSize;
        this.maxDuration = builder.maxDuration;
        this.endReason = builder.endReason;
        this.videoBitRate = builder.videoBitRate;
        this.videoFrameRate = builder.videoFrameRate;
        this.audioBitRate = builder.audioBitRate;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NonNull
    public Size getSize() {
        return this.size;
    }

    @NonNull
    public File getFile() {
        return this.file;
    }

    @NonNull
    public Facing getFacing() {
        return this.facing;
    }

    @NonNull
    public VideoCodec getVideoCodec() {
        return this.videoCodec;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    @NonNull
    public Audio getAudio() {
        return this.audio;
    }

    public int getTerminationReason() {
        return this.endReason;
    }

    public int getVideoBitRate() {
        return this.videoBitRate;
    }

    public int getVideoFrameRate() {
        return this.videoFrameRate;
    }

    public int getAudioBitRate() {
        return this.audioBitRate;
    }

    public static class Stub {
        public boolean isSnapshot;
        public Location location;
        public int rotation;
        public Size size;
        public File file;
        public Facing facing;
        public VideoCodec videoCodec;
        public Audio audio;
        public long maxSize;
        public int maxDuration;
        public int endReason;
        public int videoBitRate;
        public int videoFrameRate;
        public int audioBitRate;

        Stub() {
        }
    }
}

