/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.hardware.Camera;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.util.Range;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.Control;
import com.otaliastudios.cameraview.controls.Engine;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Grid;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.Preview;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.mappers.Camera1Mapper;
import com.otaliastudios.cameraview.engine.mappers.Camera2Mapper;
import com.otaliastudios.cameraview.gesture.GestureAction;
import com.otaliastudios.cameraview.internal.utils.CamcorderProfiles;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CameraOptions {
    private Set<WhiteBalance> supportedWhiteBalance = new HashSet<WhiteBalance>(5);
    private Set<Facing> supportedFacing = new HashSet<Facing>(2);
    private Set<Flash> supportedFlash = new HashSet<Flash>(4);
    private Set<Hdr> supportedHdr = new HashSet<Hdr>(2);
    private Set<Size> supportedPictureSizes = new HashSet<Size>(15);
    private Set<Size> supportedVideoSizes = new HashSet<Size>(5);
    private Set<AspectRatio> supportedPictureAspectRatio = new HashSet<AspectRatio>(4);
    private Set<AspectRatio> supportedVideoAspectRatio = new HashSet<AspectRatio>(3);
    private boolean zoomSupported;
    private boolean exposureCorrectionSupported;
    private float exposureCorrectionMinValue;
    private float exposureCorrectionMaxValue;
    private boolean autoFocusSupported;
    private float previewFrameRateMinValue;
    private float previewFrameRateMaxValue;

    public CameraOptions(@NonNull Camera.Parameters params, int cameraId, boolean flipSizes) {
        Object value;
        Camera1Mapper mapper = Camera1Mapper.get();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            value = mapper.unmapFacing(cameraInfo.facing);
            if (value == null) continue;
            this.supportedFacing.add((Facing)value);
        }
        List strings = params.getSupportedWhiteBalance();
        if (strings != null) {
            for (String string : strings) {
                value = mapper.unmapWhiteBalance(string);
                if (value == null) continue;
                this.supportedWhiteBalance.add((WhiteBalance)value);
            }
        }
        this.supportedFlash.add(Flash.OFF);
        strings = params.getSupportedFlashModes();
        if (strings != null) {
            for (String string : strings) {
                value = mapper.unmapFlash(string);
                if (value == null) continue;
                this.supportedFlash.add((Flash)value);
            }
        }
        this.supportedHdr.add(Hdr.OFF);
        strings = params.getSupportedSceneModes();
        if (strings != null) {
            for (String string : strings) {
                value = mapper.unmapHdr(string);
                if (value == null) continue;
                this.supportedHdr.add((Hdr)value);
            }
        }
        this.zoomSupported = params.isZoomSupported();
        this.autoFocusSupported = params.getSupportedFocusModes().contains("auto");
        float step = params.getExposureCompensationStep();
        this.exposureCorrectionMinValue = (float)params.getMinExposureCompensation() * step;
        this.exposureCorrectionMaxValue = (float)params.getMaxExposureCompensation() * step;
        this.exposureCorrectionSupported = params.getMinExposureCompensation() != 0 || params.getMaxExposureCompensation() != 0;
        List sizes = params.getSupportedPictureSizes();
        for (Camera.Size size : sizes) {
            int width = flipSizes ? size.height : size.width;
            int height = flipSizes ? size.width : size.height;
            this.supportedPictureSizes.add(new Size(width, height));
            this.supportedPictureAspectRatio.add(AspectRatio.of(width, height));
        }
        CamcorderProfile profile = CamcorderProfiles.get(cameraId, new Size(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Size videoMaxSize = new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        List vsizes = params.getSupportedVideoSizes();
        if (vsizes != null) {
            for (Camera.Size size : vsizes) {
                if (size.width > videoMaxSize.getWidth() || size.height > videoMaxSize.getHeight()) continue;
                int width = flipSizes ? size.height : size.width;
                int height = flipSizes ? size.width : size.height;
                this.supportedVideoSizes.add(new Size(width, height));
                this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
            }
        } else {
            List fallback = params.getSupportedPreviewSizes();
            for (Camera.Size size : fallback) {
                if (size.width > videoMaxSize.getWidth() || size.height > videoMaxSize.getHeight()) continue;
                int width = flipSizes ? size.height : size.width;
                int height = flipSizes ? size.width : size.height;
                this.supportedVideoSizes.add(new Size(width, height));
                this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
            }
        }
        this.previewFrameRateMinValue = Float.MAX_VALUE;
        this.previewFrameRateMaxValue = -3.4028235E38f;
        List fpsRanges = params.getSupportedPreviewFpsRange();
        for (int[] fpsRange : fpsRanges) {
            float lower = (float)fpsRange[0] / 1000.0f;
            float upper = (float)fpsRange[1] / 1000.0f;
            this.previewFrameRateMinValue = Math.min(this.previewFrameRateMinValue, lower);
            this.previewFrameRateMaxValue = Math.max(this.previewFrameRateMaxValue, upper);
        }
    }

    @RequiresApi(value=21)
    public CameraOptions(@NonNull CameraManager manager, @NonNull String cameraId, boolean flipSizes) throws CameraAccessException {
        android.util.Size[] vsizes;
        android.util.Size[] psizes;
        int[] sceneModes;
        int[] awbModes;
        Camera2Mapper mapper = Camera2Mapper.get();
        CameraCharacteristics cameraCharacteristics = manager.getCameraCharacteristics(cameraId);
        for (String cameraId1 : manager.getCameraIdList()) {
            Facing value;
            CameraCharacteristics cameraCharacteristics1 = manager.getCameraCharacteristics(cameraId1);
            Integer cameraFacing = (Integer)cameraCharacteristics1.get(CameraCharacteristics.LENS_FACING);
            if (cameraFacing == null || (value = mapper.unmapFacing(cameraFacing)) == null) continue;
            this.supportedFacing.add(value);
        }
        for (int awbMode : awbModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES)) {
            WhiteBalance value = mapper.unmapWhiteBalance(awbMode);
            if (value == null) continue;
            this.supportedWhiteBalance.add(value);
        }
        this.supportedFlash.add(Flash.OFF);
        Boolean hasFlash = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (hasFlash != null && hasFlash.booleanValue()) {
            int[] aeModes;
            for (int aeMode : aeModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES)) {
                Set<Flash> flashes = mapper.unmapFlash(aeMode);
                this.supportedFlash.addAll(flashes);
            }
        }
        this.supportedHdr.add(Hdr.OFF);
        for (int sceneMode : sceneModes = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES)) {
            Hdr value = mapper.unmapHdr(sceneMode);
            if (value == null) continue;
            this.supportedHdr.add(value);
        }
        Float maxZoom = (Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        if (maxZoom != null) {
            this.zoomSupported = maxZoom.floatValue() > 1.0f;
        }
        Integer afRegions = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        Integer aeRegions = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        Integer awbRegions = (Integer)cameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
        this.autoFocusSupported = afRegions != null && afRegions > 0 || aeRegions != null && aeRegions > 0 || awbRegions != null && awbRegions > 0;
        Range exposureRange = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        Rational exposureStep = (Rational)cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        if (exposureRange != null && exposureStep != null && exposureStep.floatValue() != 0.0f) {
            this.exposureCorrectionMinValue = (float)((Integer)exposureRange.getLower()).intValue() / exposureStep.floatValue();
            this.exposureCorrectionMaxValue = (float)((Integer)exposureRange.getUpper()).intValue() / exposureStep.floatValue();
        }
        this.exposureCorrectionSupported = this.exposureCorrectionMinValue != 0.0f && this.exposureCorrectionMaxValue != 0.0f;
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (streamMap == null) {
            throw new RuntimeException("StreamConfigurationMap is null. Should not happen.");
        }
        for (android.util.Size size : psizes = streamMap.getOutputSizes(256)) {
            int width = flipSizes ? size.getHeight() : size.getWidth();
            int height = flipSizes ? size.getWidth() : size.getHeight();
            this.supportedPictureSizes.add(new Size(width, height));
            this.supportedPictureAspectRatio.add(AspectRatio.of(width, height));
        }
        CamcorderProfile profile = CamcorderProfiles.get(cameraId, new Size(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Size videoMaxSize = new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        for (android.util.Size size : vsizes = streamMap.getOutputSizes(MediaRecorder.class)) {
            if (size.getWidth() > videoMaxSize.getWidth() || size.getHeight() > videoMaxSize.getHeight()) continue;
            int width = flipSizes ? size.getHeight() : size.getWidth();
            int height = flipSizes ? size.getWidth() : size.getHeight();
            this.supportedVideoSizes.add(new Size(width, height));
            this.supportedVideoAspectRatio.add(AspectRatio.of(width, height));
        }
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (rangeArray != null) {
            this.previewFrameRateMinValue = Float.MAX_VALUE;
            this.previewFrameRateMaxValue = -3.4028235E38f;
            for (Range fpsRange : rangeArray) {
                this.previewFrameRateMinValue = Math.min(this.previewFrameRateMinValue, (float)((Integer)fpsRange.getLower()).intValue());
                this.previewFrameRateMaxValue = Math.max(this.previewFrameRateMaxValue, (float)((Integer)fpsRange.getUpper()).intValue());
            }
        } else {
            this.previewFrameRateMinValue = 0.0f;
            this.previewFrameRateMaxValue = 0.0f;
        }
    }

    public boolean supports(@NonNull Control control) {
        return this.getSupportedControls(control.getClass()).contains(control);
    }

    public boolean supports(@NonNull GestureAction action) {
        switch (action) {
            case AUTO_FOCUS: {
                return this.isAutoFocusSupported();
            }
            case TAKE_PICTURE: 
            case FILTER_CONTROL_1: 
            case FILTER_CONTROL_2: 
            case NONE: {
                return true;
            }
            case ZOOM: {
                return this.isZoomSupported();
            }
            case EXPOSURE_CORRECTION: {
                return this.isExposureCorrectionSupported();
            }
        }
        return false;
    }

    @NonNull
    public <T extends Control> Collection<T> getSupportedControls(@NonNull Class<T> controlClass) {
        if (controlClass.equals(Audio.class)) {
            return Arrays.asList(Audio.values());
        }
        if (controlClass.equals(Facing.class)) {
            return this.getSupportedFacing();
        }
        if (controlClass.equals(Flash.class)) {
            return this.getSupportedFlash();
        }
        if (controlClass.equals(Grid.class)) {
            return Arrays.asList(Grid.values());
        }
        if (controlClass.equals(Hdr.class)) {
            return this.getSupportedHdr();
        }
        if (controlClass.equals(Mode.class)) {
            return Arrays.asList(Mode.values());
        }
        if (controlClass.equals(VideoCodec.class)) {
            return Arrays.asList(VideoCodec.values());
        }
        if (controlClass.equals(WhiteBalance.class)) {
            return this.getSupportedWhiteBalance();
        }
        if (controlClass.equals(Engine.class)) {
            return Arrays.asList(Engine.values());
        }
        if (controlClass.equals(Preview.class)) {
            return Arrays.asList(Preview.values());
        }
        return Collections.emptyList();
    }

    @NonNull
    public Collection<Size> getSupportedPictureSizes() {
        return Collections.unmodifiableSet(this.supportedPictureSizes);
    }

    @NonNull
    public Collection<AspectRatio> getSupportedPictureAspectRatios() {
        return Collections.unmodifiableSet(this.supportedPictureAspectRatio);
    }

    @NonNull
    public Collection<Size> getSupportedVideoSizes() {
        return Collections.unmodifiableSet(this.supportedVideoSizes);
    }

    @NonNull
    public Collection<AspectRatio> getSupportedVideoAspectRatios() {
        return Collections.unmodifiableSet(this.supportedVideoAspectRatio);
    }

    @NonNull
    public Collection<Facing> getSupportedFacing() {
        return Collections.unmodifiableSet(this.supportedFacing);
    }

    @NonNull
    public Collection<Flash> getSupportedFlash() {
        return Collections.unmodifiableSet(this.supportedFlash);
    }

    @NonNull
    public Collection<WhiteBalance> getSupportedWhiteBalance() {
        return Collections.unmodifiableSet(this.supportedWhiteBalance);
    }

    @NonNull
    public Collection<Hdr> getSupportedHdr() {
        return Collections.unmodifiableSet(this.supportedHdr);
    }

    public boolean isZoomSupported() {
        return this.zoomSupported;
    }

    public boolean isAutoFocusSupported() {
        return this.autoFocusSupported;
    }

    public boolean isExposureCorrectionSupported() {
        return this.exposureCorrectionSupported;
    }

    public float getExposureCorrectionMinValue() {
        return this.exposureCorrectionMinValue;
    }

    public float getExposureCorrectionMaxValue() {
        return this.exposureCorrectionMaxValue;
    }

    public float getPreviewFrameRateMinValue() {
        return this.previewFrameRateMinValue;
    }

    public float getPreviewFrameRateMaxValue() {
        return this.previewFrameRateMaxValue;
    }
}

