/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video.encoding;

import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.video.encoding.AudioConfig;
import com.otaliastudios.cameraview.video.encoding.AudioNoise;
import com.otaliastudios.cameraview.video.encoding.AudioTimestamp;
import com.otaliastudios.cameraview.video.encoding.ByteBufferPool;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.InputBuffer;
import com.otaliastudios.cameraview.video.encoding.InputBufferPool;
import com.otaliastudios.cameraview.video.encoding.MediaEncoder;
import com.otaliastudios.cameraview.video.encoding.MediaEncoderEngine;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

@RequiresApi(api=18)
public class AudioMediaEncoder
extends MediaEncoder {
    private static final String TAG = AudioMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final boolean PERFORMANCE_DEBUG = false;
    private static final boolean PERFORMANCE_FILL_GAPS = true;
    private static final int PERFORMANCE_MAX_GAPS = 8;
    private boolean mRequestStop = false;
    private AudioEncodingThread mEncoder;
    private AudioRecordingThread mRecorder;
    private ByteBufferPool mByteBufferPool;
    private final AudioTimestamp mTimestamp;
    private AudioConfig mConfig;
    private InputBufferPool mInputBufferPool = new InputBufferPool();
    private final LinkedBlockingQueue<InputBuffer> mInputBufferQueue = new LinkedBlockingQueue();
    private AudioNoise mAudioNoise;
    private int mDebugSendCount = 0;
    private int mDebugExecuteCount = 0;
    private long mDebugSendAvgDelay = 0L;
    private long mDebugExecuteAvgDelay = 0L;
    private Map<Long, Long> mDebugSendStartMap = new HashMap<Long, Long>();

    public AudioMediaEncoder(@NonNull AudioConfig config) {
        super("AudioEncoder");
        this.mConfig = config.copy();
        this.mTimestamp = new AudioTimestamp(this.mConfig.byteRate());
        this.mEncoder = new AudioEncodingThread();
        this.mRecorder = new AudioRecordingThread();
    }

    @Override
    @EncoderThread
    protected void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthUs) {
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.mConfig.mimeType, (int)this.mConfig.samplingFrequency, (int)this.mConfig.channels);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", this.mConfig.audioFormatChannels());
        audioFormat.setInteger("bitrate", this.mConfig.bitRate);
        try {
            this.mMediaCodec = this.mConfig.encoder != null ? MediaCodec.createByCodecName((String)this.mConfig.encoder) : MediaCodec.createEncoderByType((String)this.mConfig.mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        this.mByteBufferPool = new ByteBufferPool(this.mConfig.frameSize(), this.mConfig.bufferPoolMaxSize());
        this.mAudioNoise = new AudioNoise(this.mConfig);
    }

    @Override
    @EncoderThread
    protected void onStart() {
        this.mRequestStop = false;
        this.mRecorder.start();
        this.mEncoder.start();
    }

    @Override
    @EncoderThread
    protected void onStop() {
        this.mRequestStop = true;
    }

    @Override
    protected void onStopped() {
        super.onStopped();
        this.mRequestStop = false;
        this.mEncoder = null;
        this.mRecorder = null;
        if (this.mByteBufferPool != null) {
            this.mByteBufferPool.clear();
            this.mByteBufferPool = null;
        }
    }

    @Override
    protected int getEncodedBitRate() {
        return this.mConfig.bitRate;
    }

    private void skipFrames(int frames) {
        try {
            Thread.sleep(AudioTimestamp.bytesToMillis(this.mConfig.frameSize() * frames, this.mConfig.byteRate()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class AudioEncodingThread
    extends Thread {
        private AudioEncodingThread() {
            this.setPriority(10);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block0: while (true) {
                if (AudioMediaEncoder.access$900(AudioMediaEncoder.this).isEmpty()) {
                    AudioMediaEncoder.access$600(AudioMediaEncoder.this, 2);
                    continue;
                }
                AudioMediaEncoder.access$400().i(new Object[]{"encoding thread - performing", AudioMediaEncoder.access$900(AudioMediaEncoder.this).size(), "pending operations."});
                while (true) {
                    if ((inputBuffer = (InputBuffer)AudioMediaEncoder.access$900(AudioMediaEncoder.this).peek()) == null) ** break;
                    if (inputBuffer.isEndOfStream) break block0;
                    if (AudioMediaEncoder.this.tryAcquireInputBuffer(inputBuffer)) {
                        this.encode(inputBuffer);
                        continue;
                    }
                    AudioMediaEncoder.access$600(AudioMediaEncoder.this, 1);
                }
                break;
            }
            AudioMediaEncoder.this.acquireInputBuffer(inputBuffer);
            this.encode(inputBuffer);
            AudioMediaEncoder.access$800(AudioMediaEncoder.this).clear();
        }

        private void encode(@NonNull InputBuffer buffer) {
            long executeStart = System.nanoTime() / 1000000L;
            LOG.i("encoding thread - performing pending operation for timestamp:", buffer.timestamp, "- encoding.");
            buffer.data.put(buffer.source);
            AudioMediaEncoder.this.mByteBufferPool.recycle(buffer.source);
            AudioMediaEncoder.this.mInputBufferQueue.remove(buffer);
            AudioMediaEncoder.this.encodeInputBuffer(buffer);
            boolean eos = buffer.isEndOfStream;
            AudioMediaEncoder.this.mInputBufferPool.recycle(buffer);
            LOG.i("encoding thread - performing pending operation for timestamp:", buffer.timestamp, "- draining.");
            AudioMediaEncoder.this.drainOutput(eos);
        }
    }

    private class AudioRecordingThread
    extends Thread {
        private AudioRecord mAudioRecord;
        private ByteBuffer mCurrentBuffer;
        private int mCurrentReadBytes;
        private long mLastTimeUs;
        private long mFirstTimeUs = Long.MIN_VALUE;

        private AudioRecordingThread() {
            int bufferSize;
            this.setPriority(10);
            int n = ((AudioMediaEncoder)AudioMediaEncoder.this).mConfig.samplingFrequency;
            int n2 = AudioMediaEncoder.this.mConfig.audioFormatChannels();
            AudioMediaEncoder.this.mConfig.getClass();
            int minBufferSize = AudioRecord.getMinBufferSize((int)n, (int)n2, (int)2);
            for (bufferSize = AudioMediaEncoder.this.mConfig.frameSize() * AudioMediaEncoder.this.mConfig.audioRecordBufferFrames(); bufferSize < minBufferSize; bufferSize += AudioMediaEncoder.this.mConfig.frameSize()) {
            }
            int n3 = ((AudioMediaEncoder)AudioMediaEncoder.this).mConfig.samplingFrequency;
            int n4 = AudioMediaEncoder.this.mConfig.audioFormatChannels();
            AudioMediaEncoder.this.mConfig.getClass();
            this.mAudioRecord = new AudioRecord(5, n3, n4, 2, bufferSize);
        }

        @Override
        public void run() {
            this.mAudioRecord.startRecording();
            while (!AudioMediaEncoder.this.mRequestStop) {
                if (AudioMediaEncoder.this.hasReachedMaxLength()) continue;
                this.read(false);
            }
            LOG.w("Stop was requested. We're out of the loop. Will post an endOfStream.");
            boolean didReadEos = false;
            while (!didReadEos) {
                didReadEos = this.read(true);
            }
            this.mAudioRecord.stop();
            this.mAudioRecord.release();
            this.mAudioRecord = null;
        }

        private boolean read(boolean endOfStream) {
            this.mCurrentBuffer = (ByteBuffer)AudioMediaEncoder.this.mByteBufferPool.get();
            if (this.mCurrentBuffer == null) {
                if (endOfStream) {
                    LOG.v("read thread - eos: true - No buffer, retrying.");
                } else {
                    LOG.w("read thread - eos: false - Skipping audio frame,", "encoding is too slow.");
                    AudioMediaEncoder.this.skipFrames(6);
                }
                return false;
            }
            this.mCurrentBuffer.clear();
            this.mCurrentReadBytes = this.mAudioRecord.read(this.mCurrentBuffer, AudioMediaEncoder.this.mConfig.frameSize());
            LOG.i("read thread - eos:", endOfStream, "- Read new audio frame. Bytes:", this.mCurrentReadBytes);
            if (this.mCurrentReadBytes > 0) {
                this.increaseTime(this.mCurrentReadBytes, endOfStream);
                LOG.i("read thread - eos:", endOfStream, "- mLastTimeUs:", this.mLastTimeUs);
                this.mCurrentBuffer.limit(this.mCurrentReadBytes);
                this.enqueue(this.mCurrentBuffer, this.mLastTimeUs, endOfStream);
            } else if (this.mCurrentReadBytes == -3) {
                LOG.e("read thread - eos:", endOfStream, "- Got AudioRecord.ERROR_INVALID_OPERATION");
            } else if (this.mCurrentReadBytes == -2) {
                LOG.e("read thread - eos:", endOfStream, "- Got AudioRecord.ERROR_BAD_VALUE");
            }
            return true;
        }

        private void increaseTime(int readBytes, boolean endOfStream) {
            this.mLastTimeUs = AudioMediaEncoder.this.mTimestamp.increaseUs(readBytes);
            if (this.mFirstTimeUs == Long.MIN_VALUE) {
                this.mFirstTimeUs = this.mLastTimeUs;
                AudioMediaEncoder.this.notifyFirstFrameMillis(System.currentTimeMillis() - AudioTimestamp.bytesToMillis(readBytes, AudioMediaEncoder.this.mConfig.byteRate()));
            }
            if (!AudioMediaEncoder.this.hasReachedMaxLength()) {
                boolean didReachMaxLength;
                boolean bl = didReachMaxLength = this.mLastTimeUs - this.mFirstTimeUs > AudioMediaEncoder.this.getMaxLengthUs();
                if (didReachMaxLength && !endOfStream) {
                    LOG.w("read thread - this frame reached the maxLength! deltaUs:", this.mLastTimeUs - this.mFirstTimeUs);
                    AudioMediaEncoder.this.notifyMaxLengthReached();
                }
            }
            this.maybeAddNoise();
        }

        private void enqueue(@NonNull ByteBuffer byteBuffer, long timestamp, boolean isEndOfStream) {
            int readBytes = byteBuffer.remaining();
            InputBuffer inputBuffer = (InputBuffer)AudioMediaEncoder.this.mInputBufferPool.get();
            inputBuffer.source = byteBuffer;
            inputBuffer.timestamp = timestamp;
            inputBuffer.length = readBytes;
            inputBuffer.isEndOfStream = isEndOfStream;
            AudioMediaEncoder.this.mInputBufferQueue.add(inputBuffer);
        }

        private void maybeAddNoise() {
            int gaps = AudioMediaEncoder.this.mTimestamp.getGapCount(AudioMediaEncoder.this.mConfig.frameSize());
            if (gaps <= 0) {
                return;
            }
            long gapStart = AudioMediaEncoder.this.mTimestamp.getGapStartUs(this.mLastTimeUs);
            long frameUs = AudioTimestamp.bytesToUs(AudioMediaEncoder.this.mConfig.frameSize(), AudioMediaEncoder.this.mConfig.byteRate());
            LOG.w("read thread - GAPS: trying to add", gaps, "noise buffers. PERFORMANCE_MAX_GAPS:", 8);
            for (int i = 0; i < Math.min(gaps, 8); ++i) {
                ByteBuffer noiseBuffer = (ByteBuffer)AudioMediaEncoder.this.mByteBufferPool.get();
                if (noiseBuffer == null) {
                    LOG.e("read thread - GAPS: aborting because we have no free buffer.");
                    break;
                }
                noiseBuffer.clear();
                AudioMediaEncoder.this.mAudioNoise.fill(noiseBuffer);
                noiseBuffer.rewind();
                this.enqueue(noiseBuffer, gapStart, false);
                gapStart += frameUs;
            }
        }
    }
}

