/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.VideoResult;

public abstract class VideoRecorder {
    private static final String TAG = VideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int STATE_IDLE = 0;
    private static final int STATE_RECORDING = 1;
    private static final int STATE_STOPPING = 2;
    @VisibleForTesting(otherwise=4)
    VideoResult.Stub mResult;
    private final VideoResultListener mListener;
    protected Exception mError;
    private int mState;

    VideoRecorder(@Nullable VideoResultListener listener) {
        this.mListener = listener;
        this.mState = 0;
    }

    public final void start(@NonNull VideoResult.Stub stub) {
        if (this.mState != 0) {
            LOG.e("start:", "called twice, or while stopping! Ignoring. state:", this.mState);
            return;
        }
        this.mState = 1;
        this.mResult = stub;
        this.onStart();
    }

    public final void stop(boolean isCameraShutdown) {
        if (this.mState == 0) {
            LOG.e("stop:", "called twice, or called before start! Ignoring. isCameraShutdown:", isCameraShutdown);
            return;
        }
        this.mState = 2;
        this.onStop(isCameraShutdown);
    }

    public boolean isRecording() {
        return this.mState != 0;
    }

    protected abstract void onStart();

    protected abstract void onStop(boolean var1);

    protected final void dispatchResult() {
        if (!this.isRecording()) {
            return;
        }
        this.mState = 0;
        this.onDispatchResult();
        if (this.mListener != null) {
            this.mListener.onVideoResult(this.mResult, this.mError);
        }
        this.mResult = null;
        this.mError = null;
    }

    protected void onDispatchResult() {
    }

    @CallSuper
    protected void dispatchVideoRecordingStart() {
        if (this.mListener != null) {
            this.mListener.onVideoRecordingStart();
        }
    }

    @CallSuper
    protected void dispatchVideoRecordingEnd() {
        if (this.mListener != null) {
            this.mListener.onVideoRecordingEnd();
        }
    }

    public static interface VideoResultListener {
        public void onVideoResult(@Nullable VideoResult.Stub var1, @Nullable Exception var2);

        public void onVideoRecordingStart();

        public void onVideoRecordingEnd();
    }
}

