/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import android.media.MediaRecorder;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.engine.Camera2Engine;
import com.otaliastudios.cameraview.engine.action.Action;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.BaseAction;
import com.otaliastudios.cameraview.engine.action.CompletionCallback;
import com.otaliastudios.cameraview.internal.utils.CamcorderProfiles;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.FullVideoRecorder;

@RequiresApi(value=21)
public class Full2VideoRecorder
extends FullVideoRecorder {
    private static final String TAG = Full2VideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private ActionHolder mHolder;
    private final String mCameraId;
    private Surface mInputSurface;

    public Full2VideoRecorder(@NonNull Camera2Engine engine, @NonNull String cameraId) {
        super(engine);
        this.mHolder = engine;
        this.mCameraId = cameraId;
    }

    @Override
    protected void onStart() {
        BaseAction action = new BaseAction(){

            @Override
            public void onCaptureStarted(@NonNull ActionHolder holder, @NonNull CaptureRequest request) {
                super.onCaptureStarted(holder, request);
                Object tag = holder.getBuilder(this).build().getTag();
                Object currentTag = request.getTag();
                if (tag == null ? currentTag == null : tag.equals(currentTag)) {
                    this.setState(Integer.MAX_VALUE);
                }
            }
        };
        action.addCallback(new CompletionCallback(){

            @Override
            protected void onActionCompleted(@NonNull Action action) {
                Full2VideoRecorder.super.onStart();
            }
        });
        action.start(this.mHolder);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    protected boolean onPrepareMediaRecorder(@NonNull VideoResult.Stub stub, @NonNull MediaRecorder mediaRecorder) {
        mediaRecorder.setVideoSource(2);
        Size size = stub.rotation % 180 != 0 ? stub.size.flip() : stub.size;
        this.mProfile = CamcorderProfiles.get(this.mCameraId, size);
        return super.onPrepareMediaRecorder(stub, mediaRecorder);
    }

    @NonNull
    public Surface createInputSurface(@NonNull VideoResult.Stub stub) throws PrepareException {
        if (!this.prepareMediaRecorder(stub)) {
            throw new PrepareException(this.mError);
        }
        this.mInputSurface = this.mMediaRecorder.getSurface();
        return this.mInputSurface;
    }

    @Nullable
    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    public class PrepareException
    extends Exception {
        private PrepareException(Throwable cause) {
            super(cause);
        }
    }
}

