/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.utils;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;

public class CropHelper {
    @NonNull
    public static Rect computeCrop(@NonNull Size currentSize, @NonNull AspectRatio targetRatio) {
        int x;
        int y;
        int width;
        int height;
        int currentWidth = currentSize.getWidth();
        int currentHeight = currentSize.getHeight();
        if (targetRatio.matches(currentSize, 5.0E-4f)) {
            return new Rect(0, 0, currentWidth, currentHeight);
        }
        AspectRatio currentRatio = AspectRatio.of(currentWidth, currentHeight);
        if (currentRatio.toFloat() > targetRatio.toFloat()) {
            height = currentHeight;
            width = Math.round((float)height * targetRatio.toFloat());
            y = 0;
            x = Math.round((float)(currentWidth - width) / 2.0f);
        } else {
            width = currentWidth;
            height = Math.round((float)width / targetRatio.toFloat());
            y = Math.round((float)(currentHeight - height) / 2.0f);
            x = 0;
        }
        return new Rect(x, y, x + width, y + height);
    }
}

