/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.frame;

import android.graphics.ImageFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.size.Size;
import java.util.concurrent.LinkedBlockingQueue;

public class FrameManager {
    private static final String TAG = FrameManager.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private final int mPoolSize;
    private int mBufferSize = -1;
    private Size mFrameSize = null;
    private int mFrameFormat = -1;
    private LinkedBlockingQueue<Frame> mFrameQueue;
    private LinkedBlockingQueue<byte[]> mBufferQueue;
    private BufferCallback mBufferCallback;
    private final int mBufferMode;
    private static final int BUFFER_MODE_DISPATCH = 0;
    private static final int BUFFER_MODE_ENQUEUE = 1;

    public FrameManager(int poolSize, @Nullable BufferCallback callback) {
        this.mPoolSize = poolSize;
        this.mFrameQueue = new LinkedBlockingQueue(this.mPoolSize);
        if (callback != null) {
            this.mBufferCallback = callback;
            this.mBufferMode = 0;
        } else {
            this.mBufferQueue = new LinkedBlockingQueue(this.mPoolSize);
            this.mBufferMode = 1;
        }
    }

    public int setUp(int format, @NonNull Size size) {
        if (this.isSetUp()) {
            // empty if block
        }
        this.mFrameSize = size;
        this.mFrameFormat = format;
        int bitsPerPixel = ImageFormat.getBitsPerPixel((int)format);
        long sizeInBits = size.getHeight() * size.getWidth() * bitsPerPixel;
        this.mBufferSize = (int)Math.ceil((double)sizeInBits / 8.0);
        for (int i = 0; i < this.mPoolSize; ++i) {
            if (this.mBufferMode == 0) {
                this.mBufferCallback.onBufferAvailable(new byte[this.mBufferSize]);
                continue;
            }
            this.mBufferQueue.offer(new byte[this.mBufferSize]);
        }
        return this.mBufferSize;
    }

    private boolean isSetUp() {
        return this.mFrameSize != null;
    }

    @Nullable
    public byte[] getBuffer() {
        if (this.mBufferMode != 1) {
            throw new IllegalStateException("Can't call getBuffer() when not in BUFFER_MODE_ENQUEUE.");
        }
        return this.mBufferQueue.poll();
    }

    public void onBufferUnused(@NonNull byte[] buffer) {
        if (this.mBufferMode != 1) {
            throw new IllegalStateException("Can't call onBufferUnused() when not in BUFFER_MODE_ENQUEUE.");
        }
        if (this.isSetUp()) {
            this.mBufferQueue.offer(buffer);
        } else {
            LOG.w("onBufferUnused: buffer was returned but we're not set up anymore.");
        }
    }

    @NonNull
    public Frame getFrame(@NonNull byte[] data, long time, int rotation) {
        if (!this.isSetUp()) {
            throw new IllegalStateException("Can't call getFrame() after releasing or before setUp.");
        }
        Frame frame = this.mFrameQueue.poll();
        if (frame != null) {
            LOG.v("getFrame for time:", time, "RECYCLING.");
        } else {
            LOG.v("getFrame for time:", time, "CREATING.");
            frame = new Frame(this);
        }
        frame.setContent(data, time, rotation, this.mFrameSize, this.mFrameFormat);
        return frame;
    }

    void onFrameReleased(@NonNull Frame frame, @NonNull byte[] buffer) {
        int reqSize;
        int currSize;
        if (!this.isSetUp()) {
            return;
        }
        if (this.mFrameQueue.offer(frame) && (currSize = buffer.length) == (reqSize = this.mBufferSize)) {
            if (this.mBufferMode == 0) {
                this.mBufferCallback.onBufferAvailable(buffer);
            } else {
                this.mBufferQueue.offer(buffer);
            }
        }
    }

    public void release() {
        if (!this.isSetUp()) {
            LOG.w("release called twice. Ignoring.");
            return;
        }
        LOG.i("release: Clearing the frame and buffer queue.");
        this.mFrameQueue.clear();
        if (this.mBufferMode == 1) {
            this.mBufferQueue.clear();
        }
        this.mBufferSize = -1;
        this.mFrameSize = null;
        this.mFrameFormat = -1;
    }

    public static interface BufferCallback {
        public void onBufferAvailable(@NonNull byte[] var1);
    }
}

