/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.filter.BaseFilter;
import com.otaliastudios.cameraview.internal.GlUtils;
import java.util.Random;

public class DocumentaryFilter
extends BaseFilter {
    private static final Random RANDOM = new Random();
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvec2 seed;\nfloat stepsize;\nuniform float inv_max_dist;\nuniform vec2 scale;\nvarying vec2 vTextureCoord;\nfloat rand(vec2 loc) {\n  float theta1 = dot(loc, vec2(0.9898, 0.233));\n  float theta2 = dot(loc, vec2(12.0, 78.0));\n  float value = cos(theta1) * sin(theta2) + sin(theta1) * cos(theta2);\n  float temp = mod(197.0 * value, 1.0) + value;\n  float part1 = mod(220.0 * temp, 1.0) + temp;\n  float part2 = value * 0.5453;\n  float part3 = cos(theta1 + theta2) * 0.43758;\n  return fract(part1 + part2 + part3);\n}\nvoid main() {\n  seed[0] = " + RANDOM.nextFloat() + ";\n  seed[1] = " + RANDOM.nextFloat() + ";\n  stepsize = " + 0.003921569f + ";\n  vec4 color = texture2D(sTexture, " + "vTextureCoord" + ");\n  float dither = rand(" + "vTextureCoord" + " + seed);\n  vec3 xform = clamp(2.0 * color.rgb, 0.0, 1.0);\n  vec3 temp = clamp(2.0 * (color.rgb + stepsize), 0.0, 1.0);\n  vec3 new_color = clamp(xform + (temp - xform) * (dither - 0.5), 0.0, 1.0);\n  float gray = dot(new_color, vec3(0.299, 0.587, 0.114));\n  new_color = vec3(gray, gray, gray);\n  vec2 coord = " + "vTextureCoord" + " - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float lumen = 0.85 / (1.0 + exp((dist * inv_max_dist - 0.83) * 20.0)) + 0.15;\n  gl_FragColor = vec4(new_color * lumen, color.a);\n}\n";
    private int mWidth = 1;
    private int mHeight = 1;
    private int mScaleLocation = -1;
    private int mMaxDistLocation = -1;

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.mScaleLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"scale");
        GlUtils.checkLocation(this.mScaleLocation, "scale");
        this.mMaxDistLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"inv_max_dist");
        GlUtils.checkLocation(this.mMaxDistLocation, "inv_max_dist");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mScaleLocation = -1;
        this.mMaxDistLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        float[] scale = new float[2];
        if (this.mWidth > this.mHeight) {
            scale[0] = 1.0f;
            scale[1] = (float)this.mHeight / (float)this.mWidth;
        } else {
            scale[0] = (float)this.mWidth / (float)this.mHeight;
            scale[1] = 1.0f;
        }
        GLES20.glUniform2fv((int)this.mScaleLocation, (int)1, (float[])scale, (int)0);
        GlUtils.checkError("glUniform2fv");
        float maxDist = (float)Math.sqrt(scale[0] * scale[0] + scale[1] * scale[1]) * 0.5f;
        float invMaxDist = 1.0f / maxDist;
        GLES20.glUniform1f((int)this.mMaxDistLocation, (float)invMaxDist);
        GlUtils.checkError("glUniform1f");
    }
}

