/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.meter;

import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.ActionWrapper;
import com.otaliastudios.cameraview.engine.action.Actions;
import com.otaliastudios.cameraview.engine.action.BaseAction;
import com.otaliastudios.cameraview.engine.meter.BaseMeter;
import com.otaliastudios.cameraview.engine.meter.ExposureMeter;
import com.otaliastudios.cameraview.engine.meter.FocusMeter;
import com.otaliastudios.cameraview.engine.meter.WhiteBalanceMeter;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(value=21)
public class MeterAction
extends ActionWrapper {
    private static final String TAG = MeterAction.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private List<BaseMeter> meters;
    private BaseAction action;
    private ActionHolder holder;
    private final PointF point;
    private final CameraEngine engine;
    private final boolean skipIfPossible;

    public MeterAction(@NonNull CameraEngine engine, @Nullable PointF point, boolean skipIfPossible) {
        this.point = point;
        this.engine = engine;
        this.skipIfPossible = skipIfPossible;
    }

    @Override
    @NonNull
    public BaseAction getAction() {
        return this.action;
    }

    @Nullable
    public PointF getPoint() {
        return this.point;
    }

    public boolean isSuccessful() {
        for (BaseMeter meter : this.meters) {
            if (meter.isSuccessful()) continue;
            LOG.i("isSuccessful:", "returning false.");
            return false;
        }
        LOG.i("isSuccessful:", "returning true.");
        return true;
    }

    @Override
    protected void onStart(@NonNull ActionHolder holder) {
        LOG.w("onStart:", "initializing.");
        this.initialize(holder);
        LOG.w("onStart:", "initialized.");
        super.onStart(holder);
    }

    private void initialize(@NonNull ActionHolder holder) {
        this.holder = holder;
        ArrayList<MeteringRectangle> areas = new ArrayList<MeteringRectangle>();
        if (this.point != null) {
            PointF referencePoint = new PointF(this.point.x, this.point.y);
            Size referenceSize = this.engine.getPreview().getSurfaceSize();
            referenceSize = this.applyPreviewCropping(referenceSize, referencePoint);
            referenceSize = this.applyPreviewScale(referenceSize, referencePoint);
            referenceSize = this.applyPreviewToSensorRotation(referenceSize, referencePoint);
            referenceSize = this.applyCropRegionCoordinates(referenceSize, referencePoint);
            referenceSize = this.applyActiveArrayCoordinates(referenceSize, referencePoint);
            Size visibleSize = this.engine.getPreviewStreamSize(Reference.SENSOR);
            MeteringRectangle area1 = this.createMeteringRectangle(referenceSize, referencePoint, visibleSize, 0.05f, 1000);
            MeteringRectangle area2 = this.createMeteringRectangle(referenceSize, referencePoint, visibleSize, 0.1f, 100);
            areas.add(area1);
            areas.add(area2);
        }
        ExposureMeter ae = new ExposureMeter(areas, this.skipIfPossible);
        FocusMeter af = new FocusMeter(areas, this.skipIfPossible);
        WhiteBalanceMeter awb = new WhiteBalanceMeter(areas, this.skipIfPossible);
        this.meters = Arrays.asList(ae, af, awb);
        this.action = Actions.together(ae, af, awb);
    }

    @NonNull
    private Size applyPreviewCropping(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Size previewStreamSize = this.engine.getPreviewStreamSize(Reference.VIEW);
        Size previewSurfaceSize = referenceSize;
        if (previewStreamSize == null) {
            throw new IllegalStateException("getPreviewStreamSize should not be null here.");
        }
        int referenceWidth = previewSurfaceSize.getWidth();
        int referenceHeight = previewSurfaceSize.getHeight();
        AspectRatio previewStreamAspectRatio = AspectRatio.of(previewStreamSize);
        AspectRatio previewSurfaceAspectRatio = AspectRatio.of(previewSurfaceSize);
        if (this.engine.getPreview().isCropping()) {
            if (previewStreamAspectRatio.toFloat() > previewSurfaceAspectRatio.toFloat()) {
                float scale = previewStreamAspectRatio.toFloat() / previewSurfaceAspectRatio.toFloat();
                referencePoint.x += (float)previewSurfaceSize.getWidth() * (scale - 1.0f) / 2.0f;
                referenceWidth = Math.round((float)previewSurfaceSize.getWidth() * scale);
            } else {
                float scale = previewSurfaceAspectRatio.toFloat() / previewStreamAspectRatio.toFloat();
                referencePoint.y += (float)previewSurfaceSize.getHeight() * (scale - 1.0f) / 2.0f;
                referenceHeight = Math.round((float)previewSurfaceSize.getHeight() * scale);
            }
        }
        return new Size(referenceWidth, referenceHeight);
    }

    @NonNull
    private Size applyPreviewScale(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Size previewStreamSize = this.engine.getPreviewStreamSize(Reference.VIEW);
        referencePoint.x *= (float)previewStreamSize.getWidth() / (float)referenceSize.getWidth();
        referencePoint.y *= (float)previewStreamSize.getHeight() / (float)referenceSize.getHeight();
        return previewStreamSize;
    }

    @NonNull
    private Size applyPreviewToSensorRotation(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        int angle = this.engine.getAngles().offset(Reference.SENSOR, Reference.VIEW, Axis.ABSOLUTE);
        boolean flip = angle % 180 != 0;
        float tempX = referencePoint.x;
        float tempY = referencePoint.y;
        if (angle == 0) {
            referencePoint.x = tempX;
            referencePoint.y = tempY;
        } else if (angle == 90) {
            referencePoint.x = tempY;
            referencePoint.y = (float)referenceSize.getWidth() - tempX;
        } else if (angle == 180) {
            referencePoint.x = (float)referenceSize.getWidth() - tempX;
            referencePoint.y = (float)referenceSize.getHeight() - tempY;
        } else if (angle == 270) {
            referencePoint.x = (float)referenceSize.getHeight() - tempY;
            referencePoint.y = tempX;
        } else {
            throw new IllegalStateException("Unexpected angle " + angle);
        }
        return flip ? referenceSize.flip() : referenceSize;
    }

    @NonNull
    private Size applyCropRegionCoordinates(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Rect cropRect = (Rect)this.holder.getBuilder(this).get(CaptureRequest.SCALER_CROP_REGION);
        int cropRectWidth = cropRect == null ? referenceSize.getWidth() : cropRect.width();
        int cropRectHeight = cropRect == null ? referenceSize.getHeight() : cropRect.height();
        referencePoint.x += (float)(cropRectWidth - referenceSize.getWidth()) / 2.0f;
        referencePoint.y += (float)(cropRectHeight - referenceSize.getHeight()) / 2.0f;
        return new Size(cropRectWidth, cropRectHeight);
    }

    @NonNull
    private Size applyActiveArrayCoordinates(@NonNull Size referenceSize, @NonNull PointF referencePoint) {
        Rect cropRect = (Rect)this.holder.getBuilder(this).get(CaptureRequest.SCALER_CROP_REGION);
        referencePoint.x = referencePoint.x + (cropRect == null ? 0.0f : (float)cropRect.left);
        referencePoint.y = referencePoint.y + (cropRect == null ? 0.0f : (float)cropRect.top);
        Rect activeRect = (Rect)this.holder.getCharacteristics(this).get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        if (activeRect == null) {
            activeRect = new Rect(0, 0, referenceSize.getWidth(), referenceSize.getHeight());
        }
        return new Size(activeRect.width(), activeRect.height());
    }

    @NonNull
    private MeteringRectangle createMeteringRectangle(@NonNull Size boundaries, @NonNull PointF center, @NonNull Size visibleSize, float factor, int weight) {
        float rectangleWidth = factor * (float)visibleSize.getWidth();
        float rectangleHeight = factor * (float)visibleSize.getHeight();
        float rectangleLeft = center.x - rectangleWidth / 2.0f;
        float rectangleTop = center.y - rectangleHeight / 2.0f;
        if (rectangleLeft < 0.0f) {
            rectangleLeft = 0.0f;
        }
        if (rectangleTop < 0.0f) {
            rectangleTop = 0.0f;
        }
        if (rectangleLeft + rectangleWidth > (float)boundaries.getWidth()) {
            rectangleWidth = (float)boundaries.getWidth() - rectangleLeft;
        }
        if (rectangleTop + rectangleHeight > (float)boundaries.getHeight()) {
            rectangleHeight = (float)boundaries.getHeight() - rectangleTop;
        }
        return new MeteringRectangle((int)rectangleLeft, (int)rectangleTop, (int)rectangleWidth, (int)rectangleHeight, weight);
    }
}

