/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine.lock;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.lock.BaseLock;

@RequiresApi(value=21)
public class FocusLock
extends BaseLock {
    private static final String TAG = FocusLock.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    @Override
    protected boolean checkIsSupported(@NonNull ActionHolder holder) {
        int[] modes;
        for (int mode : modes = this.readCharacteristic(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, new int[0])) {
            if (mode != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkShouldSkip(@NonNull ActionHolder holder) {
        TotalCaptureResult lastResult = holder.getLastResult(this);
        Integer afState = (Integer)lastResult.get(CaptureResult.CONTROL_AF_STATE);
        boolean afStateOk = afState != null && (afState == 4 || afState == 5 || afState == 0 || afState == 2 || afState == 6);
        Integer afMode = (Integer)lastResult.get(CaptureResult.CONTROL_AF_MODE);
        boolean afModeOk = afMode != null && afMode == 1;
        boolean result = afStateOk && afModeOk;
        LOG.i("checkShouldSkip:", result);
        return result;
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder) {
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
        holder.applyBuilder(this);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
        Integer afMode = (Integer)result.get(CaptureResult.CONTROL_AF_MODE);
        LOG.i("onCapture:", "afState:", afState, "afMode:", afMode);
        if (afState == null || afMode == null) {
            return;
        }
        if (afMode != 1) {
            return;
        }
        switch (afState) {
            case 0: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                this.setState(Integer.MAX_VALUE);
                break;
            }
        }
    }
}

