/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.engine.Camera2Engine;
import com.otaliastudios.cameraview.engine.action.ActionHolder;
import com.otaliastudios.cameraview.engine.action.BaseAction;

@RequiresApi(value=21)
class LogAction
extends BaseAction {
    private static final CameraLogger LOG = CameraLogger.create(Camera2Engine.class.getSimpleName());
    private String lastLog;

    LogAction() {
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        Integer aeMode = (Integer)result.get(CaptureResult.CONTROL_AE_MODE);
        Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
        Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
        Boolean aeLock = (Boolean)result.get(CaptureResult.CONTROL_AE_LOCK);
        Integer aeTriggerState = (Integer)result.get(CaptureResult.CONTROL_AE_PRECAPTURE_TRIGGER);
        Integer afTriggerState = (Integer)result.get(CaptureResult.CONTROL_AF_TRIGGER);
        String log = "aeMode: " + aeMode + " aeLock: " + aeLock + " aeState: " + aeState + " aeTriggerState: " + aeTriggerState + " afState: " + afState + " afTriggerState: " + afTriggerState;
        if (!log.equals(this.lastLog)) {
            this.lastLog = log;
            LOG.i(log);
        }
    }

    @Override
    protected void onCompleted(@NonNull ActionHolder holder) {
        super.onCompleted(holder);
        this.setState(0);
        this.start(holder);
    }
}

