/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.location.Location;
import android.os.Build;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.engine.mappers.Camera1Mapper;
import com.otaliastudios.cameraview.engine.offset.Axis;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.gesture.Gesture;
import com.otaliastudios.cameraview.internal.utils.CropHelper;
import com.otaliastudios.cameraview.picture.Full1PictureRecorder;
import com.otaliastudios.cameraview.picture.Snapshot1PictureRecorder;
import com.otaliastudios.cameraview.picture.SnapshotGlPictureRecorder;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.Full1VideoRecorder;
import com.otaliastudios.cameraview.video.SnapshotVideoRecorder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Camera1Engine
extends CameraEngine
implements Camera.PreviewCallback,
Camera.ErrorCallback,
FrameManager.BufferCallback {
    private static final String TAG = Camera1Engine.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int PREVIEW_FORMAT = 17;
    @VisibleForTesting
    static final int AUTOFOCUS_END_DELAY_MILLIS = 2500;
    private final Camera1Mapper mMapper = Camera1Mapper.get();
    private Camera mCamera;
    @VisibleForTesting
    int mCameraId;
    private Runnable mFocusEndRunnable;
    private final Runnable mFocusResetRunnable = new Runnable(){

        @Override
        public void run() {
            if (Camera1Engine.this.getEngineState() < 2) {
                return;
            }
            Camera1Engine.this.mCamera.cancelAutoFocus();
            Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
            int maxAF = params.getMaxNumFocusAreas();
            int maxAE = params.getMaxNumMeteringAreas();
            if (maxAF > 0) {
                params.setFocusAreas(null);
            }
            if (maxAE > 0) {
                params.setMeteringAreas(null);
            }
            Camera1Engine.this.applyDefaultFocus(params);
            Camera1Engine.this.mCamera.setParameters(params);
        }
    };

    public Camera1Engine(@NonNull CameraEngine.Callback callback) {
        super(callback);
    }

    public void onError(int error, Camera camera) {
        int reason;
        if (error == 100) {
            LOG.w("Recoverable error inside the onError callback.", "CAMERA_ERROR_SERVER_DIED");
            this.restart();
            return;
        }
        String message = LOG.e("Internal Camera1 error.", error);
        RuntimeException runtime = new RuntimeException(message);
        switch (error) {
            case 2: {
                reason = 3;
                break;
            }
            case 1: {
                reason = 0;
                break;
            }
            default: {
                reason = 0;
            }
        }
        throw new CameraException(runtime, reason);
    }

    @Override
    @NonNull
    protected List<Size> getPreviewStreamAvailableSizes() {
        List sizes = this.mCamera.getParameters().getSupportedPreviewSizes();
        ArrayList<Size> result = new ArrayList<Size>(sizes.size());
        for (Camera.Size size : sizes) {
            Size add = new Size(size.width, size.height);
            if (result.contains(add)) continue;
            result.add(add);
        }
        LOG.i("getPreviewStreamAvailableSizes:", result);
        return result;
    }

    @Override
    @WorkerThread
    protected void onPreviewStreamSizeChanged() {
        this.restartPreview();
    }

    @Override
    protected boolean collectCameraInfo(@NonNull Facing facing) {
        int internalFacing = this.mMapper.mapFacing(facing);
        LOG.i("collectCameraInfo", "Facing:", facing, "Internal:", internalFacing, "Cameras:", Camera.getNumberOfCameras());
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != internalFacing) continue;
            this.getAngles().setSensorOffset(facing, cameraInfo.orientation);
            this.mCameraId = i;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    @WorkerThread
    protected Task<Void> onStartEngine() {
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (Exception e) {
            LOG.e("onStartEngine:", "Failed to connect. Maybe in use by another app?");
            throw new CameraException(e, 1);
        }
        this.mCamera.setErrorCallback((Camera.ErrorCallback)this);
        LOG.i("onStartEngine:", "Applying default parameters.");
        Camera.Parameters params = this.mCamera.getParameters();
        this.mCameraOptions = new CameraOptions(params, this.getAngles().flip(Reference.SENSOR, Reference.VIEW));
        this.applyAllParameters(params);
        this.mCamera.setParameters(params);
        this.mCamera.setDisplayOrientation(this.getAngles().offset(Reference.SENSOR, Reference.VIEW, Axis.ABSOLUTE));
        LOG.i("onStartEngine:", "Ended");
        return Tasks.forResult(null);
    }

    @Override
    @NonNull
    protected Task<Void> onStartBind() {
        block4: {
            LOG.i("onStartBind:", "Started");
            Object output = this.mPreview.getOutput();
            try {
                if (output instanceof SurfaceHolder) {
                    this.mCamera.setPreviewDisplay((SurfaceHolder)output);
                    break block4;
                }
                if (output instanceof SurfaceTexture) {
                    this.mCamera.setPreviewTexture((SurfaceTexture)output);
                    break block4;
                }
                throw new RuntimeException("Unknown CameraPreview output class.");
            }
            catch (IOException e) {
                LOG.e("onStartBind:", "Failed to bind.", e);
                throw new CameraException(e, 2);
            }
        }
        this.mCaptureSize = this.computeCaptureSize();
        this.mPreviewStreamSize = this.computePreviewStreamSize();
        return Tasks.forResult(null);
    }

    @Override
    @NonNull
    protected Task<Void> onStartPreview() {
        LOG.i("onStartPreview", "Dispatching onCameraPreviewStreamSizeChanged.");
        this.mCallback.onCameraPreviewStreamSizeChanged();
        Size previewSize = this.getPreviewStreamSize(Reference.VIEW);
        if (previewSize == null) {
            throw new IllegalStateException("previewStreamSize should not be null at this point.");
        }
        this.mPreview.setStreamSize(previewSize.getWidth(), previewSize.getHeight());
        Camera.Parameters params = this.mCamera.getParameters();
        params.setPreviewFormat(17);
        params.setPreviewSize(this.mPreviewStreamSize.getWidth(), this.mPreviewStreamSize.getHeight());
        if (this.getMode() == Mode.PICTURE) {
            params.setPictureSize(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        } else {
            Size pictureSize = this.computeCaptureSize(Mode.PICTURE);
            params.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        this.mCamera.setParameters(params);
        this.mCamera.setPreviewCallbackWithBuffer(null);
        this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        this.getFrameManager().setUp(17, this.mPreviewStreamSize);
        LOG.i("onStartPreview", "Starting preview with startPreview().");
        try {
            this.mCamera.startPreview();
        }
        catch (Exception e) {
            LOG.e("onStartPreview", "Failed to start preview.", e);
            throw new CameraException(e, 2);
        }
        LOG.i("onStartPreview", "Started preview.");
        return Tasks.forResult(null);
    }

    @Override
    @NonNull
    protected Task<Void> onStopPreview() {
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop(true);
            this.mVideoRecorder = null;
        }
        this.mPictureRecorder = null;
        this.getFrameManager().release();
        this.mCamera.setPreviewCallbackWithBuffer(null);
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception e) {
            LOG.e("stopPreview", "Could not stop preview", e);
        }
        return Tasks.forResult(null);
    }

    @Override
    @NonNull
    protected Task<Void> onStopBind() {
        block4: {
            this.mPreviewStreamSize = null;
            this.mCaptureSize = null;
            try {
                if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
                    this.mCamera.setPreviewDisplay(null);
                    break block4;
                }
                if (this.mPreview.getOutputClass() == SurfaceTexture.class) {
                    this.mCamera.setPreviewTexture(null);
                    break block4;
                }
                throw new RuntimeException("Unknown CameraPreview output class.");
            }
            catch (IOException e) {
                LOG.e("unbindFromSurface", "Could not release surface", e);
            }
        }
        return Tasks.forResult(null);
    }

    @Override
    @NonNull
    @WorkerThread
    protected Task<Void> onStopEngine() {
        LOG.i("onStopEngine:", "About to clean up.");
        this.mHandler.remove(this.mFocusResetRunnable);
        if (this.mFocusEndRunnable != null) {
            this.mHandler.remove(this.mFocusEndRunnable);
        }
        if (this.mCamera != null) {
            try {
                LOG.i("onStopEngine:", "Clean up.", "Releasing camera.");
                this.mCamera.release();
                LOG.i("onStopEngine:", "Clean up.", "Released camera.");
            }
            catch (Exception e) {
                LOG.w("onStopEngine:", "Clean up.", "Exception while releasing camera.", e);
            }
            this.mCamera = null;
            this.mCameraOptions = null;
        }
        this.mVideoRecorder = null;
        this.mCameraOptions = null;
        this.mCamera = null;
        LOG.w("onStopEngine:", "Clean up.", "Returning.");
        return Tasks.forResult(null);
    }

    @Override
    @WorkerThread
    protected void onTakePicture(@NonNull PictureResult.Stub stub, boolean doMetering) {
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        stub.size = this.getPictureSize(Reference.OUTPUT);
        this.mPictureRecorder = new Full1PictureRecorder(stub, this, this.mCamera);
        this.mPictureRecorder.take();
    }

    @Override
    @WorkerThread
    protected void onTakePictureSnapshot(@NonNull PictureResult.Stub stub, @NonNull AspectRatio outputRatio, boolean doMetering) {
        stub.size = this.getUncroppedSnapshotSize(Reference.OUTPUT);
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        this.mPictureRecorder = this.mPreview instanceof GlCameraPreview && Build.VERSION.SDK_INT >= 19 ? new SnapshotGlPictureRecorder(stub, this, (GlCameraPreview)this.mPreview, outputRatio) : new Snapshot1PictureRecorder(stub, this, this.mCamera, outputRatio);
        this.mPictureRecorder.take();
    }

    @Override
    protected void onTakeVideo(@NonNull VideoResult.Stub stub) {
        stub.rotation = this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR);
        stub.size = this.getAngles().flip(Reference.SENSOR, Reference.OUTPUT) ? this.mCaptureSize.flip() : this.mCaptureSize;
        try {
            this.mCamera.unlock();
        }
        catch (Exception e) {
            this.onVideoResult(null, e);
            return;
        }
        this.mVideoRecorder = new Full1VideoRecorder(this, this.mCamera, this.mCameraId);
        this.mVideoRecorder.start(stub);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void onTakeVideoSnapshot(@NonNull VideoResult.Stub stub, @NonNull AspectRatio outputRatio) {
        if (!(this.mPreview instanceof GlCameraPreview)) {
            throw new IllegalStateException("Video snapshots are only supported with GL_SURFACE.");
        }
        if (Build.VERSION.SDK_INT < 18) {
            throw new IllegalStateException("Video snapshots are only supported on API 18+.");
        }
        GlCameraPreview glPreview = (GlCameraPreview)this.mPreview;
        Size outputSize = this.getUncroppedSnapshotSize(Reference.OUTPUT);
        if (outputSize == null) {
            throw new IllegalStateException("outputSize should not be null.");
        }
        Rect outputCrop = CropHelper.computeCrop(outputSize, outputRatio);
        stub.size = outputSize = new Size(outputCrop.width(), outputCrop.height());
        stub.rotation = this.getAngles().offset(Reference.VIEW, Reference.OUTPUT, Axis.ABSOLUTE);
        LOG.i("onTakeVideoSnapshot", "rotation:", stub.rotation, "size:", stub.size);
        this.mVideoRecorder = new SnapshotVideoRecorder(this, glPreview, this.getOverlay(), stub.rotation);
        this.mVideoRecorder.start(stub);
    }

    @Override
    public void onVideoResult(@Nullable VideoResult.Stub result, @Nullable Exception exception) {
        super.onVideoResult(result, exception);
        if (result == null) {
            this.mCamera.lock();
        }
    }

    private void applyAllParameters(@NonNull Camera.Parameters params) {
        params.setRecordingHint(this.getMode() == Mode.VIDEO);
        this.applyDefaultFocus(params);
        this.applyFlash(params, Flash.OFF);
        this.applyLocation(params, null);
        this.applyWhiteBalance(params, WhiteBalance.AUTO);
        this.applyHdr(params, Hdr.OFF);
        this.applyZoom(params, 0.0f);
        this.applyExposureCorrection(params, 0.0f);
        this.applyPlaySounds(this.mPlaySounds);
    }

    private void applyDefaultFocus(@NonNull Camera.Parameters params) {
        List modes = params.getSupportedFocusModes();
        if (this.getMode() == Mode.VIDEO && modes.contains("continuous-video")) {
            params.setFocusMode("continuous-video");
            return;
        }
        if (modes.contains("continuous-picture")) {
            params.setFocusMode("continuous-picture");
            return;
        }
        if (modes.contains("infinity")) {
            params.setFocusMode("infinity");
            return;
        }
        if (modes.contains("fixed")) {
            params.setFocusMode("fixed");
            return;
        }
    }

    @Override
    public void setFlash(@NonNull Flash flash) {
        final Flash old = this.mFlash;
        this.mFlash = flash;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params;
                if (Camera1Engine.this.getEngineState() == 2 && Camera1Engine.this.applyFlash(params = Camera1Engine.this.mCamera.getParameters(), old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
                Camera1Engine.this.mFlashOp.end(null);
            }
        });
    }

    private boolean applyFlash(@NonNull Camera.Parameters params, @NonNull Flash oldFlash) {
        if (this.mCameraOptions.supports(this.mFlash)) {
            params.setFlashMode(this.mMapper.mapFlash(this.mFlash));
            return true;
        }
        this.mFlash = oldFlash;
        return false;
    }

    @Override
    public void setLocation(@Nullable Location location) {
        final Location oldLocation = this.mLocation;
        this.mLocation = location;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params;
                if (Camera1Engine.this.getEngineState() == 2 && Camera1Engine.this.applyLocation(params = Camera1Engine.this.mCamera.getParameters(), oldLocation)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
                Camera1Engine.this.mLocationOp.end(null);
            }
        });
    }

    private boolean applyLocation(@NonNull Camera.Parameters params, @Nullable Location oldLocation) {
        if (this.mLocation != null) {
            params.setGpsLatitude(this.mLocation.getLatitude());
            params.setGpsLongitude(this.mLocation.getLongitude());
            params.setGpsAltitude(this.mLocation.getAltitude());
            params.setGpsTimestamp(this.mLocation.getTime());
            params.setGpsProcessingMethod(this.mLocation.getProvider());
        }
        return true;
    }

    @Override
    public void setWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        final WhiteBalance old = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params;
                if (Camera1Engine.this.getEngineState() == 2 && Camera1Engine.this.applyWhiteBalance(params = Camera1Engine.this.mCamera.getParameters(), old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
                Camera1Engine.this.mWhiteBalanceOp.end(null);
            }
        });
    }

    private boolean applyWhiteBalance(@NonNull Camera.Parameters params, @NonNull WhiteBalance oldWhiteBalance) {
        if (this.mCameraOptions.supports(this.mWhiteBalance)) {
            params.setWhiteBalance(this.mMapper.mapWhiteBalance(this.mWhiteBalance));
            return true;
        }
        this.mWhiteBalance = oldWhiteBalance;
        return false;
    }

    @Override
    public void setHdr(@NonNull Hdr hdr) {
        final Hdr old = this.mHdr;
        this.mHdr = hdr;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params;
                if (Camera1Engine.this.getEngineState() == 2 && Camera1Engine.this.applyHdr(params = Camera1Engine.this.mCamera.getParameters(), old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                }
                Camera1Engine.this.mHdrOp.end(null);
            }
        });
    }

    private boolean applyHdr(@NonNull Camera.Parameters params, @NonNull Hdr oldHdr) {
        if (this.mCameraOptions.supports(this.mHdr)) {
            params.setSceneMode(this.mMapper.mapHdr(this.mHdr));
            return true;
        }
        this.mHdr = oldHdr;
        return false;
    }

    @Override
    public void setZoom(float zoom, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mZoomValue;
        this.mZoomValue = zoom;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params;
                if (Camera1Engine.this.getEngineState() == 2 && Camera1Engine.this.applyZoom(params = Camera1Engine.this.mCamera.getParameters(), old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                    if (notify) {
                        Camera1Engine.this.mCallback.dispatchOnZoomChanged(Camera1Engine.this.mZoomValue, points);
                    }
                }
                Camera1Engine.this.mZoomOp.end(null);
            }
        });
    }

    private boolean applyZoom(@NonNull Camera.Parameters params, float oldZoom) {
        if (this.mCameraOptions.isZoomSupported()) {
            float max = params.getMaxZoom();
            params.setZoom((int)(this.mZoomValue * max));
            this.mCamera.setParameters(params);
            return true;
        }
        this.mZoomValue = oldZoom;
        return false;
    }

    @Override
    public void setExposureCorrection(float EVvalue, final @NonNull float[] bounds, final @Nullable PointF[] points, final boolean notify) {
        final float old = this.mExposureCorrectionValue;
        this.mExposureCorrectionValue = EVvalue;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                Camera.Parameters params;
                if (Camera1Engine.this.getEngineState() == 2 && Camera1Engine.this.applyExposureCorrection(params = Camera1Engine.this.mCamera.getParameters(), old)) {
                    Camera1Engine.this.mCamera.setParameters(params);
                    if (notify) {
                        Camera1Engine.this.mCallback.dispatchOnExposureCorrectionChanged(Camera1Engine.this.mExposureCorrectionValue, bounds, points);
                    }
                }
                Camera1Engine.this.mExposureCorrectionOp.end(null);
            }
        });
    }

    private boolean applyExposureCorrection(@NonNull Camera.Parameters params, float oldExposureCorrection) {
        if (this.mCameraOptions.isExposureCorrectionSupported()) {
            float max = this.mCameraOptions.getExposureCorrectionMaxValue();
            float val = this.mExposureCorrectionValue;
            float min = this.mCameraOptions.getExposureCorrectionMinValue();
            this.mExposureCorrectionValue = val = val < min ? min : (val > max ? max : val);
            int indexValue = (int)(this.mExposureCorrectionValue / params.getExposureCompensationStep());
            params.setExposureCompensation(indexValue);
            return true;
        }
        this.mExposureCorrectionValue = oldExposureCorrection;
        return false;
    }

    @Override
    public void setPlaySounds(boolean playSounds) {
        final boolean old = this.mPlaySounds;
        this.mPlaySounds = playSounds;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera1Engine.this.getEngineState() == 2) {
                    Camera1Engine.this.applyPlaySounds(old);
                }
                Camera1Engine.this.mPlaySoundsOp.end(null);
            }
        });
    }

    @TargetApi(value=17)
    private boolean applyPlaySounds(boolean oldPlaySound) {
        if (Build.VERSION.SDK_INT >= 17) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
            if (info.canDisableShutterSound) {
                try {
                    return this.mCamera.enableShutterSound(this.mPlaySounds);
                }
                catch (RuntimeException exception) {
                    return false;
                }
            }
        }
        if (this.mPlaySounds) {
            return true;
        }
        this.mPlaySounds = oldPlaySound;
        return false;
    }

    @Override
    @NonNull
    protected FrameManager instantiateFrameManager() {
        return new FrameManager(2, this);
    }

    @Override
    public void onBufferAvailable(@NonNull byte[] buffer) {
        if (this.getEngineState() == 2) {
            this.mCamera.addCallbackBuffer(buffer);
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        if (data == null) {
            throw new RuntimeException("Camera1 returns null data from onPreviewFrame! This would make the frame processors crash later.");
        }
        Frame frame = this.getFrameManager().getFrame(data, System.currentTimeMillis(), this.getAngles().offset(Reference.SENSOR, Reference.OUTPUT, Axis.RELATIVE_TO_SENSOR));
        this.mCallback.dispatchFrame(frame);
    }

    @Override
    public void startAutoFocus(final @Nullable Gesture gesture, final @NonNull PointF point) {
        int viewWidth = 0;
        int viewHeight = 0;
        if (this.mPreview != null && this.mPreview.hasSurface()) {
            viewWidth = this.mPreview.getView().getWidth();
            viewHeight = this.mPreview.getView().getHeight();
        }
        final int viewWidthF = viewWidth;
        final int viewHeightF = viewHeight;
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                if (Camera1Engine.this.getEngineState() < 2) {
                    return;
                }
                if (!Camera1Engine.this.mCameraOptions.isAutoFocusSupported()) {
                    return;
                }
                final PointF p = new PointF(point.x, point.y);
                int offset = Camera1Engine.this.getAngles().offset(Reference.SENSOR, Reference.VIEW, Axis.ABSOLUTE);
                List meteringAreas2 = Camera1Engine.computeMeteringAreas(p.x, p.y, viewWidthF, viewHeightF, offset);
                List meteringAreas1 = meteringAreas2.subList(0, 1);
                Camera.Parameters params = Camera1Engine.this.mCamera.getParameters();
                int maxAF = params.getMaxNumFocusAreas();
                int maxAE = params.getMaxNumMeteringAreas();
                if (maxAF > 0) {
                    params.setFocusAreas(maxAF > 1 ? meteringAreas2 : meteringAreas1);
                }
                if (maxAE > 0) {
                    params.setMeteringAreas(maxAE > 1 ? meteringAreas2 : meteringAreas1);
                }
                params.setFocusMode("auto");
                Camera1Engine.this.mCamera.setParameters(params);
                Camera1Engine.this.mCallback.dispatchOnFocusStart(gesture, p);
                if (Camera1Engine.this.mFocusEndRunnable != null) {
                    Camera1Engine.this.mHandler.remove(Camera1Engine.this.mFocusEndRunnable);
                }
                Camera1Engine.this.mFocusEndRunnable = new Runnable(){

                    @Override
                    public void run() {
                        Camera1Engine.this.mCallback.dispatchOnFocusEnd(gesture, false, p);
                    }
                };
                Camera1Engine.this.mHandler.post(2500L, Camera1Engine.this.mFocusEndRunnable);
                try {
                    Camera1Engine.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                        public void onAutoFocus(boolean success, Camera camera) {
                            if (Camera1Engine.this.mFocusEndRunnable != null) {
                                Camera1Engine.this.mHandler.remove(Camera1Engine.this.mFocusEndRunnable);
                                Camera1Engine.this.mFocusEndRunnable = null;
                            }
                            Camera1Engine.this.mCallback.dispatchOnFocusEnd(gesture, success, p);
                            Camera1Engine.this.mHandler.remove(Camera1Engine.this.mFocusResetRunnable);
                            if (Camera1Engine.this.shouldResetAutoFocus()) {
                                Camera1Engine.this.mHandler.post(Camera1Engine.this.getAutoFocusResetDelay(), Camera1Engine.this.mFocusResetRunnable);
                            }
                        }
                    });
                }
                catch (RuntimeException e) {
                    LOG.e("startAutoFocus:", "Error calling autoFocus", e);
                }
            }
        });
    }

    @NonNull
    @WorkerThread
    private static List<Camera.Area> computeMeteringAreas(double viewClickX, double viewClickY, int viewWidth, int viewHeight, int sensorToDisplay) {
        int displayToSensor = -sensorToDisplay;
        viewClickX = -1000.0 + viewClickX / (double)viewWidth * 2000.0;
        viewClickY = -1000.0 + viewClickY / (double)viewHeight * 2000.0;
        double theta = (double)displayToSensor * Math.PI / 180.0;
        double sensorClickX = viewClickX * Math.cos(theta) - viewClickY * Math.sin(theta);
        double sensorClickY = viewClickX * Math.sin(theta) + viewClickY * Math.cos(theta);
        LOG.i("focus:", "viewClickX:", viewClickX, "viewClickY:", viewClickY);
        LOG.i("focus:", "sensorClickX:", sensorClickX, "sensorClickY:", sensorClickY);
        Rect rect1 = Camera1Engine.computeMeteringArea(sensorClickX, sensorClickY, 150.0);
        int weight1 = 1000;
        Rect rect2 = Camera1Engine.computeMeteringArea(sensorClickX, sensorClickY, 300.0);
        int weight2 = 100;
        ArrayList<Camera.Area> list = new ArrayList<Camera.Area>(2);
        list.add(new Camera.Area(rect1, weight1));
        list.add(new Camera.Area(rect2, weight2));
        return list;
    }

    @NonNull
    private static Rect computeMeteringArea(double centerX, double centerY, double size) {
        double delta = size / 2.0;
        int top = (int)Math.max(centerY - delta, -1000.0);
        int bottom = (int)Math.min(centerY + delta, 1000.0);
        int left = (int)Math.max(centerX - delta, -1000.0);
        int right = (int)Math.min(centerX + delta, 1000.0);
        LOG.i("focus:", "computeMeteringArea:", "top:", top, "left:", left, "bottom:", bottom, "right:", right);
        return new Rect(left, top, right, bottom);
    }
}

