/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.engine.CameraEngine;
import com.otaliastudios.cameraview.filter.Filter;
import com.otaliastudios.cameraview.internal.DeviceEncoders;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.overlay.OverlayDrawer;
import com.otaliastudios.cameraview.preview.GlCameraPreview;
import com.otaliastudios.cameraview.preview.RendererFrameCallback;
import com.otaliastudios.cameraview.preview.RendererThread;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.video.VideoRecorder;
import com.otaliastudios.cameraview.video.encoding.AudioConfig;
import com.otaliastudios.cameraview.video.encoding.AudioMediaEncoder;
import com.otaliastudios.cameraview.video.encoding.EncoderThread;
import com.otaliastudios.cameraview.video.encoding.MediaEncoderEngine;
import com.otaliastudios.cameraview.video.encoding.TextureConfig;
import com.otaliastudios.cameraview.video.encoding.TextureMediaEncoder;

@RequiresApi(api=18)
public class SnapshotVideoRecorder
extends VideoRecorder
implements RendererFrameCallback,
MediaEncoderEngine.Listener {
    private static final String TAG = SnapshotVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int DEFAULT_VIDEO_FRAMERATE = 30;
    private static final int DEFAULT_AUDIO_BITRATE = 64000;
    private static final int STATE_RECORDING = 0;
    private static final int STATE_NOT_RECORDING = 1;
    private MediaEncoderEngine mEncoderEngine;
    private GlCameraPreview mPreview;
    private int mCurrentState = 1;
    private int mDesiredState = 1;
    private int mTextureId = 0;
    private Overlay mOverlay;
    private OverlayDrawer mOverlayDrawer;
    private boolean mHasOverlay;
    private int mOverlayRotation;
    private Filter mCurrentFilter;

    private static int estimateVideoBitRate(@NonNull Size size, int frameRate) {
        return (int)(0.07f * (float)size.getWidth() * (float)size.getHeight() * (float)frameRate);
    }

    public SnapshotVideoRecorder(@NonNull CameraEngine engine, @NonNull GlCameraPreview preview, @Nullable Overlay overlay, int overlayRotation) {
        super(engine);
        this.mPreview = preview;
        this.mOverlay = overlay;
        this.mHasOverlay = overlay != null && overlay.drawsOn(Overlay.Target.VIDEO_SNAPSHOT);
        this.mOverlayRotation = overlayRotation;
    }

    @Override
    protected void onStart() {
        this.mPreview.addRendererFrameCallback(this);
        this.mDesiredState = 0;
    }

    @Override
    protected void onStop(boolean isCameraShutdown) {
        if (isCameraShutdown) {
            LOG.i("Stopping the encoder engine from isCameraShutdown.");
            this.mDesiredState = 1;
            this.mCurrentState = 1;
            this.mEncoderEngine.stop();
        } else {
            this.mDesiredState = 1;
        }
    }

    @Override
    @RendererThread
    public void onRendererTextureCreated(int textureId) {
        this.mTextureId = textureId;
        if (this.mHasOverlay) {
            this.mOverlayDrawer = new OverlayDrawer(this.mOverlay, this.mResult.size);
        }
    }

    @Override
    public void onRendererFilterChanged(@NonNull Filter filter) {
        this.mCurrentFilter = filter.copy();
        if (this.mEncoderEngine != null) {
            this.mCurrentFilter.setSize(this.mResult.size.getWidth(), this.mResult.size.getHeight());
            this.mEncoderEngine.notify("filter", this.mCurrentFilter);
        }
    }

    @Override
    @RendererThread
    public void onRendererFrame(@NonNull SurfaceTexture surfaceTexture, float scaleX, float scaleY) {
        if (this.mCurrentState == 1 && this.mDesiredState == 0) {
            LOG.i("Starting the encoder engine.");
            if (this.mResult.videoFrameRate <= 0) {
                this.mResult.videoFrameRate = 30;
            }
            if (this.mResult.videoBitRate <= 0) {
                this.mResult.videoBitRate = SnapshotVideoRecorder.estimateVideoBitRate(this.mResult.size, this.mResult.videoFrameRate);
            }
            if (this.mResult.audioBitRate <= 0) {
                this.mResult.audioBitRate = 64000;
            }
            String videoType = "";
            switch (this.mResult.videoCodec) {
                case H_263: {
                    videoType = "video/3gpp";
                    break;
                }
                case H_264: {
                    videoType = "video/avc";
                    break;
                }
                case DEVICE_DEFAULT: {
                    videoType = "video/avc";
                }
            }
            String audioType = "audio/mp4a-latm";
            DeviceEncoders deviceEncoders = new DeviceEncoders(videoType, audioType, 1);
            this.mResult.size = deviceEncoders.getSupportedVideoSize(this.mResult.size);
            this.mResult.videoBitRate = deviceEncoders.getSupportedVideoBitRate(this.mResult.videoBitRate);
            this.mResult.audioBitRate = deviceEncoders.getSupportedAudioBitRate(this.mResult.audioBitRate);
            this.mResult.videoFrameRate = deviceEncoders.getSupportedVideoFrameRate(this.mResult.size, this.mResult.videoFrameRate);
            TextureConfig videoConfig = new TextureConfig();
            videoConfig.width = this.mResult.size.getWidth();
            videoConfig.height = this.mResult.size.getHeight();
            videoConfig.bitRate = this.mResult.videoBitRate;
            videoConfig.frameRate = this.mResult.videoFrameRate;
            videoConfig.rotation = this.mResult.rotation;
            videoConfig.mimeType = videoType;
            videoConfig.encoder = deviceEncoders.getVideoEncoder();
            videoConfig.textureId = this.mTextureId;
            videoConfig.scaleX = scaleX;
            videoConfig.scaleY = scaleY;
            videoConfig.eglContext = EGL14.eglGetCurrentContext();
            if (this.mHasOverlay) {
                videoConfig.overlayTarget = Overlay.Target.VIDEO_SNAPSHOT;
                videoConfig.overlayDrawer = this.mOverlayDrawer;
                videoConfig.overlayRotation = this.mOverlayRotation;
            }
            TextureMediaEncoder videoEncoder = new TextureMediaEncoder(videoConfig);
            this.mResult.rotation = 0;
            this.mCurrentFilter.setSize(this.mResult.size.getWidth(), this.mResult.size.getWidth());
            AudioMediaEncoder audioEncoder = null;
            if (this.mResult.audio == Audio.ON || this.mResult.audio == Audio.MONO || this.mResult.audio == Audio.STEREO) {
                AudioConfig audioConfig = new AudioConfig();
                audioConfig.bitRate = this.mResult.audioBitRate;
                if (this.mResult.audio == Audio.MONO) {
                    audioConfig.channels = 1;
                }
                if (this.mResult.audio == Audio.STEREO) {
                    audioConfig.channels = 2;
                }
                audioConfig.encoder = deviceEncoders.getAudioEncoder();
                audioEncoder = new AudioMediaEncoder(audioConfig);
            }
            this.mEncoderEngine = new MediaEncoderEngine(this.mResult.file, videoEncoder, audioEncoder, this.mResult.maxDuration, this.mResult.maxSize, this);
            this.mEncoderEngine.notify("filter", this.mCurrentFilter);
            this.mEncoderEngine.start();
            this.mCurrentState = 0;
        }
        if (this.mCurrentState == 0) {
            LOG.v("dispatching frame.");
            TextureMediaEncoder textureEncoder = (TextureMediaEncoder)this.mEncoderEngine.getVideoEncoder();
            TextureMediaEncoder.Frame frame = textureEncoder.acquireFrame();
            frame.timestampNanos = surfaceTexture.getTimestamp();
            frame.timestampMillis = System.currentTimeMillis();
            surfaceTexture.getTransformMatrix(frame.transform);
            if (this.mEncoderEngine != null) {
                this.mEncoderEngine.notify("frame", frame);
            }
        }
        if (this.mCurrentState == 0 && this.mDesiredState == 1) {
            LOG.i("Stopping the encoder engine.");
            this.mCurrentState = 1;
            this.mEncoderEngine.stop();
        }
    }

    @Override
    public void onEncodingStart() {
        this.dispatchVideoRecordingStart();
    }

    @Override
    public void onEncodingStop() {
        this.dispatchVideoRecordingEnd();
    }

    @Override
    @EncoderThread
    public void onEncodingEnd(int stopReason, @Nullable Exception e) {
        if (e != null) {
            LOG.e("Error onEncodingEnd", e);
            this.mResult = null;
            this.mError = e;
        } else if (stopReason == 1) {
            LOG.i("onEncodingEnd because of max duration.");
            this.mResult.endReason = 2;
        } else if (stopReason == 2) {
            LOG.i("onEncodingEnd because of max size.");
            this.mResult.endReason = 1;
        } else {
            LOG.i("onEncodingEnd because of user.");
        }
        this.mCurrentState = 1;
        this.mDesiredState = 1;
        this.mPreview.removeRendererFrameCallback(this);
        this.mPreview = null;
        if (this.mOverlayDrawer != null) {
            this.mOverlayDrawer.release();
            this.mOverlayDrawer = null;
        }
        this.mEncoderEngine = null;
        this.dispatchResult();
    }
}

