/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.video;

import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.internal.DeviceEncoders;
import com.otaliastudios.cameraview.video.VideoRecorder;

public abstract class FullVideoRecorder
extends VideoRecorder {
    private static final String TAG = FullVideoRecorder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    protected MediaRecorder mMediaRecorder;
    protected CamcorderProfile mProfile;
    private boolean mMediaRecorderPrepared;

    FullVideoRecorder(@Nullable VideoRecorder.VideoResultListener listener) {
        super(listener);
    }

    protected boolean prepareMediaRecorder(@NonNull VideoResult.Stub stub) {
        if (this.mMediaRecorderPrepared) {
            return true;
        }
        return this.onPrepareMediaRecorder(stub, new MediaRecorder());
    }

    protected boolean onPrepareMediaRecorder(@NonNull VideoResult.Stub stub, @NonNull MediaRecorder mediaRecorder) {
        boolean flip;
        String videoType;
        String audioType;
        boolean hasAudio;
        this.mMediaRecorder = mediaRecorder;
        boolean bl = hasAudio = stub.audio == Audio.ON || stub.audio == Audio.MONO || stub.audio == Audio.STEREO;
        if (hasAudio) {
            this.mMediaRecorder.setAudioSource(0);
        }
        this.mMediaRecorder.setOutputFormat(this.mProfile.fileFormat);
        switch (this.mProfile.audioCodec) {
            case 1: {
                audioType = "audio/3gpp";
                break;
            }
            case 2: {
                audioType = "audio/amr-wb";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                audioType = "audio/mp4a-latm";
                break;
            }
            case 6: {
                audioType = "audio/vorbis";
                break;
            }
            default: {
                audioType = "audio/3gpp";
            }
        }
        if (stub.videoCodec == VideoCodec.H_264) {
            this.mProfile.videoCodec = 2;
        }
        if (stub.videoCodec == VideoCodec.H_263) {
            this.mProfile.videoCodec = 1;
        }
        switch (this.mProfile.videoCodec) {
            case 1: {
                videoType = "video/3gpp";
                break;
            }
            case 2: {
                videoType = "video/avc";
                break;
            }
            case 3: {
                videoType = "video/mp4v-es";
                break;
            }
            case 4: {
                videoType = "video/x-vnd.on2.vp8";
                break;
            }
            case 5: {
                videoType = "video/hevc";
                break;
            }
            default: {
                videoType = "video/avc";
            }
        }
        stub.videoFrameRate = stub.videoFrameRate > 0 ? stub.videoFrameRate : this.mProfile.videoFrameRate;
        int n = stub.videoBitRate = stub.videoBitRate > 0 ? stub.videoBitRate : this.mProfile.videoBitRate;
        if (hasAudio) {
            stub.audioBitRate = stub.audioBitRate > 0 ? stub.audioBitRate : this.mProfile.audioBitRate;
        }
        DeviceEncoders encoders = new DeviceEncoders(videoType, audioType, 0);
        boolean bl2 = flip = stub.rotation % 180 != 0;
        if (flip) {
            stub.size = stub.size.flip();
        }
        stub.size = encoders.getSupportedVideoSize(stub.size);
        stub.videoBitRate = encoders.getSupportedVideoBitRate(stub.videoBitRate);
        stub.audioBitRate = encoders.getSupportedAudioBitRate(stub.audioBitRate);
        stub.videoFrameRate = encoders.getSupportedVideoFrameRate(stub.size, stub.videoFrameRate);
        if (flip) {
            stub.size = stub.size.flip();
        }
        this.mMediaRecorder.setVideoSize(flip ? stub.size.getHeight() : stub.size.getWidth(), flip ? stub.size.getWidth() : stub.size.getHeight());
        this.mMediaRecorder.setVideoFrameRate(stub.videoFrameRate);
        this.mMediaRecorder.setVideoEncoder(this.mProfile.videoCodec);
        this.mMediaRecorder.setVideoEncodingBitRate(stub.videoBitRate);
        if (hasAudio) {
            if (stub.audio == Audio.ON) {
                this.mMediaRecorder.setAudioChannels(this.mProfile.audioChannels);
            } else if (stub.audio == Audio.MONO) {
                this.mMediaRecorder.setAudioChannels(1);
            } else if (stub.audio == Audio.STEREO) {
                this.mMediaRecorder.setAudioChannels(2);
            }
            this.mMediaRecorder.setAudioSamplingRate(this.mProfile.audioSampleRate);
            this.mMediaRecorder.setAudioEncoder(this.mProfile.audioCodec);
            this.mMediaRecorder.setAudioEncodingBitRate(stub.audioBitRate);
        }
        if (stub.location != null) {
            this.mMediaRecorder.setLocation((float)stub.location.getLatitude(), (float)stub.location.getLongitude());
        }
        this.mMediaRecorder.setOutputFile(stub.file.getAbsolutePath());
        this.mMediaRecorder.setOrientationHint(stub.rotation);
        this.mMediaRecorder.setMaxFileSize(stub.maxSize);
        this.mMediaRecorder.setMaxDuration(stub.maxDuration);
        this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

            public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                switch (what) {
                    case 800: {
                        FullVideoRecorder.this.mResult.endReason = 2;
                        FullVideoRecorder.this.stop(false);
                        break;
                    }
                    case 801: {
                        FullVideoRecorder.this.mResult.endReason = 1;
                        FullVideoRecorder.this.stop(false);
                    }
                }
            }
        });
        try {
            this.mMediaRecorder.prepare();
            this.mMediaRecorderPrepared = true;
            this.mError = null;
            return true;
        }
        catch (Exception e) {
            LOG.w("prepareMediaRecorder:", "Error while preparing media recorder.", e);
            this.mMediaRecorderPrepared = false;
            this.mError = e;
            return false;
        }
    }

    @Override
    protected void onStart() {
        if (!this.prepareMediaRecorder(this.mResult)) {
            this.mResult = null;
            this.stop(false);
            return;
        }
        try {
            this.mMediaRecorder.start();
            this.dispatchVideoRecordingStart();
        }
        catch (Exception e) {
            LOG.w("start:", "Error while starting media recorder.", e);
            this.mResult = null;
            this.mError = e;
            this.stop(false);
        }
    }

    @Override
    protected void onStop(boolean isCameraShutdown) {
        if (this.mMediaRecorder != null) {
            block3: {
                this.dispatchVideoRecordingEnd();
                try {
                    this.mMediaRecorder.stop();
                }
                catch (Exception e) {
                    LOG.w("stop:", "Error while closing media recorder.", e);
                    this.mResult = null;
                    if (this.mError != null) break block3;
                    this.mError = e;
                }
            }
            this.mMediaRecorder.release();
        }
        this.mProfile = null;
        this.mMediaRecorder = null;
        this.mMediaRecorderPrepared = false;
        this.dispatchResult();
    }
}

